/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Graphics2DUtil {
    private static final String FONT_FAMILY = "\u6977\u4f53";

    public static void graphics2DDraw(String srcImgPath, String outPath, String text) {
        try {
            BufferedImage targetImg = ImageIO.read(new File(srcImgPath));
            int imgWidth = targetImg.getWidth();
            int imgHeight = targetImg.getHeight();
            BufferedImage bufferedImage = new BufferedImage(imgWidth, imgHeight, 4);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(targetImg, 0, 0, imgWidth, imgHeight, null);
            g.setColor(Color.RED);
            Font userNameFont = new Font(FONT_FAMILY, 0, 60);
            g.setFont(userNameFont);
            int[] userNameSize = Graphics2DUtil.getContentSize(userNameFont, text);
            int userNameLeftMargin = (imgWidth - userNameSize[0]) / 2;
            int userNameTopMargin = userNameFont.getSize();
            g.drawString(text, userNameLeftMargin, userNameTopMargin);
            g.dispose();
            FileOutputStream outImgStream = new FileOutputStream(outPath);
            ImageIO.write((RenderedImage)bufferedImage, "png", outImgStream);
            g.dispose();
        }
        catch (IOException e) {
            e.getStackTrace();
        }
    }

    public static int[] getContentSize(Font font, String content) {
        int[] contentSize = new int[2];
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        Rectangle rec = font.getStringBounds(content, frc).getBounds();
        contentSize[0] = (int)rec.getWidth();
        contentSize[1] = (int)rec.getHeight();
        return contentSize;
    }

    public static void main(String[] args) throws IOException {
        String projectPath = System.getProperty("user.dir");
        String testUrl = "F:\\2024\\~535.JPG";
        String text = "\u6d4b\u8bd5\u6dfb\u52a0\u6c34\u537023";
        Graphics2DUtil.graphics2DDraw(testUrl, testUrl, text);
    }
}

