/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.model.bankcard.EcsBankCardCrForm;
import com.bringspring.ecs.model.bankcard.EcsBankCardInfoVO;
import com.bringspring.ecs.model.bankcard.EcsBankCardListVO;
import com.bringspring.ecs.model.bankcard.EcsBankCardPagination;
import com.bringspring.ecs.model.bankcard.EcsBankCardUpForm;
import com.bringspring.ecs.service.EcsBankCardService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d39\u63a7\u94f6\u884c\u5361\u7ba1\u7406"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsBankCard"})
public class EcsBankCardController {
    private static final Logger log = LoggerFactory.getLogger(EcsBankCardController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsBankCardService ecsBankCardService;

    @PostMapping(value={"/getList"})
    public ActionResult<?> list(@RequestBody EcsBankCardPagination ecsBankCardPagination) throws IOException {
        List<EcsBankCardEntity> list = this.ecsBankCardService.getList(ecsBankCardPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsBankCardListVO.class);
        for (EcsBankCardListVO q : listVO) {
            q.setCreatorUserName(this.baseDataUtil.userSelectValue(q.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsBankCardPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getAuthList"})
    public ActionResult<?> authList(@RequestBody EcsBankCardPagination ecsBankCardPagination) throws IOException {
        List<EcsBankCardEntity> list = this.ecsBankCardService.getAuthList(ecsBankCardPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsBankCardListVO.class);
        for (EcsBankCardListVO q : listVO) {
            q.setCreatorUserName(this.baseDataUtil.userSelectValue(q.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsBankCardPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult<?> create(@RequestBody @Valid EcsBankCardCrForm ecsBankCardCrForm) throws DataException {
        this.ecsBankCardService.create(ecsBankCardCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsBankCardInfoVO> info(@PathVariable(value="id") String id) {
        EcsBankCardEntity entity = this.ecsBankCardService.getInfo(id);
        EcsBankCardInfoVO vo = (EcsBankCardInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBankCardInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsBankCardInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsBankCardEntity entity = this.ecsBankCardService.getInfo(id);
        EcsBankCardInfoVO vo = (EcsBankCardInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBankCardInfoVO.class);
        vo.setCardType(this.baseDataUtil.getDictName(vo.getCardType(), "cardType"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> update(@PathVariable(value="id") String id, @RequestBody @Valid EcsBankCardUpForm ecsBankCardUpForm) throws DataException {
        this.ecsBankCardService.update(id, ecsBankCardUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> delete(@PathVariable(value="id") String id) {
        EcsBankCardEntity entity = this.ecsBankCardService.getInfo(id);
        if (entity != null) {
            this.ecsBankCardService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"getBankCardByUserId"})
    public ActionResult<?> getBankCardByUserId(String userId) {
        EcsBankCardEntity entity = this.ecsBankCardService.getBankCardByUserId(userId);
        if (entity == null) {
            return ActionResult.success();
        }
        EcsBankCardInfoVO vo = (EcsBankCardInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBankCardInfoVO.class);
        return ActionResult.success((Object)vo);
    }
}

