/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBudgetAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountRecordEntity;
import com.bringspring.ecs.enums.BudgetRecordOperateTypeEnum;
import com.bringspring.ecs.model.ecsbudgetorganizeaccountrecord.EcsBudgetOrganizeAccountRecordCrForm;
import com.bringspring.ecs.model.ecsbudgetorganizeaccountrecord.EcsBudgetOrganizeAccountRecordInfoVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccountrecord.EcsBudgetOrganizeAccountRecordListVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccountrecord.EcsBudgetOrganizeAccountRecordPagination;
import com.bringspring.ecs.model.ecsbudgetorganizeaccountrecord.EcsBudgetOrganizeAccountRecordUpForm;
import com.bringspring.ecs.service.EcsBudgetAccountService;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountRecordService;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9884\u7b97\u8d39\u7528\u64cd\u4f5c\u8bb0\u5f55\u8868"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsBudgetOrganizeAccountRecord"})
public class EcsBudgetOrganizeAccountRecordController {
    private static final Logger log = LoggerFactory.getLogger(EcsBudgetOrganizeAccountRecordController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsBudgetAccountService accountService;
    @Autowired
    private EcsBudgetOrganizeAccountService organizeAccountService;
    @Autowired
    private EcsBudgetOrganizeAccountRecordService ecsBudgetOrganizeAccountRecordService;

    @PostMapping(value={"/getList"})
    public ActionResult<?> list(@RequestBody EcsBudgetOrganizeAccountRecordPagination ecsBudgetOrganizeAccountRecordPagination) throws IOException {
        List<EcsBudgetOrganizeAccountRecordEntity> list = this.ecsBudgetOrganizeAccountRecordService.getList(ecsBudgetOrganizeAccountRecordPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsBudgetOrganizeAccountRecordListVO.class);
        for (EcsBudgetOrganizeAccountRecordListVO vo : listVO) {
            EcsBudgetOrganizeAccountEntity accountEntity = (EcsBudgetOrganizeAccountEntity)this.organizeAccountService.getById((Serializable)((Object)vo.getOrgAccountId()));
            EcsBudgetAccountEntity info = this.accountService.getInfo(accountEntity.getProject());
            vo.setCreatorUserId(this.baseDataUtil.userSelectValues(vo.getCreatorUserId()));
            vo.setOrgAccountName(info.getFullName());
            vo.setOperateTypeName(BudgetRecordOperateTypeEnum.getDescByCode(vo.getOperateType()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsBudgetOrganizeAccountRecordPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcsBudgetOrganizeAccountRecordCrForm ecsBudgetOrganizeAccountRecordCrForm) throws DataException {
        this.ecsBudgetOrganizeAccountRecordService.create(ecsBudgetOrganizeAccountRecordCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsBudgetOrganizeAccountRecordInfoVO> info(@PathVariable(value="id") String id) {
        EcsBudgetOrganizeAccountRecordEntity entity = this.ecsBudgetOrganizeAccountRecordService.getInfo(id);
        EcsBudgetOrganizeAccountRecordInfoVO vo = (EcsBudgetOrganizeAccountRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetOrganizeAccountRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsBudgetOrganizeAccountRecordInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsBudgetOrganizeAccountRecordEntity entity = this.ecsBudgetOrganizeAccountRecordService.getInfo(id);
        EcsBudgetOrganizeAccountRecordInfoVO vo = (EcsBudgetOrganizeAccountRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetOrganizeAccountRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsBudgetOrganizeAccountRecordUpForm ecsBudgetOrganizeAccountRecordUpForm) throws DataException {
        this.ecsBudgetOrganizeAccountRecordService.update(id, ecsBudgetOrganizeAccountRecordUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsBudgetOrganizeAccountRecordEntity entity = this.ecsBudgetOrganizeAccountRecordService.getInfo(id);
        if (entity != null) {
            this.ecsBudgetOrganizeAccountRecordService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

