/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsPaymentCategoriesEntity;
import com.bringspring.ecs.model.ecspaymentcategories.EcsPaymentCategoriesCrForm;
import com.bringspring.ecs.model.ecspaymentcategories.EcsPaymentCategoriesInfoVO;
import com.bringspring.ecs.model.ecspaymentcategories.EcsPaymentCategoriesListVO;
import com.bringspring.ecs.model.ecspaymentcategories.EcsPaymentCategoriesPagination;
import com.bringspring.ecs.model.ecspaymentcategories.EcsPaymentCategoriesUpForm;
import com.bringspring.ecs.model.records.EcsRecordsPaymentVO;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsPaymentCategoriesService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e0d\u540c\u7c7b\u578b\u4ed8\u6b3e\u8bb0\u5f55"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcspaymentCategories"})
public class EcsPaymentCategoriesController {
    private static final Logger log = LoggerFactory.getLogger(EcsPaymentCategoriesController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsPaymentCategoriesService ecspaymentCategoriesService;
    @Autowired
    private EcsCompanyService ecsCompanyService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u4e0d\u540c\u7c7b\u578b\u4ed8\u6b3e\u8bb0\u5f55\u5217\u8868")
    public ActionResult list(@RequestBody EcsPaymentCategoriesPagination ecspaymentCategoriesPagination) throws IOException, WorkFlowException {
        String userId = this.userProvider.get().getUserId();
        List<EcsPaymentCategoriesEntity> list = this.ecspaymentCategoriesService.getList(ecspaymentCategoriesPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsPaymentCategoriesListVO.class);
        for (EcsPaymentCategoriesListVO infoVO : listVO) {
            infoVO.setCompanyName(this.baseDataUtil.comSelectValues(infoVO.getCompanyId()));
            infoVO.setReimbCompanyName(this.ecsCompanyService.getNameById(infoVO.getReimbCompany()));
            infoVO.setAuditStatusName(this.baseDataUtil.getDictName(infoVO.getAuditStatus(), "EcsRecordStatus"));
            FlowTaskEntity flowTaskEntity = this.flowTaskService.getDraftTaskByProcessId(infoVO.getSourceId());
            if (flowTaskEntity == null) continue;
            FlowTaskNodeEntity flowTaskNode = (FlowTaskNodeEntity)this.flowTaskNodeService.getById((Serializable)((Object)flowTaskEntity.getThisStepId()));
            String taskOperatorId = "";
            if (flowTaskNode != null) {
                List operatorEntities = this.flowTaskOperatorService.getListByNode(flowTaskEntity.getId(), flowTaskNode.getId());
                for (FlowTaskOperatorEntity operatorEntity : operatorEntities) {
                    if (!userId.equals(operatorEntity.getHandleId())) continue;
                    taskOperatorId = operatorEntity.getId();
                }
            }
            infoVO.setTaskId(flowTaskEntity.getId());
            infoVO.setTaskNodeId(flowTaskEntity.getThisStepId());
            infoVO.setTaskOperatorId(taskOperatorId);
            infoVO.setFlowState(flowTaskEntity.getStatus());
            infoVO.setFlowId(flowTaskEntity.getFlowId());
            infoVO.setEnCode(flowTaskEntity.getFlowCode());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecspaymentCategoriesPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getSummaryInformation"})
    public ActionResult<?> getSummaryInformation(@RequestBody EcsPaymentCategoriesPagination pagination) {
        Map<String, Object> maps = this.ecspaymentCategoriesService.getSummaryInformation(pagination);
        return ActionResult.success(maps);
    }

    @PostMapping(value={"/countByState"})
    public ActionResult<?> countByEnabledMark(@RequestBody EcsPaymentCategoriesPagination ecsRecordsPagination) {
        List<Map<String, Object>> maps = this.ecspaymentCategoriesService.countByState(ecsRecordsPagination);
        return ActionResult.success(maps);
    }

    @ApiOperation(value="\u4e0d\u540c\u7c7b\u578b\u4ed8\u6b3e\u8bb0\u5f55\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid EcsPaymentCategoriesCrForm ecspaymentCategoriesCrForm) throws DataException {
        this.ecspaymentCategoriesService.create(ecspaymentCategoriesCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u4e0d\u540c\u7c7b\u578b\u4ed8\u6b3e\u8bb0\u5f55\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<EcsPaymentCategoriesInfoVO> info(@PathVariable(value="id") String id) {
        EcsPaymentCategoriesEntity entity = this.ecspaymentCategoriesService.getInfo(id);
        EcsPaymentCategoriesInfoVO vo = (EcsPaymentCategoriesInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsPaymentCategoriesInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4e0d\u540c\u7c7b\u578b\u4ed8\u6b3e\u8bb0\u5f55\u8868\u5355\u4fe1\u606f(\u8be6\u60c5\u9875)")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsPaymentCategoriesInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsPaymentCategoriesEntity entity = this.ecspaymentCategoriesService.getInfo(id);
        EcsPaymentCategoriesInfoVO vo = (EcsPaymentCategoriesInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsPaymentCategoriesInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4e0d\u540c\u7c7b\u578b\u4ed8\u6b3e\u8bb0\u5f55\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsPaymentCategoriesUpForm ecspaymentCategoriesUpForm) throws DataException {
        this.ecspaymentCategoriesService.update(id, ecspaymentCategoriesUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"/batchReviewPayment"})
    @DSTransactional
    public ActionResult<?> batchReviewPayment(@RequestBody EcsRecordsPaymentVO paymentVO) {
        return this.ecspaymentCategoriesService.batchReviewPayment(paymentVO);
    }

    @PostMapping(value={"/batchReview"})
    @DSTransactional
    public ActionResult<?> batchReview(@RequestBody List<String> ids) throws DataException {
        this.ecspaymentCategoriesService.batchReview(ids);
        return ActionResult.success((String)"\u63d0\u4ea4\u4ed8\u6b3e\u590d\u6838\u6210\u529f");
    }

    @ApiOperation(value="\u4e0d\u540c\u7c7b\u578b\u4ed8\u6b3e\u8bb0\u5f55\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsPaymentCategoriesEntity entity = this.ecspaymentCategoriesService.getInfo(id);
        if (entity != null) {
            this.ecspaymentCategoriesService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

