/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.docking.enums.PayStateEnums;
import com.bringspring.ecs.entity.EcsPaymentRecordsEntity;
import com.bringspring.ecs.enums.VoucherPushStateEnum;
import com.bringspring.ecs.model.ecspaymentrecords.EcsPaymentRecordsCrForm;
import com.bringspring.ecs.model.ecspaymentrecords.EcsPaymentRecordsInfoVO;
import com.bringspring.ecs.model.ecspaymentrecords.EcsPaymentRecordsListVO;
import com.bringspring.ecs.model.ecspaymentrecords.EcsPaymentRecordsPagination;
import com.bringspring.ecs.model.ecspaymentrecords.EcsPaymentRecordsUpForm;
import com.bringspring.ecs.service.EcsPaymentRecordsService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53f8\u5e93\u4ed8\u6b3e\u8bb0\u5f55"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsPaymentRecords"})
public class EcsPaymentRecordsController {
    private static final Logger log = LoggerFactory.getLogger(EcsPaymentRecordsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsPaymentRecordsService ecsPaymentRecordsService;
    @Autowired
    private EcsRecordsService recordsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsPaymentRecordsPagination ecsPaymentRecordsPagination) throws IOException {
        List<EcsPaymentRecordsEntity> list = this.ecsPaymentRecordsService.getList(ecsPaymentRecordsPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsPaymentRecordsListVO.class);
        for (EcsPaymentRecordsListVO vo : listVO) {
            vo.setPayState(PayStateEnums.getDescByCode(vo.getPayState()));
            if (!StrUtil.isNotBlank((CharSequence)vo.getPayVoucherStatus())) continue;
            vo.setPayVoucherStatus(VoucherPushStateEnum.getDescByCode(vo.getPayVoucherStatus()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsPaymentRecordsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid EcsPaymentRecordsCrForm ecsPaymentRecordsCrForm) throws DataException {
        this.ecsPaymentRecordsService.create(ecsPaymentRecordsCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsPaymentRecordsInfoVO> info(@PathVariable(value="id") String id) {
        EcsPaymentRecordsEntity entity = this.ecsPaymentRecordsService.getInfo(id);
        EcsPaymentRecordsInfoVO vo = (EcsPaymentRecordsInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsPaymentRecordsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getFile"})
    public ActionResult<EcsPaymentRecordsInfoVO> getFile(@RequestBody EcsPaymentRecordsPagination recordsPagination) {
        EcsPaymentRecordsEntity entity = this.ecsPaymentRecordsService.getPaymentRecord(recordsPagination.getSourceId());
        EcsPaymentRecordsInfoVO vo = (EcsPaymentRecordsInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsPaymentRecordsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsPaymentRecordsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsPaymentRecordsEntity entity = this.ecsPaymentRecordsService.getInfo(id);
        EcsPaymentRecordsInfoVO vo = (EcsPaymentRecordsInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsPaymentRecordsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsPaymentRecordsUpForm ecsPaymentRecordsUpForm) throws DataException {
        this.ecsPaymentRecordsService.update(id, ecsPaymentRecordsUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsPaymentRecordsEntity entity = this.ecsPaymentRecordsService.getInfo(id);
        if (entity != null) {
            this.ecsPaymentRecordsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

