/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.ecs.entity.EcsProjectEntity;
import com.bringspring.ecs.model.ecsproject.EcsProjectCrForm;
import com.bringspring.ecs.model.ecsproject.EcsProjectInfoVO;
import com.bringspring.ecs.model.ecsproject.EcsProjectListVO;
import com.bringspring.ecs.model.ecsproject.EcsProjectPagination;
import com.bringspring.ecs.model.ecsproject.EcsProjectPaginationExportModel;
import com.bringspring.ecs.model.ecsproject.EcsProjectUpForm;
import com.bringspring.ecs.service.EcsProjectService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d39\u63a7\u8d39\u7528\u9879\u76ee\u8868"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsProject"})
public class EcsProjectController {
    private static final Logger log = LoggerFactory.getLogger(EcsProjectController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsProjectService ecsProjectService;

    @PostMapping(value={"/getList"})
    public ActionResult<?> list(@RequestBody EcsProjectPagination ecsProjectPagination) throws IOException {
        List<EcsProjectEntity> list = this.ecsProjectService.getList(ecsProjectPagination);
        for (EcsProjectEntity entity : list) {
            entity.setManager(this.baseDataUtil.userSelectValues(entity.getManager()));
            entity.setDirector(this.baseDataUtil.userSelectValues(entity.getDirector()));
            entity.setProjectCity(this.baseDataUtil.provinceData(entity.getProjectCity()));
        }
        List listVO = JsonUtil.getJsonToList(list, EcsProjectListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsProjectPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/treeList"})
    public ActionResult<?> treeList(@RequestBody EcsProjectPagination ecsProjectPagination) {
        List<EcsProjectEntity> list = this.ecsProjectService.getVisibleList(ecsProjectPagination);
        List collect = list.stream().map(entity -> {
            TreeNode treeNode = new TreeNode((Object)entity.getId(), (Object)entity.getParentId(), entity.getName(), null);
            HashMap<String, String> extraMap = new HashMap<String, String>();
            extraMap.put("code", entity.getCode());
            extraMap.put("parentCode", entity.getParentCode());
            extraMap.put("parentName", entity.getParentName());
            extraMap.put("englishName", entity.getEnglishName());
            extraMap.put("projectType", entity.getProjectType());
            extraMap.put("projectCity", entity.getProjectCity());
            treeNode.setExtra(extraMap);
            return treeNode;
        }).collect(Collectors.toList());
        List build = TreeUtil.build(collect, (Object)"0");
        return ActionResult.success((Object)build);
    }

    @PostMapping
    @DSTransactional
    public ActionResult<?> create(@RequestBody @Valid EcsProjectCrForm ecsProjectCrForm) throws DataException {
        this.ecsProjectService.create(ecsProjectCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult<?> Export(EcsProjectPaginationExportModel ecsProjectPaginationExportModel) {
        if (StringUtils.isEmpty((String)ecsProjectPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        EcsProjectPagination ecsProjectPagination = (EcsProjectPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)ecsProjectPaginationExportModel), EcsProjectPagination.class));
        List<EcsProjectEntity> list = this.ecsProjectService.getTypeList(ecsProjectPagination, ecsProjectPaginationExportModel.getDataType());
        for (EcsProjectEntity entity : list) {
            EcsProjectEntity byId;
            entity.setManager(this.baseDataUtil.userSelectValues(entity.getManager()));
            entity.setDirector(this.baseDataUtil.userSelectValues(entity.getDirector()));
            if (StringUtils.isNotEmpty((String)entity.getParentCode()) && !"0".equals(entity.getParentCode()) && (byId = (EcsProjectEntity)this.ecsProjectService.getById((Serializable)((Object)entity.getParentCode()))) != null) {
                entity.setParentCode(byId.getName());
            }
            if (!"0".equals(entity.getParentCode())) continue;
            entity.setParentCode("");
        }
        List listVO = JsonUtil.getJsonToList(list, EcsProjectListVO.class);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)ecsProjectPaginationExportModel.getSelectKey()) ? ecsProjectPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        String[] stringArray = keys;
        int n = stringArray.length;
        block28: for (int i = 0; i < n; ++i) {
            String key;
            switch (key = stringArray[i]) {
                case "code": {
                    entitys.add(new ExcelExportEntity("\u7f16\u7801", (Object)"code"));
                    continue block28;
                }
                case "name": {
                    entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"name"));
                    continue block28;
                }
                case "englishName": {
                    entitys.add(new ExcelExportEntity("\u82f1\u6587\u540d\u79f0", (Object)"englishName"));
                    continue block28;
                }
                case "parentId": {
                    entitys.add(new ExcelExportEntity("\u6240\u5c5e\u4e0a\u7ea7", (Object)"parentId"));
                    continue block28;
                }
                case "projectType": {
                    entitys.add(new ExcelExportEntity("\u9879\u76ee\u7c7b\u578b", (Object)"projectType"));
                    continue block28;
                }
                case "projectCity": {
                    entitys.add(new ExcelExportEntity("\u9879\u76ee\u6240\u5728\u5730", (Object)"projectCity"));
                    continue block28;
                }
                case "manager": {
                    entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"manager"));
                    continue block28;
                }
                case "director": {
                    entitys.add(new ExcelExportEntity("\u9879\u76ee\u603b\u76d1", (Object)"director"));
                    continue block28;
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (!entitys.isEmpty()) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = path + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef", (Throwable)e);
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsProjectInfoVO> info(@PathVariable(value="id") String id) {
        EcsProjectEntity entity = this.ecsProjectService.getInfo(id);
        EcsProjectInfoVO vo = (EcsProjectInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsProjectInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsProjectInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsProjectEntity entity = this.ecsProjectService.getInfo(id);
        EcsProjectInfoVO vo = (EcsProjectInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsProjectInfoVO.class);
        vo.setProjectCity(this.baseDataUtil.provinceData(vo.getProjectCity()));
        vo.setManager(this.baseDataUtil.userSelectValues(vo.getManager()));
        vo.setDirector(this.baseDataUtil.userSelectValues(vo.getDirector()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> update(@PathVariable(value="id") String id, @RequestBody @Valid EcsProjectUpForm ecsProjectUpForm) throws DataException {
        this.ecsProjectService.update(id, ecsProjectUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> delete(@PathVariable(value="id") String id) {
        EcsProjectEntity entity = this.ecsProjectService.getInfo(id);
        if (entity != null) {
            this.ecsProjectService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

