/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.ecs.docking.entity.vo.ConfirmIncomeRequest;
import com.bringspring.ecs.docking.service.VoucherPushService;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.exception.VoucherPushException;
import com.bringspring.ecs.service.EcsPaymentRecordsService;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u51ed\u8bc1\u63a8\u9001"}, value="ecs")
@RequestMapping(value={"/api/ecs/vocher"})
public class EcsVocherPushController {
    private static final Logger log = LoggerFactory.getLogger(EcsVocherPushController.class);
    @Autowired
    private VoucherPushService voucherPushService;
    @Autowired
    private EcsPaymentRecordsService paymentRecordsService;

    @PostMapping(value={"/push"})
    public ActionResult push(@RequestBody EcsRecordsEntity entity) throws VoucherPushException {
        return ActionResult.success((Object)this.voucherPushService.pushVoucher(entity.getId()));
    }

    @PostMapping(value={"/pushPay"})
    public ActionResult pushPay(@RequestBody EcsRecordsEntity entity) throws VoucherPushException {
        this.voucherPushService.pushPayVoucher(entity.getId());
        this.paymentRecordsService.updatePaymentRecepit(entity.getOrderNumber(), "[{\"fileDigest\":\"1a443cef9d39edf3cf0d937e4f76468c\",\"fileId\":\"20250325_674353491166110341.pdf\",\"name\":\"20250324SE282044596203000001.pdf\",\"secondFilePath\":\"2025/03/25/ecs/\",\"url\":\"/api/file/Image/annex/2025/03/25/ecs/20250325_674353491166110341.pdf\"}]");
        return ActionResult.success();
    }

    @PostMapping(value={"/pushRev"})
    public ActionResult pushRev(@RequestBody ConfirmIncomeRequest confirmIncomeRequest) throws VoucherPushException {
        this.voucherPushService.pushRevenueVoucher(confirmIncomeRequest);
        return ActionResult.success();
    }
}

