/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.controller;

import cn.hutool.core.bean.BeanUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.model.UploaderVO;
import com.bringspring.common.util.FileUtil;
import com.bringspring.ecs.docking.service.SkPaymentService;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsUploadVO;
import com.bringspring.ecs.utils.Base64ToFileUtil;
import com.bringspring.ecs.utils.UploadFiles;
import io.swagger.annotations.Api;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u53f8\u5e93"}, value="ecs")
@RequestMapping(value={"/api/ecs/sk"})
public class EcsZxSkApiController {
    private static final Logger log = LoggerFactory.getLogger(EcsZxSkApiController.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UploadFiles uploadFiles;
    @Autowired
    private SkPaymentService skPaymentService;

    @PostMapping(value={"/payment"})
    public ActionResult<?> payment(@RequestBody EcsRecordsEntity recordsEntity) {
        return ActionResult.success();
    }

    @PostMapping(value={"/check"})
    public ActionResult<?> check(@RequestBody EcsRecordsEntity recordsEntity) {
        this.skPaymentService.singlePaymentCheck(recordsEntity.getId());
        return ActionResult.success();
    }

    @PostMapping(value={"/qurey"})
    public ActionResult<?> qurey(@RequestBody Map<String, String> map) {
        this.skPaymentService.receiptApply(map.get("acc"));
        return ActionResult.success();
    }

    @PostMapping(value={"/history"})
    public ActionResult<?> history(@RequestBody Map<String, String> map) {
        this.skPaymentService.HistoryDetailApply(map.get("companyId"), map.get("acc"));
        return ActionResult.success();
    }

    @PostMapping(value={"/down"})
    public ActionResult<?> down(@RequestBody Map<String, String> param) {
        try {
            String base64EncodedString = param.get("str");
            String outputDirectory = this.configValueUtil.getTemporaryFilePath();
            List<File> files = Base64ToFileUtil.decodeAndUnzip(base64EncodedString, outputDirectory);
            ArrayList ecsUploadVOS = new ArrayList();
            files.forEach(file -> {
                MultipartFile fileItem = FileUtil.createFileItem((File)file);
                UploaderVO uploader = this.uploadFiles.uploader(fileItem, "ecs", "annex");
                EcsUploadVO ecsUploadVO = new EcsUploadVO();
                BeanUtil.copyProperties((Object)uploader, (Object)ecsUploadVO, (String[])new String[0]);
                ecsUploadVO.setName(file.getName());
                ecsUploadVO.setFileId(uploader.getName());
                ecsUploadVOS.add(ecsUploadVO);
            });
            return ActionResult.success(ecsUploadVOS);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ActionResult.success();
        }
    }
}

