/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.model.UploaderVO;
import com.bringspring.common.util.FileUtil;
import com.bringspring.ecs.docking.entity.sk.history.HistoryApplyStream;
import com.bringspring.ecs.docking.entity.sk.history.HistoryQueryStream;
import com.bringspring.ecs.docking.entity.sk.history.ResDataList;
import com.bringspring.ecs.docking.entity.sk.history.ResRow;
import com.bringspring.ecs.docking.entity.sk.history.ResStream;
import com.bringspring.ecs.docking.entity.sk.receipt.ApplyStream;
import com.bringspring.ecs.docking.entity.sk.receipt.DataList;
import com.bringspring.ecs.docking.entity.sk.receipt.DataRow;
import com.bringspring.ecs.docking.entity.sk.receipt.DownLoadStream;
import com.bringspring.ecs.docking.entity.sk.receipt.QueryResDataList;
import com.bringspring.ecs.docking.entity.sk.receipt.QueryResRow;
import com.bringspring.ecs.docking.entity.sk.receipt.QueryResStream;
import com.bringspring.ecs.docking.entity.sk.receipt.QueryStream;
import com.bringspring.ecs.docking.entity.sk.single.CheckStream;
import com.bringspring.ecs.docking.entity.sk.single.SingleStream;
import com.bringspring.ecs.docking.entity.vo.PaymentVO;
import com.bringspring.ecs.docking.enums.PayStateEnums;
import com.bringspring.ecs.docking.service.SkPaymentService;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsCompanyAccountEntity;
import com.bringspring.ecs.entity.EcsPaymentRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsUploadVO;
import com.bringspring.ecs.service.EcsBankCardService;
import com.bringspring.ecs.service.EcsBankTransactionHistoryService;
import com.bringspring.ecs.service.EcsCompanyAccountService;
import com.bringspring.ecs.service.EcsPaymentRecordsService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.utils.Base64ToFileUtil;
import com.bringspring.ecs.utils.HttpClientUtil;
import com.bringspring.ecs.utils.UploadFiles;
import com.bringspring.ecs.utils.XmlConverter;
import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SkPaymentServiceImpl
implements SkPaymentService {
    private static final Logger log = LoggerFactory.getLogger(SkPaymentServiceImpl.class);
    @Value(value="${sk.userName}")
    private String userName;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private EcsBankCardService bankCardService;
    @Autowired
    private HttpClientUtil httpClientUtil;
    @Autowired
    private EcsPaymentRecordsService paymentRecordsService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private EcsCompanyAccountService companyAccountService;
    @Autowired
    private EcsBankTransactionHistoryService transactionHistoryService;
    @Autowired
    private UploadFiles uploadFiles;

    @Override
    public ActionResult<?> singlePayment(PaymentVO paymentVO) {
        try {
            SingleStream stream = new SingleStream();
            stream.setAction("SKDLTTRN");
            stream.setUserName(this.userName);
            stream.setExternalNum(paymentVO.getSourceCode());
            stream.setLinkPayFlag("00");
            stream.setPypartyAccnum(paymentVO.getPypartyAccnum());
            stream.setRcvpyAccnum(paymentVO.getRcvpyAccnum());
            stream.setRcvpyAccnm(paymentVO.getRcvpyAccnm());
            stream.setRcvpartyBnkgId(paymentVO.getBankFirmCode());
            stream.setTxnCntprTp("01");
            stream.setPyAccTp(paymentVO.getPyAccTp());
            stream.setAmt(paymentVO.getAmt());
            stream.setCurrencyID("CNY");
            stream.setUrgntAprvFlag("00");
            stream.setPyTmlnsFlag("00");
            stream.setPscpt(paymentVO.getPscpt());
            log.info("\u5355\u7b14\u4ed8\u6b3e\u5165\u53c2: {}", (Object)stream);
            String gbkXml = XmlConverter.convertToGBKXml(stream);
            String sendRequest = this.httpClientUtil.sendSKRequest(paymentVO.getSourceModule(), paymentVO.getSourceId(), paymentVO.getSourceCode(), paymentVO.getTitle(), gbkXml);
            JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
            log.info("\u5355\u7b14\u4ed8\u6b3e\u51fa\u53c2\u5355\u7b14\u4ed8\u6b3e\u51fa\u53c2: {}", (Object)jsonObject);
            JSONObject object = jsonObject.getJSONObject((Object)"stream");
            if (object == null) {
                log.error("\u54cd\u5e94\u4e2d\u672a\u627e\u5230stream\u5b57\u6bb5");
                return ActionResult.fail((String)"\u54cd\u5e94\u683c\u5f0f\u9519\u8bef");
            }
            String status = object.get((Object)"status").toString();
            if ("AAAAAAA".equals(status)) {
                String externalNum = object.get((Object)"externalNum").toString();
                this.paymentRecordsService.savePaymentRecord(paymentVO);
                return ActionResult.success();
            }
            log.error("\u5355\u7b14\u4ed8\u6b3e\u5931\u8d25, \u539f\u56e0: {}", (Object)jsonObject);
            return ActionResult.fail((String)"\u4ed8\u6b3e\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u5355\u7b14\u4ed8\u6b3e\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38, recordId: {}", (Object)paymentVO.getSourceId(), (Object)e);
            return ActionResult.fail((String)"\u7cfb\u7edf\u5185\u90e8\u9519\u8bef");
        }
    }

    @Override
    public ActionResult<?> singlePayment(String recordId) {
        try {
            EcsRecordsEntity recordsEntity = this.recordsService.getInfo(recordId);
            EcsBankCardEntity bankCardEntity = this.bankCardService.getInfo(recordsEntity.getBankCardId());
            EcsCompanyAccountEntity accountEntity = (EcsCompanyAccountEntity)this.companyAccountService.getOne((Wrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getAccount, (Object)recordsEntity.getPayAccount()));
            SingleStream stream = new SingleStream();
            stream.setAction("SKDLTTRN");
            stream.setUserName(this.userName);
            stream.setExternalNum(recordsEntity.getOrderNumber());
            stream.setLinkPayFlag("00");
            stream.setPypartyAccnum(recordsEntity.getPayAccount());
            stream.setRcvpyAccnum(bankCardEntity.getCardNumber().replaceAll("\\s+", ""));
            stream.setRcvpyAccnm(bankCardEntity.getUsername());
            stream.setRcvpartyBnkgId(bankCardEntity.getBankFirmCode());
            stream.setTxnCntprTp("01");
            stream.setPyAccTp(bankCardEntity.getAccountType());
            stream.setAmt(recordsEntity.getReimbAmount().setScale(2, RoundingMode.HALF_UP));
            stream.setCurrencyID("CNY");
            stream.setUrgntAprvFlag("00");
            stream.setPyTmlnsFlag("00");
            String pscpt = accountEntity.getOpenBank().contains("\u6c11\u751f\u94f6\u884c") ? "386" : (StrUtil.isNotBlank((CharSequence)recordsEntity.getBankPscpt()) ? recordsEntity.getBankPscpt() : recordsEntity.getTitle());
            stream.setPscpt(pscpt);
            log.info("\u5355\u7b14\u4ed8\u6b3e\u5165\u53c2: {}", (Object)stream);
            String gbkXml = XmlConverter.convertToGBKXml(stream);
            String sendRequest = this.httpClientUtil.sendSKRequest("ECS", recordId, recordsEntity.getOrderNumber(), recordsEntity.getTitle(), gbkXml);
            JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
            log.info("\u5355\u7b14\u4ed8\u6b3e\u51fa\u53c2\u5355\u7b14\u4ed8\u6b3e\u51fa\u53c2: {}", (Object)jsonObject);
            JSONObject object = jsonObject.getJSONObject((Object)"stream");
            if (object == null) {
                log.error("\u54cd\u5e94\u4e2d\u672a\u627e\u5230stream\u5b57\u6bb5");
                return ActionResult.fail((String)"\u54cd\u5e94\u683c\u5f0f\u9519\u8bef");
            }
            String status = object.get((Object)"status").toString();
            if ("AAAAAAA".equals(status)) {
                String externalNum = object.get((Object)"externalNum").toString();
                return ActionResult.success();
            }
            log.error("\u5355\u7b14\u4ed8\u6b3e\u5931\u8d25, \u539f\u56e0: {}", (Object)jsonObject);
            return ActionResult.fail((String)"\u4ed8\u6b3e\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u5355\u7b14\u4ed8\u6b3e\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38, recordId: {}", (Object)recordId, (Object)e);
            return ActionResult.fail((String)"\u7cfb\u7edf\u5185\u90e8\u9519\u8bef");
        }
    }

    @Override
    public void singlePaymentCheck(String recordId) {
        String status;
        EcsPaymentRecordsEntity paymentRecordsEntity = this.paymentRecordsService.getInfo(recordId);
        CheckStream stream = new CheckStream();
        stream.setAction("SKDLBATD");
        stream.setUserName(this.userName);
        stream.setExternalNum(paymentRecordsEntity.getSourceCode());
        log.info("\u5355\u7b14\u4ed8\u6b3e\u67e5\u8bc1\u5165\u53c2: {}", (Object)stream);
        String gbkXml = XmlConverter.convertToGBKXml(stream);
        String sendRequest = this.httpClientUtil.sendSKRequest(paymentRecordsEntity.getSourceType(), recordId, paymentRecordsEntity.getSourceCode(), null, gbkXml);
        JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
        log.info("\u5355\u7b14\u4ed8\u6b3e\u67e5\u8bc1\u51fa\u53c2: {}", (Object)jsonObject);
        JSONObject object = jsonObject.getJSONObject((Object)"stream");
        if (object == null) {
            log.error("\u54cd\u5e94\u4e2d\u672a\u627e\u5230stream\u5b57\u6bb5");
        }
        if ("AAAAAAA".equals(status = object.get((Object)"status").toString())) {
            String payStat = object.get((Object)"pyStat").toString();
            String statusText = object.get((Object)"statusText").toString();
            log.info("\u5f53\u524d\u4ed8\u6b3e\u72b6\u6001: {}", (Object)PayStateEnums.getDescByCode(payStat));
            this.paymentRecordsService.updatePaymentState(recordId, statusText, payStat);
        } else {
            log.error("\u5355\u7b14\u4ed8\u6b3e\u67e5\u8bc1\u5931\u8d25, \u539f\u56e0: {}", (Object)jsonObject);
        }
    }

    @Override
    public void receiptApply(String payAcc) {
        String status;
        String yesterday = DateUtil.format((Date)DateUtil.yesterday(), (String)"yyyyMMdd");
        String dayBeforeYesterday = DateUtil.format((Date)DateUtil.offsetDay((Date)DateUtil.date(), (int)-2), (String)"yyyyMMdd");
        String code = SkPaymentServiceImpl.generateCode();
        ApplyStream stream = new ApplyStream();
        stream.setAction("SKEDDRSQ");
        stream.setUserName(this.userName);
        stream.setClientId(code);
        stream.setAccountNo(payAcc);
        stream.setStartDate(dayBeforeYesterday);
        stream.setEndDate(yesterday);
        log.info("\u7535\u5b50\u56de\u5355\u7533\u8bf7\u5165\u53c2: {}", (Object)stream);
        String gbkXml = XmlConverter.convertToGBKXml(stream);
        String sendRequest = this.httpClientUtil.sendSKRequest("", null, payAcc, "\u7535\u5b50\u56de\u5355\u7533\u8bf7", gbkXml);
        JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
        log.info("\u7535\u5b50\u56de\u5355\u7533\u8bf7\u51fa\u53c2: {}", (Object)jsonObject);
        JSONObject object = jsonObject.getJSONObject((Object)"stream");
        if (object == null) {
            log.error("\u54cd\u5e94\u4e2d\u672a\u627e\u5230stream\u5b57\u6bb5");
        }
        if ("AAAAAAA".equals(status = object.get((Object)"status").toString())) {
            List<QueryResRow> queryData = this.receiptQuery(code, dayBeforeYesterday, yesterday, payAcc);
            this.receiptDownLoad(queryData);
        } else {
            log.error("\u7535\u5b50\u56de\u5355\u7533\u8bf7\u5931\u8d25, \u539f\u56e0: {}", (Object)jsonObject);
        }
    }

    @Override
    public void temporaryreceiptApply(String payAcc) {
        String status;
        String code = SkPaymentServiceImpl.generateCode();
        ApplyStream stream = new ApplyStream();
        stream.setAction("SKEDDRSQ");
        stream.setUserName(this.userName);
        stream.setClientId(code);
        stream.setAccountNo(payAcc);
        stream.setStartDate("20250403");
        stream.setEndDate("20250405");
        log.info("\u7535\u5b50\u56de\u5355\u7533\u8bf7\u5165\u53c2: {}", (Object)stream);
        String gbkXml = XmlConverter.convertToGBKXml(stream);
        String sendRequest = this.httpClientUtil.sendSKRequest("", null, payAcc, "\u7535\u5b50\u56de\u5355\u7533\u8bf7", gbkXml);
        JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
        log.info("\u7535\u5b50\u56de\u5355\u7533\u8bf7\u51fa\u53c2: {}", (Object)jsonObject);
        JSONObject object = jsonObject.getJSONObject((Object)"stream");
        if (object == null) {
            log.error("\u54cd\u5e94\u4e2d\u672a\u627e\u5230stream\u5b57\u6bb5");
        }
        if ("AAAAAAA".equals(status = object.get((Object)"status").toString())) {
            List<QueryResRow> queryData = this.receiptQuery(code, "20250403", "20250405", payAcc);
            this.receiptDownLoad(queryData);
        } else {
            log.error("\u7535\u5b50\u56de\u5355\u7533\u8bf7\u5931\u8d25, \u539f\u56e0: {}", (Object)jsonObject);
        }
    }

    @Override
    public List<QueryResRow> receiptQuery(String clientId, String startDate, String endDate, String payAcc) {
        ArrayList<QueryResRow> arrayList = new ArrayList<QueryResRow>();
        int pageSize = 100;
        int records = this.getTotalRecords(clientId, startDate, endDate, payAcc);
        if (records <= 0) {
            return arrayList;
        }
        int totalPages = (int)Math.ceil((double)records / (double)pageSize);
        for (int page = 1; page <= totalPages; ++page) {
            List<QueryResRow> row;
            QueryStream stream = new QueryStream();
            stream.setAction("SKEDDQRY");
            stream.setUserName(this.userName);
            stream.setClientId(clientId);
            stream.setTranType("01");
            stream.setStartDate(startDate);
            stream.setEndDate(endDate);
            stream.setStartRecord(String.valueOf(page));
            stream.setPageNumber(String.valueOf(pageSize));
            log.info("\u7535\u5b50\u56de\u5355\u67e5\u8be2\u5165\u53c2: {}", (Object)stream);
            String gbkXml = XmlConverter.convertToGBKXml(stream);
            String sendRequest = this.httpClientUtil.sendSKRequest("", null, payAcc, "\u7535\u5b50\u56de\u5355\u67e5\u8be2", gbkXml);
            JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
            log.info("\u7535\u5b50\u56de\u5355\u67e5\u8be2\u51fa\u53c2: {}", (Object)jsonObject);
            JSONObject object = jsonObject.getJSONObject((Object)"stream");
            if (object == null) {
                log.error("\u54cd\u5e94\u4e2d\u672a\u627e\u5230stream\u5b57\u6bb5");
                return arrayList;
            }
            QueryResStream resStream = (QueryResStream)JSONUtil.toBean((String)object.toString(), QueryResStream.class);
            String status = resStream.getStatus();
            if ("AAAAAAA".equals(status)) {
                row = null;
                for (QueryResDataList resData : resStream.getList()) {
                    if (!"userDataList".equals(resData.getName())) continue;
                    row = resData.getRow();
                }
            } else {
                log.error("\u7535\u5b50\u56de\u5355\u67e5\u8be2\u5931\u8d25, \u539f\u56e0: {}", (Object)jsonObject);
                return arrayList;
            }
            arrayList.addAll(row);
        }
        return arrayList;
    }

    @Override
    public void receiptDownLoad(List<QueryResRow> dataList) {
        if (CollectionUtil.isNotEmpty(dataList)) {
            List<EcsPaymentRecordsEntity> paymentRecordsEntities = this.paymentRecordsService.getPaymentRecordBylvmsg();
            dataList.forEach(queryData -> {
                DownLoadStream downLoadStream = this.createDownLoadStream((QueryResRow)queryData);
                String externalNum = null;
                if (StrUtil.isNotBlank((CharSequence)queryData.getExternalNum())) {
                    externalNum = queryData.getExternalNum();
                } else {
                    String lvmsg = queryData.getLvmsg();
                    if (paymentRecordsEntities != null) {
                        for (EcsPaymentRecordsEntity record : paymentRecordsEntities) {
                            if (!lvmsg.contains(record.getSourceCode())) continue;
                            externalNum = record.getSourceCode();
                            break;
                        }
                    }
                }
                this.handleResponse(this.sendRequest(downLoadStream, externalNum), externalNum);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    @Override
    public DownloadVO uploadReceipt(String fileStr) {
        String outputDirectory = this.configValueUtil.getTemporaryFilePath();
        List<File> files = null;
        try {
            files = Base64ToFileUtil.decodeAndUnzip(fileStr, outputDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList ecsUploadVOS = new ArrayList();
        files.forEach(file -> {
            MultipartFile fileItem = FileUtil.createFileItem((File)file);
            UploaderVO uploader = this.uploadFiles.uploader(fileItem, "ecs", "annex");
            EcsUploadVO ecsUploadVO = new EcsUploadVO();
            BeanUtil.copyProperties((Object)uploader, (Object)ecsUploadVO, (String[])new String[0]);
            ecsUploadVO.setName(file.getName());
            ecsUploadVO.setFileId(uploader.getName());
            ecsUploadVOS.add(ecsUploadVO);
        });
        DownloadVO vo = DownloadVO.builder().build();
        vo.setUrl(JSON.toJSONString(ecsUploadVOS));
        return vo;
    }

    @Override
    public void HistoryDetailApply(String companyId, String payAcc) {
        String status;
        String yesterday = DateUtil.format((Date)DateUtil.yesterday(), (String)"yyyyMMdd");
        String code = SkPaymentServiceImpl.generateCode();
        HistoryApplyStream stream = new HistoryApplyStream();
        stream.setAction("SKTRNHCL");
        stream.setUserName(this.userName);
        stream.setClientId(code);
        stream.setAccountNo(payAcc);
        stream.setStartDate(yesterday);
        stream.setEndDate(yesterday);
        log.info("\u5386\u53f2\u660e\u7ec6\u7ed3\u679c\u7533\u8bf7\u5165\u53c2: {}", (Object)stream);
        String gbkXml = XmlConverter.convertToGBKXml(stream);
        String sendRequest = this.httpClientUtil.sendSKRequest("", null, payAcc, "\u7535\u5b50\u56de\u5355\u7533\u8bf7", gbkXml);
        JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
        log.info("\u5386\u53f2\u660e\u7ec6\u7ed3\u679c\u7533\u8bf7\u51fa\u53c2: {}", (Object)jsonObject);
        JSONObject object = jsonObject.getJSONObject((Object)"stream");
        if (object == null) {
            log.error("\u54cd\u5e94\u4e2d\u672a\u627e\u5230stream\u5b57\u6bb5");
        }
        if ("AAAAAAA".equals(status = object.get((Object)"status").toString())) {
            List<ResRow> resRows = this.HistoryDetail(code, yesterday, yesterday, payAcc);
            this.transactionHistoryService.saveBatch(companyId, resRows);
        } else {
            log.error("\u5386\u53f2\u660e\u7ec6\u7ed3\u679c\u7533\u8bf7\u5931\u8d25, \u539f\u56e0: {}", (Object)jsonObject);
        }
    }

    @Override
    public List<ResRow> HistoryDetail(String clientId, String startDate, String endDate, String payAcc) {
        ArrayList<ResRow> arrayList = new ArrayList<ResRow>();
        int pageSize = 100;
        int records = this.getHistoryTotalRecords(clientId, startDate, endDate, payAcc);
        if (records <= 0) {
            return arrayList;
        }
        int totalPages = (int)Math.ceil((double)records / (double)pageSize);
        for (int page = 1; page <= totalPages; ++page) {
            List<ResRow> row;
            HistoryQueryStream stream = new HistoryQueryStream();
            stream.setAction("SKTRNHCT");
            stream.setUserName(this.userName);
            stream.setClientId(clientId);
            stream.setTranType("01");
            stream.setStartDate(startDate);
            stream.setEndDate(endDate);
            stream.setStartRecord(String.valueOf(page));
            stream.setPageNumber(String.valueOf(pageSize));
            log.info("\u5386\u53f2\u660e\u7ec6\u7ed3\u679c\u67e5\u8be2\u5165\u53c2: {}", (Object)stream);
            String gbkXml = XmlConverter.convertToGBKXml(stream);
            String sendRequest = this.httpClientUtil.sendSKRequest("", null, payAcc, "\u5386\u53f2\u660e\u7ec6\u7ed3\u679c\u67e5\u8be2", gbkXml);
            JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
            log.info("\u5386\u53f2\u660e\u7ec6\u7ed3\u679c\u67e5\u8be2\u51fa\u53c2: {}", (Object)jsonObject);
            JSONObject object = jsonObject.getJSONObject((Object)"stream");
            if (object == null) {
                log.error("\u54cd\u5e94\u4e2d\u672a\u627e\u5230stream\u5b57\u6bb5");
                return arrayList;
            }
            ResStream resStream = (ResStream)JSONUtil.toBean((String)object.toString(), ResStream.class);
            String status = resStream.getStatus();
            if ("AAAAAAA".equals(status)) {
                row = null;
                for (ResDataList resData : resStream.getList()) {
                    if (!"userDataList".equals(resData.getName())) continue;
                    row = resData.getRow();
                }
            } else {
                log.error("\u5386\u53f2\u660e\u7ec6\u7ed3\u679c\u67e5\u8be2\u5931\u8d25, \u539f\u56e0: {}", (Object)jsonObject);
                return arrayList;
            }
            arrayList.addAll(row);
        }
        return arrayList;
    }

    @Override
    public int getHistoryTotalRecords(String clientId, String startDate, String endDate, String payAcc) {
        int maxRetries = 10;
        int retryCount = 0;
        while (retryCount < maxRetries) {
            try {
                Integer skTotalNum;
                JSONObject object;
                String status;
                HistoryQueryStream stream = new HistoryQueryStream();
                stream.setAction("SKTRNHCT");
                stream.setUserName(this.userName);
                stream.setClientId(clientId);
                stream.setTranType("01");
                stream.setStartDate(startDate);
                stream.setEndDate(endDate);
                stream.setStartRecord("1");
                stream.setPageNumber("1");
                String gbkXml = XmlConverter.convertToGBKXml(stream);
                String sendRequest = this.httpClientUtil.sendSKRequest("", null, payAcc, "\u5386\u53f2\u660e\u7ec6\u7ed3\u679c\u603b\u6761\u6570", gbkXml);
                JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
                if (jsonObject != null && "AAAAAAA".equals(status = (object = jsonObject.getJSONObject((Object)"stream")).get((Object)"status").toString()) && (skTotalNum = object.getInt((Object)"totalRecords", Integer.valueOf(0))) != 0) {
                    return skTotalNum;
                }
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u5931\u8d25,{}", (Throwable)e);
            }
            ++retryCount;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        return 0;
    }

    private DownLoadStream createDownLoadStream(QueryResRow queryData) {
        DownLoadStream downLoadStream = new DownLoadStream();
        downLoadStream.setAction("SKEDCDTD");
        downLoadStream.setUserName(this.userName);
        DataList list = new DataList();
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        DataRow dataRow = new DataRow();
        dataRow.setRcptNum(queryData.getRcptNum());
        arrayList.add(dataRow);
        list.setName("userDataList");
        list.setDataRows(arrayList);
        downLoadStream.setDataList(list);
        return downLoadStream;
    }

    private String sendRequest(DownLoadStream downLoadStream, String externalNum) {
        String gbkXml = XmlConverter.convertToGBKXml(downLoadStream);
        return this.httpClientUtil.sendSKRequest("", null, externalNum, "\u7535\u5b50\u56de\u5355\u4e0b\u8f7d", gbkXml);
    }

    private void handleResponse(String sendRequest, String externalNum) {
        JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
        log.info("\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u51fa\u53c2: {}", (Object)jsonObject);
        JSONObject object = jsonObject.getJSONObject((Object)"stream");
        if (object == null) {
            log.error("\u54cd\u5e94\u4e2d\u672a\u627e\u5230stream\u5b57\u6bb5");
            return;
        }
        String status = object.get((Object)"status").toString();
        if ("AAAAAAA".equals(status)) {
            String fileContent = object.get((Object)"fileContent").toString();
            DownloadVO downloadVO = this.uploadReceipt(fileContent);
            this.paymentRecordsService.updatePaymentRecepit(externalNum, downloadVO.getUrl());
            log.info("\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u7533\u8bf7\u6210\u529f");
        } else {
            log.error("\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u5931\u8d25, \u539f\u56e0: {}", (Object)object);
        }
    }

    @Override
    public int getTotalRecords(String clientId, String startDate, String endDate, String payAcc) {
        int maxRetries = 10;
        int retryCount = 0;
        while (retryCount < maxRetries) {
            try {
                Integer skTotalNum;
                JSONObject object;
                String status;
                QueryStream stream = new QueryStream();
                stream.setAction("SKEDDQRY");
                stream.setUserName(this.userName);
                stream.setClientId(clientId);
                stream.setTranType("01");
                stream.setStartDate(startDate);
                stream.setEndDate(endDate);
                stream.setStartRecord("1");
                stream.setPageNumber("1");
                String gbkXml = XmlConverter.convertToGBKXml(stream);
                String sendRequest = this.httpClientUtil.sendSKRequest("", null, payAcc, "\u7535\u5b50\u56de\u5355\u67e5\u8be2\u603b\u6761\u6570", gbkXml);
                JSONObject jsonObject = XmlConverter.convertXmlToJson(sendRequest);
                if (jsonObject != null && "AAAAAAA".equals(status = (object = jsonObject.getJSONObject((Object)"stream")).get((Object)"status").toString()) && Arrays.asList("1", "2", "3").contains(object.get((Object)"totRcptStat").toString()) && (skTotalNum = object.getInt((Object)"totalRecords", Integer.valueOf(0))) != 0) {
                    return skTotalNum;
                }
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u5931\u8d25,{}", (Throwable)e);
            }
            ++retryCount;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        return 0;
    }

    public static String generateCode() {
        LocalDate currentDate = LocalDate.now();
        String datePart = currentDate.toString().replace("-", "");
        Random random = new Random();
        int randomNumber = random.nextInt(1000);
        String randomPart = String.format("%03d", randomNumber);
        return datePart + randomPart;
    }
}

