/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.strategy.payvoucher;

import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.ecs.docking.entity.nc.voucher.Ass;
import com.bringspring.ecs.docking.entity.nc.voucher.AssItem;
import com.bringspring.ecs.docking.entity.nc.voucher.Item;
import com.bringspring.ecs.docking.entity.nc.voucher.UfInterface;
import com.bringspring.ecs.docking.entity.nc.voucher.VoucherHead;
import com.bringspring.ecs.docking.strategy.VoucherOperationStrategy;
import com.bringspring.ecs.docking.utils.VoucherService;
import com.bringspring.ecs.docking.utils.VoucherUtils;
import com.bringspring.ecs.entity.EcsCompanyAccountEntity;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsPaymentRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.exception.VoucherPushException;
import com.bringspring.ecs.service.EcsCompanyAccountService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.utils.XmlConverter;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AdvancePayVoucherPushHandle
implements VoucherOperationStrategy {
    private static final Logger log = LoggerFactory.getLogger(AdvancePayVoucherPushHandle.class);
    @Value(value="${nc.sender}")
    private String sender;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private VoucherService voucherService;
    @Autowired
    private EcsCompanyAccountService companyAccountService;
    @Autowired
    private EcsCompanyService companyService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<String> actionMethod() {
        return Arrays.asList("ECS_ADVANCE");
    }

    @Override
    public boolean handler(Object data) throws VoucherPushException {
        try {
            EcsPaymentRecordsEntity paymentRecordsEntity = XmlConverter.convert(data, EcsPaymentRecordsEntity.class);
            EcsRecordsEntity recordsEntity = (EcsRecordsEntity)this.recordsService.getById((Serializable)((Object)paymentRecordsEntity.getSourceId()));
            EcsCompanyAccountEntity accountEntity = (EcsCompanyAccountEntity)this.companyAccountService.getOne((Wrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getAccount, (Object)paymentRecordsEntity.getPayAcc()));
            EcsCompanyEntity companyEntity = this.companyService.getInfo(accountEntity.getCompanyId());
            String ncPrepared = companyEntity.getNcPrepared();
            String usered = this.baseDataUtil.userSelectValues(ncPrepared);
            UfInterface ufInterface = VoucherUtils.createUfInterface(companyEntity, this.sender);
            VoucherHead voucherHead = VoucherUtils.createVoucherHead(paymentRecordsEntity.getId(), companyEntity, usered);
            String explanation = AdvancePayVoucherPushHandle.generateExplanation(paymentRecordsEntity.getRcvAccName(), recordsEntity);
            ArrayList<Item> items = new ArrayList<Item>();
            Item item1 = VoucherUtils.createItem(1, explanation, paymentRecordsEntity.getAmt(), paymentRecordsEntity.getAmt(), BigDecimal.valueOf(0L), "122102");
            ArrayList<AssItem> assItemList1 = new ArrayList<AssItem>();
            ArrayList<Ass> assList1 = new ArrayList<Ass>();
            assItemList1.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", paymentRecordsEntity.getRcvAccName()));
            assItemList1.add(VoucherUtils.createAssItem("\u6b3e\u9879\u6027\u8d28", "0101"));
            Ass ass1 = new Ass();
            ass1.setItems(assItemList1);
            assList1.add(ass1);
            item1.setAssList(assList1);
            items.add(item1);
            Item item2 = VoucherUtils.createItem(2, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), paymentRecordsEntity.getAmt(), "100201");
            ArrayList<Ass> assList2 = new ArrayList<Ass>();
            Ass ass2 = new Ass();
            ArrayList<AssItem> assItemList2 = new ArrayList<AssItem>();
            assItemList2.add(VoucherUtils.createAssItem("\u73b0\u91d1\u6d41\u91cf\u9879\u76ee", "1124"));
            assItemList2.add(VoucherUtils.createAssItem("\u94f6\u884c\u8d26\u6237", paymentRecordsEntity.getPayAcc()));
            ass2.setItems(assItemList2);
            assList2.add(ass2);
            item2.setAssList(assList2);
            items.add(item2);
            JSONObject sendResult = this.voucherService.processVoucher(ufInterface, voucherHead, items, paymentRecordsEntity.getId(), paymentRecordsEntity.getSourceCode(), paymentRecordsEntity.getTitle());
            return sendResult != null && sendResult.getInt((Object)"resultcode") == 1;
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u62a5\u9500\u8bb0\u5f55\u65f6\u53d1\u751f\u5f02\u5e38\uff0cID: {}\uff0c\u9519\u8bef\u4fe1\u606f: {}", new Object[]{"\u672a\u77e5", e.getMessage(), e});
            return false;
        }
    }

    public static String generateExplanation(String userName, EcsRecordsEntity recordsEntity) {
        return "\u652f\u4ed8\u62a5\u9500\u6b3e," + userName + recordsEntity.getRecordType() + ",\u62a5\u9500\u5355\u53f7:" + recordsEntity.getOrderNumber();
    }
}

