/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.strategy.revvoucher;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.ecs.docking.entity.nc.voucher.Ass;
import com.bringspring.ecs.docking.entity.nc.voucher.AssItem;
import com.bringspring.ecs.docking.entity.nc.voucher.Item;
import com.bringspring.ecs.docking.entity.nc.voucher.UfInterface;
import com.bringspring.ecs.docking.entity.nc.voucher.VoucherHead;
import com.bringspring.ecs.docking.entity.vo.ConfirmIncomeRequest;
import com.bringspring.ecs.docking.enums.TaxRateEnums;
import com.bringspring.ecs.docking.strategy.VoucherOperationStrategy;
import com.bringspring.ecs.docking.utils.VoucherService;
import com.bringspring.ecs.docking.utils.VoucherUtils;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsPlatformMappingEntity;
import com.bringspring.ecs.entity.EcsPlatformMappingRecordsEntity;
import com.bringspring.ecs.exception.VoucherPushException;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsPlatformMappingRecordsService;
import com.bringspring.ecs.service.EcsPlatformMappingService;
import com.bringspring.ecs.utils.XmlConverter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ConfirmIncomeVoucherHandle
implements VoucherOperationStrategy {
    private static final Logger log = LoggerFactory.getLogger(ConfirmIncomeVoucherHandle.class);
    @Value(value="${nc.sender}")
    private String sender;
    @Autowired
    private EcsCompanyService companyService;
    @Autowired
    private EcsPlatformMappingRecordsService platformMappingRecordsService;
    @Autowired
    private EcsPlatformMappingService platformMappingService;
    @Autowired
    private VoucherService voucherService;

    @Override
    public List<String> actionMethod() {
        return Arrays.asList("ConfirmIncome");
    }

    @Override
    public boolean handler(Object data) throws VoucherPushException {
        ConfirmIncomeRequest income = XmlConverter.convert(data, ConfirmIncomeRequest.class);
        String companyId = income.getCompanyId();
        EcsCompanyEntity companyEntity = this.companyService.getInfo("628688912539726");
        EcsPlatformMappingEntity platformMappingEntity = (EcsPlatformMappingEntity)this.platformMappingService.getOne((Wrapper)Wrappers.lambdaQuery().eq(EcsPlatformMappingEntity::getSourceId, (Object)income.getDeptId()));
        EcsPlatformMappingRecordsEntity ncDept = (EcsPlatformMappingRecordsEntity)this.platformMappingRecordsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsPlatformMappingRecordsEntity::getCompanyId, (Object)companyEntity.getId())).eq(EcsPlatformMappingRecordsEntity::getPlatform, (Object)"NC")).eq(EcsPlatformMappingRecordsEntity::getMappingId, (Object)platformMappingEntity.getId()));
        UfInterface ufInterface = VoucherUtils.createUfInterface(companyEntity, this.sender);
        VoucherHead voucherHead = VoucherUtils.createVoucherHead(income.getId(), companyEntity, "\u97e6\u6d01");
        BigDecimal rateAmount = income.getConfirmAmount().subtract(income.getNoTaxAmount());
        String explanation = ConfirmIncomeVoucherHandle.generateExplanation(income);
        String rate = StrUtil.isNotBlank((CharSequence)income.getTaxRate()) ? TaxRateEnums.getDescByCode(income.getTaxRate()) : TaxRateEnums.getDescByCode("0%");
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList<Ass> assList1 = new ArrayList<Ass>();
        Item item1 = this.createItemBasedOnTax(income, explanation, "112202");
        ArrayList<AssItem> assItemList1 = new ArrayList<AssItem>();
        assItemList1.add(VoucherUtils.createAssItem("\u5ba2\u5546", income.getCustomerName()));
        assItemList1.add(VoucherUtils.createAssItem("\u9879\u76ee", income.getContractCode()));
        assItemList1.add(VoucherUtils.createAssItem("\u90e8\u95e8", ncDept.getTargetCode()));
        Ass ass1 = new Ass();
        ass1.setItems(assItemList1);
        assList1.add(ass1);
        item1.setAssList(assList1);
        items.add(item1);
        ArrayList<Ass> assList2 = new ArrayList<Ass>();
        ArrayList<AssItem> assItemList2 = new ArrayList<AssItem>();
        Ass ass2 = new Ass();
        Item item2 = VoucherUtils.createItem(2, explanation, BigDecimal.ZERO, BigDecimal.ZERO, rateAmount, "22210102");
        assItemList2.add(VoucherUtils.createAssItem("\u7a0e\u7387\u5f81\u6536\u7387", rate));
        assItemList2.add(VoucherUtils.createAssItem("\u8ba1\u7a0e\u7c7b\u578b", "02"));
        ass2.setItems(assItemList2);
        assList2.add(ass2);
        item2.setAssList(assList2);
        items.add(item2);
        Item item3 = VoucherUtils.createItem(3, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), income.getNoTaxAmount(), "600103");
        ArrayList<Ass> assList3 = new ArrayList<Ass>();
        Ass ass3 = new Ass();
        ArrayList<AssItem> assItemList3 = new ArrayList<AssItem>();
        assItemList3.add(VoucherUtils.createAssItem("\u5ba2\u5546", income.getCustomerName()));
        assItemList3.add(VoucherUtils.createAssItem("\u9879\u76ee", income.getContractCode()));
        assItemList3.add(VoucherUtils.createAssItem("\u90e8\u95e8", ncDept.getTargetCode()));
        assItemList3.add(VoucherUtils.createAssItem("\u7a0e\u7387\u5f81\u6536\u7387", rate));
        ass3.setItems(assItemList3);
        assList3.add(ass3);
        item3.setAssList(assList3);
        items.add(item3);
        JSONObject sendResult = this.voucherService.processVoucher(ufInterface, voucherHead, items, income.getId(), income.getIncomeCode(), income.getContractName());
        return sendResult != null && sendResult.getInt((Object)"resultcode") == 1;
    }

    private Item createItemBasedOnTax(ConfirmIncomeRequest incomeRequest, String explanation, String accountCode) {
        return VoucherUtils.createItem(1, explanation, incomeRequest.getConfirmAmount(), incomeRequest.getConfirmAmount(), BigDecimal.ZERO, accountCode);
    }

    public static String generateExplanation(ConfirmIncomeRequest incomeRequest) {
        return "\u786e\u8ba4" + incomeRequest.getCustomerName() + "-" + incomeRequest.getContractNumber() + "\u6536\u5165," + incomeRequest.getIncomeCode();
    }
}

