/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.strategy.voucher;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.bringspring.ecs.docking.entity.nc.ReimbursementDetails;
import com.bringspring.ecs.docking.entity.nc.voucher.Ass;
import com.bringspring.ecs.docking.entity.nc.voucher.AssItem;
import com.bringspring.ecs.docking.entity.nc.voucher.Item;
import com.bringspring.ecs.docking.entity.nc.voucher.UfInterface;
import com.bringspring.ecs.docking.entity.nc.voucher.VoucherHead;
import com.bringspring.ecs.docking.enums.TaxRateEnums;
import com.bringspring.ecs.docking.service.impl.FetchReimbursementDetails;
import com.bringspring.ecs.docking.strategy.VoucherOperationStrategy;
import com.bringspring.ecs.docking.utils.VoucherService;
import com.bringspring.ecs.docking.utils.VoucherUtils;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsPlatformAccountMappingEntity;
import com.bringspring.ecs.entity.EcsPlatformMappingRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsChargesDetailEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsProjectEntity;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.utils.XmlConverter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JCVoucherPushHanle
implements VoucherOperationStrategy {
    private static final Logger log = LoggerFactory.getLogger(JCVoucherPushHanle.class);
    @Value(value="${nc.sender}")
    private String sender;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private FetchReimbursementDetails fetchReimbursementDetails;
    @Autowired
    private VoucherService voucherService;

    @Override
    public List<String> actionMethod() {
        return Arrays.asList("\u4e0a\u6d77\u4eca\u521b\u4fe1\u606f\u6280\u672f\u6709\u9650\u516c\u53f8");
    }

    @Override
    public boolean handler(Object data) {
        try {
            JSONObject sendResult;
            BigDecimal bigDecimal;
            EcsRecordsEntity recordsEntity = XmlConverter.convert(data, EcsRecordsEntity.class);
            ReimbursementDetails reimbursementDetails = this.fetchReimbursementDetails.fetchReimbursementDetails(recordsEntity.getId());
            log.info("reimbursementDetails={}", (Object)reimbursementDetails);
            List<EcsRecordsProjectEntity> recordsProjects = reimbursementDetails.getRecordsProjects();
            String bankCardId = recordsEntity.getBankCardId();
            EcsBankCardEntity bankCard = this.fetchReimbursementDetails.getBankCard(bankCardId);
            String type = "";
            String organizationName = reimbursementDetails.getRecords().getOrganizationName();
            UfInterface ufInterface = VoucherUtils.createUfInterface(reimbursementDetails.getCompany(), this.sender);
            VoucherHead voucherHead = VoucherUtils.createVoucherHead(recordsEntity.getId(), reimbursementDetails.getCompany(), reimbursementDetails.getPreparedBy());
            ArrayList<Item> items = new ArrayList<Item>();
            for (EcsInvoiceEntity invoice : reimbursementDetails.getInvoices()) {
                EcsRecordsChargesDetailEntity chargesDetail = reimbursementDetails.getChargesDetails().get(invoice.getSubjectId());
                String ncAccountCode = "";
                String deptNcCode = "";
                String subjectName = chargesDetail.getSubjectName();
                type = this.determineType(chargesDetail);
                EcsPlatformMappingRecordsEntity department = reimbursementDetails.getDepartment();
                deptNcCode = department.getTargetCode();
                EcsPlatformAccountMappingEntity accountMappingEntity = this.fetchReimbursementDetails.getAccountMapping(type, reimbursementDetails.getDepartment().getId(), chargesDetail.getSubjectCode());
                ncAccountCode = accountMappingEntity.getNcAccountCode();
                String explanation = VoucherUtils.generateExplanation(reimbursementDetails.getApplicantInfo(), chargesDetail, reimbursementDetails.getRecords());
                String invoiceTaxRate = invoice.getInvoiceTaxRate();
                String rate = StrUtil.isNotBlank((CharSequence)invoiceTaxRate) ? TaxRateEnums.getDescByCode(invoiceTaxRate) : TaxRateEnums.getDescByCode("0%");
                BigDecimal deductibleTax = invoice.getDeductibleTax();
                ArrayList<Ass> assList1 = new ArrayList<Ass>();
                Ass ass1 = new Ass();
                for (EcsRecordsProjectEntity recordsProject : reimbursementDetails.getRecordsProjects()) {
                    Double ratio = recordsProject.getRatio() != null ? Double.valueOf(recordsProject.getRatio() / 100.0) : null;
                    Item item1 = null;
                    item1 = JCVoucherPushHanle.isDepartmentValid(organizationName) ? this.createItemBasedOnTax(invoice, ratio, BigDecimal.ZERO, explanation, ncAccountCode) : this.createItemBasedOnTax(invoice, ratio, deductibleTax, explanation, ncAccountCode);
                    ArrayList<AssItem> assItemList1 = new ArrayList<AssItem>();
                    assItemList1.add(VoucherUtils.createAssItem("\u90e8\u95e8", deptNcCode));
                    assItemList1.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
                    ass1.setItems(assItemList1);
                    assList1.add(ass1);
                    item1.setAssList(assList1);
                    items.add(item1);
                }
                if (BigDecimal.ZERO.compareTo(deductibleTax) != 0 && "\u5dee\u65c5\u8d39".equals(recordsEntity.getRecordType()) && !JCVoucherPushHanle.isDepartmentValid(organizationName)) {
                    ArrayList<Ass> assList2 = new ArrayList<Ass>();
                    ArrayList<AssItem> assItemList2 = new ArrayList<AssItem>();
                    Ass ass2 = new Ass();
                    Item item2 = VoucherUtils.createItem(2, "\u53d1\u7968\u53f7\u7801:" + invoice.getInvoiceNumber(), invoice.getInvoiceTax(), invoice.getInvoiceTax(), BigDecimal.ZERO, "22210101");
                    assItemList2.add(VoucherUtils.createAssItem("\u7a0e\u7387\u5f81\u6536\u7387", rate));
                    assItemList2.add(VoucherUtils.createAssItem("\u8fdb\u9879\u5206\u7c7b", "03"));
                    assItemList2.add(VoucherUtils.createAssItem("\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u62b5\u6263", "01"));
                    ass2.setItems(assItemList2);
                    assList2.add(ass2);
                    item2.setAssList(assList2);
                    items.add(item2);
                }
                Item item3 = null;
                ArrayList<Ass> assList3 = new ArrayList<Ass>();
                Ass ass3 = new Ass();
                ArrayList<AssItem> assItemList3 = new ArrayList<AssItem>();
                item3 = bankCard.getAccountType().equals("01") ? VoucherUtils.createItem(3, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), invoice.getInvoiceAmount(), "122102") : VoucherUtils.createItem(3, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), invoice.getInvoiceAmount(), "122101");
                if (reimbursementDetails.getApplicantInfo() != null && reimbursementDetails.getApplicantInfo().get("name") != null) {
                    assItemList3.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
                }
                assItemList3.add(VoucherUtils.createAssItem("\u6b3e\u9879\u6027\u8d28", "0199"));
                ass3.setItems(assItemList3);
                assList3.add(ass3);
                item3.setAssList(assList3);
                items.add(item3);
            }
            if ("\u5dee\u65c5\u8d39".equals(reimbursementDetails.getRecords().getRecordType()) && BigDecimal.ZERO.compareTo(bigDecimal = this.fetchReimbursementDetails.calculateTotalAmountAndReimb(recordsEntity.getId(), reimbursementDetails)) != 0) {
                this.processTravelAllowance(recordsEntity, type, reimbursementDetails, bigDecimal, items, organizationName);
            }
            return (sendResult = this.voucherService.processVoucher(ufInterface, voucherHead, items, recordsEntity.getId(), recordsEntity.getOrderNumber(), recordsEntity.getTitle())) != null && sendResult.getInt((Object)"resultcode") == 1;
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u62a5\u9500\u8bb0\u5f55\u65f6\u53d1\u751f\u5f02\u5e38\uff0cID: {}\uff0c\u9519\u8bef\u4fe1\u606f: {}", new Object[]{"\u672a\u77e5", e.getMessage(), e});
            return false;
        }
    }

    private void processTravelAllowance(EcsRecordsEntity recordsEntity, String type, ReimbursementDetails reimbursementDetails, BigDecimal totalAmount, List<Item> items, String organizationName) {
        ArrayList<Ass> assList4 = new ArrayList<Ass>();
        String ncAccountCode = "";
        String deptNcCode = "";
        EcsPlatformMappingRecordsEntity department = reimbursementDetails.getDepartment();
        if (department != null) {
            deptNcCode = department.getTargetCode();
            EcsPlatformAccountMappingEntity accountMappingEntity = this.fetchReimbursementDetails.getAccountMapping(type, department.getId(), "0101");
            if (accountMappingEntity != null) {
                ncAccountCode = accountMappingEntity.getNcAccountCode();
            }
        }
        for (EcsRecordsProjectEntity recordsProject : reimbursementDetails.getRecordsProjects()) {
            Double ratio = recordsProject.getRatio() != null ? Double.valueOf(recordsProject.getRatio() / 100.0) : null;
            Item item4 = this.createReimbItemBasedOnTax(totalAmount, ratio, totalAmount, "\u51fa\u5dee\u8865\u52a9", ncAccountCode);
            ArrayList<AssItem> assItemList4 = new ArrayList<AssItem>();
            assItemList4.add(VoucherUtils.createAssItem("\u90e8\u95e8", deptNcCode));
            assItemList4.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
            Ass ass4 = new Ass();
            ass4.setItems(assItemList4);
            assList4.add(ass4);
            item4.setAssList(assList4);
            items.add(item4);
        }
        Item item5 = this.createSecondReimbItem(reimbursementDetails, totalAmount);
        items.add(item5);
    }

    private Item createSecondReimbItem(ReimbursementDetails reimbursementDetails, BigDecimal totalAmount) {
        Item item5 = VoucherUtils.createItem(3, "\u51fa\u5dee\u8865\u52a9", BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), totalAmount, "122102");
        ArrayList<Ass> assList5 = new ArrayList<Ass>();
        Ass ass5 = new Ass();
        ArrayList<AssItem> assItemList5 = new ArrayList<AssItem>();
        if (reimbursementDetails.getApplicantInfo() != null && reimbursementDetails.getApplicantInfo().get("name") != null) {
            assItemList5.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
        }
        assItemList5.add(VoucherUtils.createAssItem("\u6b3e\u9879\u6027\u8d28", "0199"));
        ass5.setItems(assItemList5);
        assList5.add(ass5);
        item5.setAssList(assList5);
        return item5;
    }

    private Item createItemBasedOnTax(EcsInvoiceEntity invoice, Double ratio, BigDecimal deductibleTax, String explanation, String accountCode) {
        if (BigDecimal.ZERO.compareTo(deductibleTax) != 0) {
            return VoucherUtils.createItem(1, explanation, invoice.getInvoiceAmountPreTax().multiply(BigDecimal.valueOf(ratio)), invoice.getInvoiceAmountPreTax().multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
        }
        return VoucherUtils.createItem(1, explanation, invoice.getInvoiceAmount().multiply(BigDecimal.valueOf(ratio)), invoice.getInvoiceAmount().multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
    }

    private Item createReimbItemBasedOnTax(BigDecimal reimb, Double ratio, BigDecimal deductibleTax, String explanation, String accountCode) {
        return VoucherUtils.createItem(1, explanation, reimb.multiply(BigDecimal.valueOf(ratio)), reimb.multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
    }

    public String determineType(EcsRecordsChargesDetailEntity chargesDetail) {
        String subjectName = chargesDetail.getSubjectName();
        String type = null;
        if ("01\u63a2\u4eb2\u5047\u8d39\u7528".equals(subjectName)) {
            type = "3";
        } else if ("01\u5dee\u65c5\u8d39".equals(subjectName)) {
            type = "0";
        }
        return type;
    }

    public static boolean isDepartmentValid(String departmentName) {
        List<String> DEPARTMENTS = Arrays.asList("\u8d22\u52a1\u90e8", "\u884c\u653f\u90e8", "\u4eba\u529b\u8d44\u6e90\u90e8");
        return DEPARTMENTS.contains(departmentName);
    }
}

