/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.strategy.voucher;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.bringspring.ecs.docking.entity.nc.ReimbursementDetails;
import com.bringspring.ecs.docking.entity.nc.voucher.Ass;
import com.bringspring.ecs.docking.entity.nc.voucher.AssItem;
import com.bringspring.ecs.docking.entity.nc.voucher.Item;
import com.bringspring.ecs.docking.entity.nc.voucher.UfInterface;
import com.bringspring.ecs.docking.entity.nc.voucher.VoucherHead;
import com.bringspring.ecs.docking.enums.TaxRateEnums;
import com.bringspring.ecs.docking.service.impl.FetchReimbursementDetails;
import com.bringspring.ecs.docking.strategy.VoucherOperationStrategy;
import com.bringspring.ecs.docking.utils.VoucherService;
import com.bringspring.ecs.docking.utils.VoucherUtils;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsPlatformAccountMappingEntity;
import com.bringspring.ecs.entity.EcsRecordsChargesDetailEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsProjectEntity;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.utils.XmlConverter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MJVoucherPushHandle
implements VoucherOperationStrategy {
    private static final Logger log = LoggerFactory.getLogger(MJVoucherPushHandle.class);
    @Value(value="${nc.sender}")
    private String sender;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private FetchReimbursementDetails fetchReimbursementDetails;
    @Autowired
    private VoucherService voucherService;

    @Override
    public List<String> actionMethod() {
        return Arrays.asList("\u4e0a\u6d77\u7c73\u5065\u4fe1\u606f\u6280\u672f\u6709\u9650\u516c\u53f8");
    }

    @Override
    public boolean handler(Object data) {
        try {
            JSONObject sendResult;
            BigDecimal bigDecimal;
            EcsRecordsEntity recordsEntity = XmlConverter.convert(data, EcsRecordsEntity.class);
            ReimbursementDetails reimbursementDetails = this.fetchReimbursementDetails.fetchReimbursementDetails(recordsEntity.getId());
            List<EcsRecordsProjectEntity> recordsProjects = reimbursementDetails.getRecordsProjects();
            if (reimbursementDetails == null) {
                log.info("\u672a\u627e\u5230\u62a5\u9500\u8be6\u60c5\uff0cID: ", (Object)recordsEntity.getId());
                return false;
            }
            String amountConsistent = recordsEntity.getAmountConsistent();
            String organizationName = reimbursementDetails.getRecords().getOrganizationName();
            UfInterface ufInterface = VoucherUtils.createUfInterface(reimbursementDetails.getCompany(), this.sender);
            VoucherHead voucherHead = VoucherUtils.createVoucherHead(recordsEntity.getId(), reimbursementDetails.getCompany(), reimbursementDetails.getPreparedBy());
            ArrayList<Item> items = new ArrayList<Item>();
            for (EcsInvoiceEntity invoice : reimbursementDetails.getInvoices()) {
                EcsRecordsChargesDetailEntity chargesDetail = reimbursementDetails.getChargesDetails().get(invoice.getSubjectId());
                if (chargesDetail == null) {
                    log.warn("\u672a\u627e\u5230\u8d39\u7528\u660e\u7ec6\uff0c\u53d1\u7968\u79d1\u76eeID: {}", (Object)invoice.getSubjectId());
                    continue;
                }
                String bankCardId = recordsEntity.getBankCardId();
                EcsBankCardEntity bankCard = this.fetchReimbursementDetails.getBankCard(bankCardId);
                EcsPlatformAccountMappingEntity accountMappingEntity = this.fetchReimbursementDetails.getAccountMapping(null, reimbursementDetails.getDepartment().getId(), chargesDetail.getSubjectCode());
                String subjectName = chargesDetail.getSubjectName();
                String ncAccountCode = "";
                if (accountMappingEntity != null) {
                    ncAccountCode = accountMappingEntity.getNcAccountCode();
                }
                if (MJVoucherPushHandle.isDepartmentValid(organizationName)) {
                    ncAccountCode = "53010402";
                }
                String explanation = this.generateExplanation(reimbursementDetails.getApplicantInfo(), chargesDetail, reimbursementDetails.getRecords());
                String invoiceTaxRate = invoice.getInvoiceTaxRate();
                String rate = StrUtil.isNotBlank((CharSequence)invoiceTaxRate) ? TaxRateEnums.getDescByCode(invoiceTaxRate) : TaxRateEnums.getDescByCode("0%");
                BigDecimal deductibleTax = invoice.getDeductibleTax();
                ArrayList<Ass> assList1 = new ArrayList<Ass>();
                for (EcsRecordsProjectEntity recordsProject : reimbursementDetails.getRecordsProjects()) {
                    Double ratio = recordsProject.getRatio() != null ? Double.valueOf(recordsProject.getRatio() / 100.0) : null;
                    Item item1 = null;
                    item1 = amountConsistent.equals("10") ? this.createConsistentItemBasedOnTax(invoice, chargesDetail, ratio, deductibleTax, explanation, ncAccountCode) : this.createItemBasedOnTax(invoice, ratio, deductibleTax, explanation, ncAccountCode);
                    ArrayList<AssItem> assItemList1 = new ArrayList<AssItem>();
                    assItemList1.add(VoucherUtils.createAssItem("\u90e8\u95e8", reimbursementDetails.getDepartment().getTargetCode()));
                    Ass ass1 = new Ass();
                    ass1.setItems(assItemList1);
                    assList1.add(ass1);
                    item1.setAssList(assList1);
                    items.add(item1);
                }
                Item item2 = null;
                Item item22 = null;
                Item item222 = null;
                String pkAccasoa = "";
                if (BigDecimal.ZERO.compareTo(deductibleTax) != 0 || subjectName.equals("1301\u5176\u4ed6") || subjectName.equals("0408\u57f9\u8bad\u8d39")) {
                    item2 = null;
                    item22 = null;
                    item222 = null;
                    Ass ass2 = new Ass();
                    ArrayList<AssItem> assItemList2 = new ArrayList<AssItem>();
                    ArrayList<Ass> assList2 = new ArrayList<Ass>();
                    switch (subjectName) {
                        case "1301\u5176\u4ed6": {
                            pkAccasoa = "22110102";
                            item222 = VoucherUtils.createItem(2, explanation, invoice.getInvoiceAmount(), invoice.getInvoiceAmount(), BigDecimal.ZERO, pkAccasoa);
                            item22 = VoucherUtils.createItem(2, explanation, BigDecimal.ZERO, BigDecimal.ZERO, invoice.getInvoiceAmount(), pkAccasoa);
                            break;
                        }
                        case "0408\u57f9\u8bad\u8d39": {
                            pkAccasoa = "22110106";
                            if (BigDecimal.ZERO.compareTo(deductibleTax) != 0) {
                                item2 = VoucherUtils.createItem(2, "\u53d1\u7968\u53f7\u7801:" + invoice.getInvoiceNumber(), invoice.getInvoiceTax(), invoice.getInvoiceTax(), BigDecimal.ZERO, "22210101");
                            }
                            item22 = VoucherUtils.createItem(2, explanation, BigDecimal.ZERO, BigDecimal.ZERO, invoice.getInvoiceAmount(), pkAccasoa);
                            item222 = VoucherUtils.createItem(2, explanation, invoice.getInvoiceAmount(), invoice.getInvoiceAmount(), BigDecimal.ZERO, pkAccasoa);
                            break;
                        }
                        default: {
                            String invoiceExplanation = this.generateInvoiceExplanation(invoice);
                            if (BigDecimal.ZERO.compareTo(deductibleTax) == 0) break;
                            item2 = VoucherUtils.createItem(2, invoiceExplanation, invoice.getInvoiceTax(), invoice.getInvoiceTax(), BigDecimal.ZERO, "22210101");
                        }
                    }
                    if (item2 != null) {
                        assItemList2.add(VoucherUtils.createAssItem("\u7a0e\u7387\u5f81\u6536\u7387", rate));
                        assItemList2.add(VoucherUtils.createAssItem("\u8fdb\u9879\u5206\u7c7b", "03"));
                        ass2.setItems(assItemList2);
                        assList2.add(ass2);
                        item2.setAssList(assList2);
                    }
                    if (item2 != null) {
                        items.add(item2);
                    }
                    if (item22 != null) {
                        items.add(item22);
                    }
                    if (item222 != null) {
                        items.add(item222);
                    }
                }
                Item item3 = null;
                ArrayList<Ass> assList3 = new ArrayList<Ass>();
                Ass ass3 = new Ass();
                ArrayList<AssItem> assItemList3 = new ArrayList<AssItem>();
                item3 = bankCard.getAccountType().equals("01") ? VoucherUtils.createItem(3, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), invoice.getInvoiceAmount(), "122102") : VoucherUtils.createItem(3, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), invoice.getInvoiceAmount(), "122101");
                if (reimbursementDetails.getApplicantInfo() != null && reimbursementDetails.getApplicantInfo().get("name") != null) {
                    assItemList3.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
                }
                assItemList3.add(VoucherUtils.createAssItem("\u6b3e\u9879\u6027\u8d28", "0101"));
                ass3.setItems(assItemList3);
                assList3.add(ass3);
                item3.setAssList(assList3);
                items.add(item3);
            }
            if ("\u5dee\u65c5\u8d39".equals(reimbursementDetails.getRecords().getRecordType()) && BigDecimal.ZERO.compareTo(bigDecimal = this.fetchReimbursementDetails.calculateTotalAmountAndReimb(recordsEntity.getId(), reimbursementDetails)) != 0) {
                this.processTravelAllowance(reimbursementDetails, bigDecimal, items, organizationName);
            }
            return (sendResult = this.voucherService.processVoucher(ufInterface, voucherHead, items, recordsEntity.getId(), recordsEntity.getOrderNumber(), recordsEntity.getTitle())) != null && sendResult.getInt((Object)"resultcode") == 1;
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u62a5\u9500\u8bb0\u5f55\u65f6\u53d1\u751f\u5f02\u5e38\uff0cID: {}\uff0c\u9519\u8bef\u4fe1\u606f: {}", new Object[]{"\u672a\u77e5", e.getMessage(), e});
            return false;
        }
    }

    private void processTravelAllowance(ReimbursementDetails reimbursementDetails, BigDecimal totalAmount, List<Item> items, String organizationName) {
        ArrayList<Ass> assList4 = new ArrayList<Ass>();
        EcsPlatformAccountMappingEntity accountMappingEntity = this.fetchReimbursementDetails.getAccountMapping(null, reimbursementDetails.getDepartment().getId(), "0101");
        for (EcsRecordsProjectEntity recordsProject : reimbursementDetails.getRecordsProjects()) {
            Double ratio = recordsProject.getRatio() != null ? Double.valueOf(recordsProject.getRatio() / 100.0) : null;
            Item item4 = this.createReimbItemBasedOnTax(totalAmount, ratio, totalAmount, "\u51fa\u5dee\u8865\u52a9", accountMappingEntity != null ? accountMappingEntity.getNcAccountCode() : null);
            ArrayList<AssItem> assItemList4 = new ArrayList<AssItem>();
            assItemList4.add(VoucherUtils.createAssItem("\u90e8\u95e8", reimbursementDetails.getDepartment().getTargetCode()));
            Ass ass4 = new Ass();
            ass4.setItems(assItemList4);
            assList4.add(ass4);
            item4.setAssList(assList4);
            items.add(item4);
        }
        Item item5 = this.createSecondReimbItem(reimbursementDetails, totalAmount);
        items.add(item5);
    }

    private Item createSecondReimbItem(ReimbursementDetails reimbursementDetails, BigDecimal totalAmount) {
        Item item5 = VoucherUtils.createItem(3, "\u51fa\u5dee\u8865\u52a9", BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), totalAmount, "122102");
        ArrayList<Ass> assList5 = new ArrayList<Ass>();
        Ass ass5 = new Ass();
        ArrayList<AssItem> assItemList5 = new ArrayList<AssItem>();
        if (reimbursementDetails.getApplicantInfo() != null && reimbursementDetails.getApplicantInfo().get("name") != null) {
            assItemList5.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
        }
        assItemList5.add(VoucherUtils.createAssItem("\u6b3e\u9879\u6027\u8d28", "0101"));
        ass5.setItems(assItemList5);
        assList5.add(ass5);
        item5.setAssList(assList5);
        return item5;
    }

    private Item createItemBasedOnTax(EcsInvoiceEntity invoice, Double ratio, BigDecimal deductibleTax, String explanation, String accountCode) {
        if (BigDecimal.ZERO.compareTo(deductibleTax) != 0) {
            return VoucherUtils.createItem(1, explanation, invoice.getInvoiceAmountPreTax().multiply(BigDecimal.valueOf(ratio)), invoice.getInvoiceAmountPreTax().multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
        }
        return VoucherUtils.createItem(1, explanation, invoice.getInvoiceAmount().multiply(BigDecimal.valueOf(ratio)), invoice.getInvoiceAmount().multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
    }

    private Item createConsistentItemBasedOnTax(EcsInvoiceEntity invoice, EcsRecordsChargesDetailEntity chargesDetail, Double ratio, BigDecimal deductibleTax, String explanation, String accountCode) {
        if (BigDecimal.ZERO.compareTo(deductibleTax) != 0) {
            BigDecimal subtract = chargesDetail.getActualAmount().subtract(deductibleTax);
            return VoucherUtils.createItem(1, explanation, subtract.multiply(BigDecimal.valueOf(ratio)), subtract.multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
        }
        return VoucherUtils.createItem(1, explanation, chargesDetail.getActualAmount().multiply(BigDecimal.valueOf(ratio)), chargesDetail.getActualAmount().multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
    }

    private Item createReimbItemBasedOnTax(BigDecimal reimb, Double ratio, BigDecimal deductibleTax, String explanation, String accountCode) {
        return VoucherUtils.createItem(1, explanation, reimb.multiply(BigDecimal.valueOf(ratio)), reimb.multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
    }

    private String generateExplanation(Map<String, Object> userMap, EcsRecordsChargesDetailEntity chargesDetail, EcsRecordsEntity recordsEntity) {
        String name = userMap.get("name").toString();
        String recordType = recordsEntity.getRecordType();
        String orderNumber = recordsEntity.getOrderNumber();
        String reasons = "\u65e5\u5e38\u8d39\u7528".equals(recordType) ? "-" + recordsEntity.getReasons() : "";
        return String.format("\u62a5\u9500-%s-%s%s%s", name, recordType, reasons, orderNumber);
    }

    private String generateInvoiceExplanation(EcsInvoiceEntity invoice) {
        return invoice.getServiceTypeName() + "-" + invoice.getInvoiceNumber() + "-" + invoice.getInvoiceType();
    }

    public static boolean isDepartmentValid(String departmentName) {
        List<String> DEPARTMENTS = Arrays.asList("\u4ea7\u54c1\u90e8", "\u5f00\u53d1\u90e8", "\u7814\u7a76\u90e8");
        return DEPARTMENTS.contains(departmentName);
    }
}

