/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.strategy.voucher;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.bringspring.ecs.docking.entity.nc.ReimbursementDetails;
import com.bringspring.ecs.docking.entity.nc.voucher.Ass;
import com.bringspring.ecs.docking.entity.nc.voucher.AssItem;
import com.bringspring.ecs.docking.entity.nc.voucher.Item;
import com.bringspring.ecs.docking.entity.nc.voucher.UfInterface;
import com.bringspring.ecs.docking.entity.nc.voucher.VoucherHead;
import com.bringspring.ecs.docking.enums.TaxRateEnums;
import com.bringspring.ecs.docking.service.impl.FetchReimbursementDetails;
import com.bringspring.ecs.docking.strategy.VoucherOperationStrategy;
import com.bringspring.ecs.docking.utils.VoucherService;
import com.bringspring.ecs.docking.utils.VoucherUtils;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsPlatformAccountMappingEntity;
import com.bringspring.ecs.entity.EcsProjectEntity;
import com.bringspring.ecs.entity.EcsRecordsChargesDetailEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsProjectEntity;
import com.bringspring.ecs.service.EcsProjectService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.utils.XmlConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RkVoucherPushHandle
implements VoucherOperationStrategy {
    private static final Logger log = LoggerFactory.getLogger(RkVoucherPushHandle.class);
    @Value(value="${nc.sender}")
    private String sender;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private FetchReimbursementDetails fetchReimbursementDetails;
    @Autowired
    private EcsProjectService projectService;
    @Autowired
    private VoucherService voucherService;

    @Override
    public List<String> actionMethod() {
        return Arrays.asList("\u8363\u79d1\u79d1\u6280\u80a1\u4efd\u6709\u9650\u516c\u53f8");
    }

    @Override
    public boolean handler(Object data) {
        try {
            JSONObject sendResult;
            BigDecimal bigDecimal;
            EcsRecordsEntity recordsEntity = XmlConverter.convert(data, EcsRecordsEntity.class);
            ReimbursementDetails reimbursementDetails = this.fetchReimbursementDetails.fetchReimbursementDetails(recordsEntity.getId());
            if (reimbursementDetails == null) {
                log.info("\u672a\u627e\u5230\u62a5\u9500\u8be6\u60c5\uff0cID: ", (Object)recordsEntity.getId());
                return false;
            }
            String bankCardId = recordsEntity.getBankCardId();
            EcsBankCardEntity bankCard = this.fetchReimbursementDetails.getBankCard(bankCardId);
            String type = "";
            String organizationName = reimbursementDetails.getRecords().getOrganizationName();
            List<EcsRecordsProjectEntity> recordsProjects = reimbursementDetails.getRecordsProjects();
            Optional<EcsRecordsProjectEntity> firstEntityOptional = recordsProjects.stream().findFirst();
            String recordType = recordsEntity.getRecordType();
            UfInterface ufInterface = VoucherUtils.createUfInterface(reimbursementDetails.getCompany(), this.sender);
            VoucherHead voucherHead = VoucherUtils.createVoucherHead(recordsEntity.getId(), reimbursementDetails.getCompany(), reimbursementDetails.getPreparedBy());
            ArrayList<Item> items = new ArrayList<Item>();
            for (EcsInvoiceEntity invoice : reimbursementDetails.getInvoices()) {
                String invoiceOp = invoice.getInvoiceOp();
                EcsRecordsChargesDetailEntity chargesDetail = reimbursementDetails.getChargesDetails().get(invoice.getSubjectId());
                if (chargesDetail == null) {
                    log.warn("\u672a\u627e\u5230\u8d39\u7528\u660e\u7ec6\uff0c\u53d1\u7968\u79d1\u76eeID: {}", (Object)invoice.getSubjectId());
                    continue;
                }
                boolean isValidDepartment = RkVoucherPushHandle.isDepartmentValid(organizationName);
                String subjectName = chargesDetail.getSubjectName();
                type = this.determineType(firstEntityOptional, organizationName, chargesDetail);
                EcsPlatformAccountMappingEntity accountMappingEntity = this.fetchReimbursementDetails.getAccountMapping(type, reimbursementDetails.getDepartment().getId(), chargesDetail.getSubjectCode());
                String explanation = VoucherUtils.generateExplanation(reimbursementDetails.getApplicantInfo(), chargesDetail, reimbursementDetails.getRecords());
                String invoiceTaxRate = invoice.getInvoiceTaxRate();
                String rate = StrUtil.isNotBlank((CharSequence)invoiceTaxRate) ? TaxRateEnums.getDescByCode(invoiceTaxRate) : TaxRateEnums.getDescByCode("0%");
                BigDecimal deductibleTax = invoice.getDeductibleTax();
                ArrayList<Ass> assList1 = new ArrayList<Ass>();
                for (EcsRecordsProjectEntity recordsProject : reimbursementDetails.getRecordsProjects()) {
                    Double ratio = recordsProject.getRatio() != null ? Double.valueOf(recordsProject.getRatio() / 100.0) : null;
                    Item item1 = null;
                    item1 = subjectName.equals("01\u63a2\u4eb2\u5047\u8d39\u7528") ? this.createItemBasedOnTax(invoice, ratio, BigDecimal.ZERO, explanation, accountMappingEntity != null ? accountMappingEntity.getNcAccountCode() : null) : this.createItemBasedOnTax(invoice, ratio, deductibleTax, explanation, accountMappingEntity != null ? accountMappingEntity.getNcAccountCode() : null);
                    Object assItemList1 = new ArrayList();
                    assItemList1.add(VoucherUtils.createAssItem("\u90e8\u95e8", reimbursementDetails.getDepartment().getTargetCode()));
                    if (RkVoucherPushHandle.isDepartmentValid(organizationName) && !subjectName.equals("02\u62db\u5f85\u8d39")) {
                        reimbursementDetails.getProjects().forEach(arg_0 -> RkVoucherPushHandle.lambda$handler$0((List)assItemList1, arg_0));
                    }
                    Ass ass1 = new Ass();
                    ass1.setItems((List<AssItem>)assItemList1);
                    assList1.add(ass1);
                    item1.setAssList(assList1);
                    items.add(item1);
                }
                Item item2 = null;
                Item item22 = null;
                Item item222 = null;
                String pkAccasoa = "";
                if (BigDecimal.ZERO.compareTo(deductibleTax) != 0 || subjectName.equals("01\u63a2\u4eb2\u5047\u8d39\u7528") || subjectName.equals("0408\u57f9\u8bad\u8d39") || subjectName.equals("1101\u4fdd\u9669\u8d39")) {
                    item2 = null;
                    item22 = null;
                    item222 = null;
                    switch (subjectName) {
                        case "01\u63a2\u4eb2\u5047\u8d39\u7528": 
                        case "1101\u4fdd\u9669\u8d39": {
                            pkAccasoa = "22110102";
                            item222 = VoucherUtils.createItem(2, explanation, invoice.getInvoiceAmount(), invoice.getInvoiceAmount(), BigDecimal.ZERO, pkAccasoa);
                            item22 = VoucherUtils.createItem(2, explanation, BigDecimal.ZERO, BigDecimal.ZERO, invoice.getInvoiceAmount(), pkAccasoa);
                            break;
                        }
                        case "0408\u57f9\u8bad\u8d39": {
                            pkAccasoa = "22110106";
                            if (BigDecimal.ZERO.compareTo(deductibleTax) != 0) {
                                item2 = VoucherUtils.createItem(2, "\u53d1\u7968\u53f7\u7801:" + invoice.getInvoiceNumber(), invoice.getInvoiceTax(), invoice.getInvoiceTax(), BigDecimal.ZERO, "22210101");
                            }
                            item22 = VoucherUtils.createItem(2, explanation, BigDecimal.ZERO, BigDecimal.ZERO, invoice.getInvoiceAmount(), pkAccasoa);
                            item222 = VoucherUtils.createItem(2, explanation, invoice.getInvoiceAmount(), invoice.getInvoiceAmount(), BigDecimal.ZERO, pkAccasoa);
                            break;
                        }
                        default: {
                            if (BigDecimal.ZERO.compareTo(deductibleTax) == 0) break;
                            String str = "";
                            if (invoiceOp.equals("train_ticket") || invoiceOp.equals("passenger_transport_invoice")) {
                                str = "\uff08\u8f66\u7968\u62b5\u6263," + invoice.getInvoiceAmount().setScale(2, RoundingMode.HALF_UP) + ",1)";
                            }
                            item2 = VoucherUtils.createItem(2, "\u53d1\u7968\u53f7\u7801:" + invoice.getInvoiceNumber() + str, invoice.getInvoiceTax(), invoice.getInvoiceTax(), BigDecimal.ZERO, "22210101");
                        }
                    }
                    if (item2 != null) {
                        List<Ass> assList2 = VoucherUtils.createAssList("\u7a0e\u7387\u5f81\u6536\u7387", rate);
                        item2.setAssList(assList2);
                    }
                    if (item2 != null) {
                        items.add(item2);
                    }
                    if (item22 != null) {
                        items.add(item22);
                    }
                    if (item222 != null) {
                        items.add(item222);
                    }
                }
                Item item3 = null;
                ArrayList<Ass> assList3 = new ArrayList<Ass>();
                Ass ass3 = new Ass();
                ArrayList<AssItem> assItemList3 = new ArrayList<AssItem>();
                item3 = bankCard.getAccountType().equals("01") ? VoucherUtils.createItem(3, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), invoice.getInvoiceAmount(), "122102") : VoucherUtils.createItem(3, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), invoice.getInvoiceAmount(), "122101");
                if (reimbursementDetails.getApplicantInfo() != null && reimbursementDetails.getApplicantInfo().get("name") != null) {
                    assItemList3.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
                }
                assItemList3.add(VoucherUtils.createAssItem("\u6b3e\u9879\u6027\u8d28", "0101"));
                ass3.setItems(assItemList3);
                assList3.add(ass3);
                item3.setAssList(assList3);
                items.add(item3);
            }
            if ("\u5dee\u65c5\u8d39".equals(reimbursementDetails.getRecords().getRecordType()) && BigDecimal.ZERO.compareTo(bigDecimal = this.fetchReimbursementDetails.calculateTotalAmountAndReimb(recordsEntity.getId(), reimbursementDetails)) != 0) {
                this.processTravelAllowance(type, reimbursementDetails, bigDecimal, items, organizationName);
            }
            return (sendResult = this.voucherService.processVoucher(ufInterface, voucherHead, items, recordsEntity.getId(), recordsEntity.getOrderNumber(), recordsEntity.getTitle())) != null && sendResult.getInt((Object)"resultcode") == 1;
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u62a5\u9500\u8bb0\u5f55\u65f6\u53d1\u751f\u5f02\u5e38\uff0cID: {}\uff0c\u9519\u8bef\u4fe1\u606f: {}", new Object[]{"\u672a\u77e5", e.getMessage(), e});
            return false;
        }
    }

    private void processTravelAllowance(String type, ReimbursementDetails reimbursementDetails, BigDecimal totalAmount, List<Item> items, String organizationName) {
        ArrayList<Ass> assList4 = new ArrayList<Ass>();
        EcsPlatformAccountMappingEntity accountMappingEntity = this.fetchReimbursementDetails.getAccountMapping(type, reimbursementDetails.getDepartment().getId(), "0101");
        for (EcsRecordsProjectEntity recordsProject : reimbursementDetails.getRecordsProjects()) {
            Double ratio = recordsProject.getRatio() != null ? Double.valueOf(recordsProject.getRatio() / 100.0) : null;
            Item item4 = this.createReimbItemBasedOnTax(totalAmount, ratio, totalAmount, "\u51fa\u5dee\u8865\u52a9", accountMappingEntity != null ? accountMappingEntity.getNcAccountCode() : null);
            ArrayList<AssItem> assItemList4 = new ArrayList<AssItem>();
            assItemList4.add(VoucherUtils.createAssItem("\u90e8\u95e8", reimbursementDetails.getDepartment().getTargetCode()));
            if (RkVoucherPushHandle.isDepartmentValid(organizationName)) {
                reimbursementDetails.getProjects().forEach(projectEntity -> assItemList4.add(VoucherUtils.createAssItem("\u9879\u76ee", projectEntity.getCode())));
            }
            Ass ass4 = new Ass();
            ass4.setItems(assItemList4);
            assList4.add(ass4);
            item4.setAssList(assList4);
            items.add(item4);
        }
        Item item5 = this.createSecondReimbItem(reimbursementDetails, totalAmount);
        items.add(item5);
    }

    private Item createSecondReimbItem(ReimbursementDetails reimbursementDetails, BigDecimal totalAmount) {
        Item item5 = VoucherUtils.createItem(3, "\u51fa\u5dee\u8865\u52a9", BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), totalAmount, "122102");
        ArrayList<Ass> assList5 = new ArrayList<Ass>();
        Ass ass5 = new Ass();
        ArrayList<AssItem> assItemList5 = new ArrayList<AssItem>();
        if (reimbursementDetails.getApplicantInfo() != null && reimbursementDetails.getApplicantInfo().get("name") != null) {
            assItemList5.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
        }
        assItemList5.add(VoucherUtils.createAssItem("\u6b3e\u9879\u6027\u8d28", "0101"));
        ass5.setItems(assItemList5);
        assList5.add(ass5);
        item5.setAssList(assList5);
        return item5;
    }

    private Item createItemBasedOnTax(EcsInvoiceEntity invoice, Double ratio, BigDecimal deductibleTax, String explanation, String accountCode) {
        if (BigDecimal.ZERO.compareTo(deductibleTax) != 0) {
            return VoucherUtils.createItem(1, explanation, invoice.getInvoiceAmountPreTax().multiply(BigDecimal.valueOf(ratio)), invoice.getInvoiceAmountPreTax().multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
        }
        return VoucherUtils.createItem(1, explanation, invoice.getInvoiceAmount().multiply(BigDecimal.valueOf(ratio)), invoice.getInvoiceAmount().multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
    }

    private Item createReimbItemBasedOnTax(BigDecimal reimb, Double ratio, BigDecimal deductibleTax, String explanation, String accountCode) {
        return VoucherUtils.createItem(1, explanation, reimb.multiply(BigDecimal.valueOf(ratio)), reimb.multiply(BigDecimal.valueOf(ratio)), BigDecimal.ZERO, accountCode);
    }

    public String determineType(Optional<EcsRecordsProjectEntity> firstEntityOptional, String organizationName, EcsRecordsChargesDetailEntity chargesDetail) {
        boolean isValidDepartment = RkVoucherPushHandle.isDepartmentValid(organizationName);
        String subjectName = chargesDetail.getSubjectName();
        String type = null;
        if (isValidDepartment) {
            EcsRecordsProjectEntity firstEntity;
            EcsProjectEntity info;
            if (firstEntityOptional.isPresent() && ObjectUtil.isNotEmpty((Object)(info = this.projectService.getInfo((firstEntity = firstEntityOptional.get()).getProjectId())))) {
                type = info.getType();
            }
            if ("01\u63a2\u4eb2\u5047\u8d39\u7528".equals(subjectName)) {
                if ("1".equals(type)) {
                    type = "4";
                } else if ("2".equals(type)) {
                    type = "5";
                }
            }
        } else if ("01\u63a2\u4eb2\u5047\u8d39\u7528".equals(subjectName)) {
            type = "3";
        } else if ("01\u5dee\u65c5\u8d39".equals(subjectName)) {
            type = "0";
        }
        return type;
    }

    public static boolean isDepartmentValid(String departmentName) {
        List<String> DEPARTMENTS = Arrays.asList("\u7814\u53d1\u90e8", "\u4ea7\u54c1\u90e8", "\u7f51\u7edc\u4fe1\u606f\u90e8");
        return DEPARTMENTS.contains(departmentName);
    }

    private static /* synthetic */ void lambda$handler$0(List assItemList1, EcsProjectEntity projectEntity) {
        assItemList1.add(VoucherUtils.createAssItem("\u9879\u76ee", projectEntity.getCode()));
    }
}

