/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.task;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.ecs.docking.service.SkPaymentService;
import com.bringspring.ecs.entity.EcsCompanyAccountEntity;
import com.bringspring.ecs.entity.EcsPaymentRecordsEntity;
import com.bringspring.ecs.service.EcsCompanyAccountService;
import com.bringspring.ecs.service.EcsPaymentRecordsService;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentTask {
    private static final Logger log = LoggerFactory.getLogger(PaymentTask.class);
    @Autowired
    private EcsPaymentRecordsService paymentRecordsService;
    @Autowired
    private SkPaymentService skPaymentService;
    @Autowired
    private EcsCompanyAccountService companyAccountService;

    @JsbosTask(fullName="\u5b9a\u65f6\u67e5\u8be2\u53f8\u5e93\u4ed8\u6b3e\u72b6\u6001\u4efb\u52a1", description="\u5b9a\u65f6\u67e5\u8be2\u53f8\u5e93\u4ed8\u6b3e\u72b6\u6001\u4efb\u52a1")
    public void checkPayStatusTask() {
        LocalDate today = LocalDate.now();
        LocalDate dayBeforeYesterday = today.minusWeeks(2L);
        List paymentRecordsEntities = this.paymentRecordsService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ne(EcsPaymentRecordsEntity::getPayState, (Object)4)).between(EcsPaymentRecordsEntity::getCreatorTime, (Object)dayBeforeYesterday.atStartOfDay(), (Object)today.atTime(23, 59, 59)));
        if (CollectionUtil.isNotEmpty((Collection)paymentRecordsEntities)) {
            paymentRecordsEntities.forEach(paymentRecordsEntity -> {
                this.skPaymentService.singlePaymentCheck(paymentRecordsEntity.getId());
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("\u7ebf\u7a0b\u88ab\u4e2d\u65ad", e);
                }
            });
        }
    }

    @JsbosTask(fullName="\u4e34\u65f6\u5b9a\u65f6\u67e5\u8be2\u53f8\u5e93\u4ed8\u6b3e\u72b6\u6001\u4efb\u52a1", description="\u4e34\u65f6\u5b9a\u65f6\u67e5\u8be2\u53f8\u5e93\u4ed8\u6b3e\u72b6\u6001\u4efb\u52a1")
    public void temporarycheckPayStatusTask() {
        LocalDate today = LocalDate.now();
        LocalDate dayBeforeYesterday = today.minusDays(2L);
        List paymentRecordsEntities = this.paymentRecordsService.list((Wrapper)Wrappers.lambdaQuery().ne(EcsPaymentRecordsEntity::getPayState, (Object)4));
        if (CollectionUtil.isNotEmpty((Collection)paymentRecordsEntities)) {
            paymentRecordsEntities.forEach(paymentRecordsEntity -> {
                this.skPaymentService.singlePaymentCheck(paymentRecordsEntity.getId());
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("\u7ebf\u7a0b\u88ab\u4e2d\u65ad", e);
                }
            });
        }
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u67e5\u8be2\u53f8\u5e93\u4ed8\u6b3e\u6210\u529f\u56de\u5355\u4efb\u52a1", description="\u5b9a\u65f6\u67e5\u8be2\u53f8\u5e93\u4ed8\u6b3e\u6210\u529f\u56de\u5355\u4efb\u52a1")
    public void getReceiptTask() {
        List companyAccountEntities = this.companyAccountService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getEnabledMark, (Object)"1"));
        companyAccountEntities.forEach(o -> this.skPaymentService.receiptApply(o.getAccount()));
    }

    @JsbosTask(fullName="\u4e34\u65f6\u5b9a\u65f6\u67e5\u8be2\u53f8\u5e93\u4ed8\u6b3e\u6210\u529f\u56de\u5355\u4efb\u52a1", description="\u4e34\u65f6\u5b9a\u65f6\u67e5\u8be2\u53f8\u5e93\u4ed8\u6b3e\u6210\u529f\u56de\u5355\u4efb\u52a1")
    public void temporarygetReceiptTask() {
        List companyAccountEntities = this.companyAccountService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getEnabledMark, (Object)"1"));
        companyAccountEntities.forEach(o -> this.skPaymentService.temporaryreceiptApply(o.getAccount()));
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u67e5\u8be2\u94f6\u884c\u5386\u53f2\u660e\u7ec6\u4efb\u52a1", description="\u5b9a\u65f6\u67e5\u8be2\u94f6\u884c\u5386\u53f2\u660e\u7ec6\u4efb\u52a1")
    public void getBankHistoryDetailTask() {
        List companyAccountEntities = this.companyAccountService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getEnabledMark, (Object)"1")).eq(EcsCompanyAccountEntity::getIsZl, (Object)"1"));
        companyAccountEntities.forEach(o -> this.skPaymentService.HistoryDetailApply(o.getCompanyId(), o.getAccount()));
    }
}

