/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OracleDBUtil {
    private static final Logger log = LoggerFactory.getLogger(OracleDBUtil.class);
    @Value(value="${nc.dbUrl}")
    private String url;
    @Value(value="${nc.dbUsername}")
    private String username;
    @Value(value="${nc.dbPassword}")
    private String password;

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public String queryById(String id) {
        log.info("\u67e5\u8be2id\u4e3a{}\u7684\u51ed\u8bc1\u4fe1\u606f", (Object)id);
        String sql = "SELECT num FROM gl_voucher WHERE pk_sourcepk = ?";
        String resultNum = null;
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, id);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    resultNum = resultSet.getString("num");
                }
            }
            log.info("\u51ed\u8bc1\u4fe1\u606f,{}", (Object)resultNum);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultNum;
    }
}

