/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.utils;

import com.bringspring.ecs.docking.entity.nc.voucher.Ass;
import com.bringspring.ecs.docking.entity.nc.voucher.Item;
import com.bringspring.ecs.docking.entity.nc.voucher.VoucherHead;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class VoucherMerger {
    private final List<Item> items;
    private final VoucherHead head;

    public VoucherMerger(List<Item> items, VoucherHead head) {
        this.items = items;
        this.head = head;
    }

    public void mergeItems() {
        HashMap<String, Item> mergedItems = new HashMap<String, Item>();
        ArrayList<Item> nonMergeableItems = new ArrayList<Item>();
        for (Item item : this.items) {
            String key = this.generateKey(item);
            if (item.getPk_accasoa().equals("22110102")) {
                this.handleSpecialItem(item, mergedItems);
                continue;
            }
            if (item.getPk_accasoa().equals("22210101") || item.getPk_accasoa().equals("22110106")) {
                nonMergeableItems.add(item);
                continue;
            }
            if (mergedItems.containsKey(key)) {
                this.mergeExistingItem((Item)mergedItems.get(key), item);
                continue;
            }
            mergedItems.put(key, item);
        }
        for (int i = 0; i < nonMergeableItems.size(); ++i) {
            Item nonMergeableItem = (Item)nonMergeableItems.get(i);
            String uniqueKey = this.generateUniqueKey(nonMergeableItem, i);
            mergedItems.put(uniqueKey, nonMergeableItem);
        }
        this.updateVoucherHead(mergedItems);
    }

    private String generateKey(Item item) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(item.getPk_accasoa()).append("-");
        if (item.getAssList() != null) {
            ArrayList<String> checkKeys = new ArrayList<String>();
            for (Ass ass : item.getAssList()) {
                if (ass.getItems() == null) continue;
                String checkKey = ass.getItems().stream().map(assItem -> assItem.getPkChecktype() + ":" + assItem.getPkCheckvalue()).sorted().collect(Collectors.joining(","));
                checkKeys.add(checkKey);
            }
            keyBuilder.append(String.join((CharSequence)";", checkKeys));
        }
        return keyBuilder.toString();
    }

    private String generateUniqueKey(Item item, int index) {
        return item.getPk_accasoa() + "-" + index;
    }

    private void mergeExistingItem(Item existingItem, Item newItem) {
        existingItem.setDebitamount(existingItem.getDebitamount().add(newItem.getDebitamount()));
        existingItem.setLocaldebitamount(existingItem.getLocaldebitamount().add(newItem.getLocaldebitamount()));
        existingItem.setCreditamount(existingItem.getCreditamount().add(newItem.getCreditamount()));
        existingItem.setLocalcreditamount(existingItem.getLocalcreditamount().add(newItem.getLocalcreditamount()));
    }

    private void updateVoucherHead(Map<String, Item> mergedItems) {
        ArrayList<Item> result = new ArrayList<Item>(mergedItems.values());
        result.sort(Comparator.comparingInt(Item::getDetailindex));
        this.head.getDetails().setItems(result);
    }

    private void handleSpecialItem(Item item, Map<String, Item> mergedItems) {
        String direction = this.determineDirection(item);
        String directionKey = this.generateKey(item) + "-" + direction;
        if (mergedItems.containsKey(directionKey)) {
            this.mergeExistingItem(mergedItems.get(directionKey), item);
        } else {
            Item clonedItem = this.cloneItem(item);
            mergedItems.put(directionKey, clonedItem);
        }
    }

    private String determineDirection(Item item) {
        boolean isDebit = item.getDebitamount().compareTo(BigDecimal.ZERO) > 0;
        return isDebit ? "Debit" : "Credit";
    }

    private Item cloneItem(Item original) {
        Item cloned = new Item();
        BeanUtils.copyProperties((Object)original, (Object)cloned);
        return cloned;
    }
}

