/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.docking.entity.sk.history.ResRow;
import com.bringspring.ecs.entity.EcsBankTransactionHistoryEntity;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.mapper.EcsBankTransactionHistoryMapper;
import com.bringspring.ecs.model.ecsbanktransactionhistory.EcsBankTransactionHistoryCrForm;
import com.bringspring.ecs.model.ecsbanktransactionhistory.EcsBankTransactionHistoryPagination;
import com.bringspring.ecs.model.ecsbanktransactionhistory.EcsBankTransactionHistoryUpForm;
import com.bringspring.ecs.service.EcsBankTransactionHistoryService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsBankTransactionHistoryServiceImpl
extends ServiceImpl<EcsBankTransactionHistoryMapper, EcsBankTransactionHistoryEntity>
implements EcsBankTransactionHistoryService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsCompanyService companyService;

    @Override
    public List<EcsBankTransactionHistoryEntity> getList(EcsBankTransactionHistoryPagination ecsBankTransactionHistoryPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBankTransactionHistoryNum = 0;
        QueryWrapper ecsBankTransactionHistoryQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsBankTransactionHistoryPagination.getCompanyId())) {
            ++ecsBankTransactionHistoryNum;
            ecsBankTransactionHistoryQueryWrapper.lambda().like(EcsBankTransactionHistoryEntity::getCompanyId, (Object)ecsBankTransactionHistoryPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)ecsBankTransactionHistoryPagination.getAccountNo())) {
            ++ecsBankTransactionHistoryNum;
            ecsBankTransactionHistoryQueryWrapper.lambda().like(EcsBankTransactionHistoryEntity::getAccountNo, (Object)ecsBankTransactionHistoryPagination.getAccountNo());
        }
        if (StringUtils.isNotEmpty((String)ecsBankTransactionHistoryPagination.getTranType())) {
            ++ecsBankTransactionHistoryNum;
            ecsBankTransactionHistoryQueryWrapper.lambda().eq(EcsBankTransactionHistoryEntity::getTranType, (Object)ecsBankTransactionHistoryPagination.getTranType());
        }
        if (StringUtils.isNotEmpty((String)ecsBankTransactionHistoryPagination.getOppAccountNo())) {
            ++ecsBankTransactionHistoryNum;
            ecsBankTransactionHistoryQueryWrapper.lambda().like(EcsBankTransactionHistoryEntity::getOppAccountNo, (Object)ecsBankTransactionHistoryPagination.getOppAccountNo());
        }
        if (AllIdList.size() > 0) {
            ecsBankTransactionHistoryQueryWrapper.lambda().in(EcsBankTransactionHistoryEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBankTransactionHistoryPagination.getSidx())) {
            ecsBankTransactionHistoryQueryWrapper.lambda().orderByDesc(EcsBankTransactionHistoryEntity::getId);
        } else {
            try {
                String sidx = ecsBankTransactionHistoryPagination.getSidx();
                EcsBankTransactionHistoryEntity ecsBankTransactionHistoryEntity = new EcsBankTransactionHistoryEntity();
                Field declaredField = ecsBankTransactionHistoryEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBankTransactionHistoryQueryWrapper = "asc".equals(ecsBankTransactionHistoryPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBankTransactionHistoryQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBankTransactionHistoryQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ecsBankTransactionHistoryPagination.getCurrentPage(), ecsBankTransactionHistoryPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsBankTransactionHistoryQueryWrapper);
            return ecsBankTransactionHistoryPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ecsBankTransactionHistoryPagination.setData(list, list.size());
    }

    @Override
    public List<EcsBankTransactionHistoryEntity> getTypeList(EcsBankTransactionHistoryPagination ecsBankTransactionHistoryPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBankTransactionHistoryNum = 0;
        QueryWrapper ecsBankTransactionHistoryQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsBankTransactionHistoryPagination.getCompanyId())) {
            ++ecsBankTransactionHistoryNum;
            ecsBankTransactionHistoryQueryWrapper.lambda().like(EcsBankTransactionHistoryEntity::getCompanyId, (Object)ecsBankTransactionHistoryPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)ecsBankTransactionHistoryPagination.getAccountNo())) {
            ++ecsBankTransactionHistoryNum;
            ecsBankTransactionHistoryQueryWrapper.lambda().like(EcsBankTransactionHistoryEntity::getAccountNo, (Object)ecsBankTransactionHistoryPagination.getAccountNo());
        }
        if (StringUtils.isNotEmpty((String)ecsBankTransactionHistoryPagination.getOppAccountNo())) {
            ++ecsBankTransactionHistoryNum;
            ecsBankTransactionHistoryQueryWrapper.lambda().like(EcsBankTransactionHistoryEntity::getOppAccountNo, (Object)ecsBankTransactionHistoryPagination.getOppAccountNo());
        }
        if (AllIdList.size() > 0) {
            ecsBankTransactionHistoryQueryWrapper.lambda().in(EcsBankTransactionHistoryEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBankTransactionHistoryPagination.getSidx())) {
            ecsBankTransactionHistoryQueryWrapper.lambda().orderByDesc(EcsBankTransactionHistoryEntity::getId);
        } else {
            try {
                String sidx = ecsBankTransactionHistoryPagination.getSidx();
                EcsBankTransactionHistoryEntity ecsBankTransactionHistoryEntity = new EcsBankTransactionHistoryEntity();
                Field declaredField = ecsBankTransactionHistoryEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBankTransactionHistoryQueryWrapper = "asc".equals(ecsBankTransactionHistoryPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBankTransactionHistoryQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBankTransactionHistoryQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ecsBankTransactionHistoryPagination.getCurrentPage(), ecsBankTransactionHistoryPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ecsBankTransactionHistoryQueryWrapper);
                return ecsBankTransactionHistoryPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ecsBankTransactionHistoryPagination.setData(list, list.size());
        }
        return this.list((Wrapper)ecsBankTransactionHistoryQueryWrapper);
    }

    @Override
    public EcsBankTransactionHistoryEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBankTransactionHistoryEntity::getId, (Object)id);
        return (EcsBankTransactionHistoryEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(EcsBankTransactionHistoryCrForm ecsBankTransactionHistoryCrForm) {
        String mainId = RandomUtil.uuId();
        EcsBankTransactionHistoryEntity entity = (EcsBankTransactionHistoryEntity)JsonUtil.getJsonToBean((Object)ecsBankTransactionHistoryCrForm, EcsBankTransactionHistoryEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, EcsBankTransactionHistoryUpForm ecsBankTransactionHistoryUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsBankTransactionHistoryEntity entity = this.getInfo(id);
        if (entity != null) {
            EcsBankTransactionHistoryEntity subentity = (EcsBankTransactionHistoryEntity)JsonUtil.getJsonToBean((Object)ecsBankTransactionHistoryUpForm, EcsBankTransactionHistoryEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public void saveBatch(String companyId, List<ResRow> resRows) {
        EcsCompanyEntity companyEntity = (EcsCompanyEntity)this.companyService.getById((Serializable)((Object)companyId));
        if (CollectionUtil.isNotEmpty(resRows)) {
            ArrayList<EcsBankTransactionHistoryEntity> historyEntitieList = new ArrayList<EcsBankTransactionHistoryEntity>();
            for (ResRow resRow : resRows) {
                EcsBankTransactionHistoryEntity historyEntity = new EcsBankTransactionHistoryEntity();
                historyEntity.setCompanyId(companyId);
                historyEntity.setOrganization(companyEntity.getCompanyId());
                BeanUtils.copyProperties((Object)resRow, (Object)historyEntity);
                historyEntitieList.add(historyEntity);
            }
            this.saveBatch(historyEntitieList);
        }
    }

    @Override
    @DSTransactional
    public void delete(EcsBankTransactionHistoryEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

