/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.ecs.constants.GlobalConstants;
import com.bringspring.ecs.entity.EcsBudgetAccountEntity;
import com.bringspring.ecs.mapper.EcsBudgetAccountMapper;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountCrForm;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountInfoVO;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountListQuery;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountListVO;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountModel;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountPagination;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountSelector;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountUpForm;
import com.bringspring.ecs.service.EcsBudgetAccountService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsBudgetAccountServiceImpl
extends ServiceImpl<EcsBudgetAccountMapper, EcsBudgetAccountEntity>
implements EcsBudgetAccountService {
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public PageListVO getBudgetAccountPageList(EcsBudgetAccountPagination ecsBudgetAccountPagination) {
        List<EcsBudgetAccountEntity> list = this.getList(ecsBudgetAccountPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsBudgetAccountListVO.class);
        for (EcsBudgetAccountListVO vo : listVO) {
            EcsBudgetAccountEntity typeEntity;
            vo.setOrganizeTdsTree(this.baseDataUtil.comSelectValues(vo.getOrganizeTdsTree()));
            if ("-1".equals(vo.getParentId())) {
                vo.setParentId("\u9876\u7ea7\u8282\u70b9");
            }
            if (ObjectUtil.isNotEmpty((Object)(typeEntity = this.getInfo(vo.getParentId())))) {
                vo.setParentId(typeEntity.getFullName());
            }
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
            vo.setDeleteMark(this.baseDataUtil.switchSelectValue(vo.getDeleteMark(), "\u6b63\u5e38", "\u5220\u9664"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsBudgetAccountPagination), PaginationVO.class);
        vo.setPagination(page);
        return vo;
    }

    @Override
    public List<EcsBudgetAccountEntity> getList(EcsBudgetAccountPagination ecsBudgetAccountPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBudgetAccountNum = 0;
        QueryWrapper ecsBudgetAccountQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getParentId())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().eq(EcsBudgetAccountEntity::getParentId, (Object)ecsBudgetAccountPagination.getParentId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getYear())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().eq(EcsBudgetAccountEntity::getYear, (Object)ecsBudgetAccountPagination.getYear());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getBudgetId())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().eq(EcsBudgetAccountEntity::getBudgetId, (Object)ecsBudgetAccountPagination.getBudgetId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getFullName())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().like(EcsBudgetAccountEntity::getFullName, (Object)ecsBudgetAccountPagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getEnCode())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().like(EcsBudgetAccountEntity::getEnCode, (Object)ecsBudgetAccountPagination.getEnCode());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getEnabledMark())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().eq(EcsBudgetAccountEntity::getEnabledMark, (Object)ecsBudgetAccountPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            ecsBudgetAccountQueryWrapper.lambda().in(EcsBudgetAccountEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBudgetAccountPagination.getSidx())) {
            ecsBudgetAccountQueryWrapper.lambda().orderByDesc(EcsBudgetAccountEntity::getParentId);
        } else {
            try {
                String sidx = ecsBudgetAccountPagination.getSidx();
                EcsBudgetAccountEntity ecsBudgetAccountEntity = new EcsBudgetAccountEntity();
                Field declaredField = ecsBudgetAccountEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBudgetAccountQueryWrapper = "asc".equals(ecsBudgetAccountPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBudgetAccountQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBudgetAccountQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ecsBudgetAccountPagination.getCurrentPage(), ecsBudgetAccountPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsBudgetAccountQueryWrapper);
            return ecsBudgetAccountPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ecsBudgetAccountPagination.setData(list, list.size());
    }

    @Override
    public List<EcsBudgetAccountEntity> getTypeList(EcsBudgetAccountPagination ecsBudgetAccountPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBudgetAccountNum = 0;
        QueryWrapper ecsBudgetAccountQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getParentId())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().eq(EcsBudgetAccountEntity::getParentId, (Object)ecsBudgetAccountPagination.getParentId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getFullName())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().like(EcsBudgetAccountEntity::getFullName, (Object)ecsBudgetAccountPagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getEnCode())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().like(EcsBudgetAccountEntity::getEnCode, (Object)ecsBudgetAccountPagination.getEnCode());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAccountPagination.getEnabledMark())) {
            ++ecsBudgetAccountNum;
            ecsBudgetAccountQueryWrapper.lambda().eq(EcsBudgetAccountEntity::getEnabledMark, (Object)ecsBudgetAccountPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            ecsBudgetAccountQueryWrapper.lambda().in(EcsBudgetAccountEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBudgetAccountPagination.getSidx())) {
            ecsBudgetAccountQueryWrapper.lambda().orderByDesc(EcsBudgetAccountEntity::getParentId);
        } else {
            try {
                String sidx = ecsBudgetAccountPagination.getSidx();
                EcsBudgetAccountEntity ecsBudgetAccountEntity = new EcsBudgetAccountEntity();
                Field declaredField = ecsBudgetAccountEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBudgetAccountQueryWrapper = "asc".equals(ecsBudgetAccountPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBudgetAccountQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBudgetAccountQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ecsBudgetAccountPagination.getCurrentPage(), ecsBudgetAccountPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ecsBudgetAccountQueryWrapper);
                return ecsBudgetAccountPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ecsBudgetAccountPagination.setData(list, list.size());
        }
        return this.list((Wrapper)ecsBudgetAccountQueryWrapper);
    }

    @Override
    public List<EcsBudgetAccountEntity> getListAll(EcsBudgetAccountListQuery listQuery) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String keyword = listQuery.getKeyword();
        if (StringUtils.isNotEmpty((String)keyword)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(EcsBudgetAccountEntity::getFullName, (Object)keyword)).or()).like(EcsBudgetAccountEntity::getEnCode, (Object)keyword);
            });
        }
        if (StringUtils.isNotEmpty((String)listQuery.getYear())) {
            queryWrapper.lambda().eq(EcsBudgetAccountEntity::getYear, (Object)listQuery.getYear());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getBudgetId())) {
            queryWrapper.lambda().eq(EcsBudgetAccountEntity::getBudgetId, (Object)listQuery.getBudgetId());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getEnCode())) {
            queryWrapper.lambda().like(EcsBudgetAccountEntity::getEnCode, (Object)listQuery.getEnCode());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getFullName())) {
            queryWrapper.lambda().like(EcsBudgetAccountEntity::getFullName, (Object)listQuery.getFullName());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getParentId())) {
            queryWrapper.lambda().eq(EcsBudgetAccountEntity::getParentId, (Object)listQuery.getParentId());
        }
        queryWrapper.lambda().eq(EcsBudgetAccountEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(EcsBudgetAccountEntity::getSortCode)).orderByAsc(EcsBudgetAccountEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<EcsBudgetAccountInfoVO> getListTree(String parentId, String menuId, String year) {
        List<EcsBudgetAccountEntity> listByParentId = this.getListByParentId(parentId);
        List filteredList = listByParentId.stream().filter(entity -> year.equals(entity.getYear())).collect(Collectors.toList());
        if (!ObjectUtil.isEmpty(filteredList)) {
            List listVO = JsonUtil.getJsonToList(filteredList, EcsBudgetAccountInfoVO.class);
            this.recursionTree(listVO);
            return listVO;
        }
        return new ArrayList<EcsBudgetAccountInfoVO>();
    }

    @Override
    public List<String> getListTreeId(String parentId) {
        List<String> listByParentId = this.getListByParentId(parentId).stream().map(item -> item.getId()).collect(Collectors.toList());
        List<String> strings = this.recursionTreeId(listByParentId);
        return strings;
    }

    @Override
    public List<EcsBudgetAccountEntity> getListByParentId(String parentId) {
        QueryWrapper basDeviceTypeQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)basDeviceTypeQueryWrapper.lambda().eq(EcsBudgetAccountEntity::getParentId, (Object)parentId)).orderByAsc(EcsBudgetAccountEntity::getSortCode);
        List list = this.list((Wrapper)basDeviceTypeQueryWrapper);
        return list;
    }

    @Override
    public List<EcsBudgetAccountEntity> getListByParentId(String parentId, String menuId) {
        Object obj;
        QueryWrapper typeQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            obj = this.authorizeService.getCondition(new AuthorizeConditionModel(typeQueryWrapper, menuId, "ecs_budget_account"));
            if (ObjectUtil.isEmpty((Object)obj)) {
                return new ArrayList<EcsBudgetAccountEntity>();
            }
            typeQueryWrapper = (QueryWrapper)obj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            obj = this.authorizeService.getCondition(new AuthorizeConditionModel(typeQueryWrapper, menuId, "ecs_budget_account"));
            if (ObjectUtil.isEmpty((Object)obj)) {
                return new ArrayList<EcsBudgetAccountEntity>();
            }
            typeQueryWrapper = (QueryWrapper)obj;
        }
        typeQueryWrapper.lambda().eq(EcsBudgetAccountEntity::getParentId, (Object)parentId);
        typeQueryWrapper.lambda().orderByAsc(EcsBudgetAccountEntity::getSortCode);
        List list = this.list((Wrapper)typeQueryWrapper);
        return list;
    }

    @Override
    public EcsBudgetAccountEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBudgetAccountEntity::getId, (Object)id);
        return (EcsBudgetAccountEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(EcsBudgetAccountCrForm ecsBudgetAccountCrForm) {
        String mainId = RandomUtil.uuId();
        EcsBudgetAccountEntity entity = (EcsBudgetAccountEntity)JsonUtil.getJsonToBean((Object)ecsBudgetAccountCrForm, EcsBudgetAccountEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public ActionResult update(String id, EcsBudgetAccountUpForm ecsBudgetAccountUpForm) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        EcsBudgetAccountEntity entity = this.getInfo(id);
        if (entity != null) {
            EcsBudgetAccountEntity subEntity = (EcsBudgetAccountEntity)JsonUtil.getJsonToBean((Object)ecsBudgetAccountUpForm, EcsBudgetAccountEntity.class);
            subEntity.setId(id);
            subEntity.setLastModifyUserId(this.userProvider.get().getUserId());
            this.updateById(subEntity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @Override
    public Map<String, String> getBudgetAccountCache(String parentId) {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        List<EcsBudgetAccountEntity> listByParentId = this.getListByParentId(parentId);
        if (!ObjectUtil.isEmpty(listByParentId)) {
            this.recursionTree(listByParentId, typeMap, "");
        }
        return typeMap;
    }

    @Override
    public Map<String, String> getBudgetAccountCache(String parentId, String menuId) {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        List<EcsBudgetAccountEntity> listByParentId = this.getListByParentId(parentId, menuId);
        if (!ObjectUtil.isEmpty(listByParentId)) {
            this.recursionTree(listByParentId, typeMap, "");
        }
        return typeMap;
    }

    @Override
    public ListVO<EcsBudgetAccountSelector> getBudgetAccountSelector(EcsBudgetAccountListQuery query) {
        List<EcsBudgetAccountEntity> allList = this.getListAll(query);
        List data = allList.stream().filter(t -> EnabledMarkEnum.ENABLE.getCode() == t.getEnabledMark()).collect(Collectors.toList());
        String keyword = query.getKeyword();
        if (!StringUtils.isEmpty((String)keyword)) {
            data = data.stream().filter(t -> t.getFullName().contains(keyword) || t.getEnCode().contains(keyword)).collect(Collectors.toList());
        }
        List models = JsonUtil.getJsonToList(data, EcsBudgetAccountModel.class);
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, EcsBudgetAccountSelector.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return vo;
    }

    @Override
    public List<EcsBudgetAccountEntity> getAccountList(EcsBudgetAccountListQuery query) {
        return this.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetAccountEntity::getEnabledMark, (Object)GlobalConstants.ENABLED_FLAG_YES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadVO excelAccountTemplate(String year) {
        List<EcsBudgetAccountInfoVO> accountEntities = this.getListTree("-1", null, year);
        String templatePath = this.configValueUtil.getTemplateFilePath() + "\u9884\u7b97\u6a21\u7248.xlsx";
        UserInfo userInfo = this.userProvider.get();
        DownloadVO downloadVO = DownloadVO.builder().build();
        try {
            int startRow;
            File temporary = new File(XSSEscape.escapePath((String)templatePath));
            XSSFWorkbook workbook = new XSSFWorkbook(temporary);
            Sheet sheet = workbook.getSheetAt(0);
            int rowIndex = 4;
            int index = 1;
            int endRow = sheet.getLastRowNum();
            for (int i = startRow = 4; i <= endRow; ++i) {
                Row currentRow = sheet.getRow(i);
                if (currentRow == null) continue;
                Iterator iterator = currentRow.iterator();
                while (iterator.hasNext()) {
                    Cell cell = (Cell)iterator.next();
                    cell.setCellValue("");
                }
            }
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            for (EcsBudgetAccountInfoVO detail : accountEntities) {
                List<EcsBudgetAccountInfoVO> detailChildren = detail.getChildren();
                if (!CollectionUtil.isNotEmpty(detailChildren)) continue;
                for (EcsBudgetAccountInfoVO vo : detailChildren) {
                    Row row = sheet.createRow(rowIndex);
                    Cell cellIndex = row.createCell(0);
                    Cell feeControlCell = row.createCell(1);
                    Cell expenseItemCell = row.createCell(2);
                    Cell reportSubjectCell = row.createCell(3);
                    Cell cell1 = row.createCell(4);
                    Cell cell2 = row.createCell(5);
                    Cell cell3 = row.createCell(6);
                    cellIndex.setCellValue((double)index);
                    cellIndex.setCellStyle(cellStyle);
                    feeControlCell.setCellValue(detail.getEnCode() + detail.getFullName());
                    feeControlCell.setCellStyle(cellStyle);
                    expenseItemCell.setCellValue(vo.getEnCode() + vo.getFullName());
                    expenseItemCell.setCellStyle(cellStyle);
                    reportSubjectCell.setCellValue(vo.getEnCode() + vo.getFullName());
                    reportSubjectCell.setCellStyle(cellStyle);
                    cell1.setCellStyle(cellStyle);
                    cell2.setCellStyle(cellStyle);
                    cell3.setCellStyle(cellStyle);
                    ++rowIndex;
                    ++index;
                }
            }
            for (int i = sheet.getLastRowNum(); i >= rowIndex; --i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                sheet.removeRow(row);
            }
            String name = "\u9884\u7b97\u6a21\u7248" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
            String fileName = this.configValueUtil.getTemporaryFilePath() + name;
            FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
            try {
                workbook.write((OutputStream)output);
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                downloadVO.setName(name);
                downloadVO.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
            }
            finally {
                if (Collections.singletonList(output).get(0) != null) {
                    output.close();
                }
            }
        }
        catch (IOException | InvalidFormatException e) {
            e.printStackTrace();
        }
        return downloadVO;
    }

    @Override
    public ActionResult delete(String id) {
        EcsBudgetAccountEntity entity = this.getInfo(id);
        ArrayList<String> needDelIdList = new ArrayList<String>();
        List ids = null;
        if (entity != null) {
            needDelIdList.add(entity.getId());
            List<EcsBudgetAccountEntity> listByParentId = this.getListByParentId(id);
            if (!listByParentId.isEmpty()) {
                List collect;
                ids = collect = listByParentId.stream().map(EcsBudgetAccountEntity::getId).collect(Collectors.toList());
                needDelIdList.addAll(collect);
            }
            this.removeBatchByIds(needDelIdList);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    public void recursionTree(List<EcsBudgetAccountInfoVO> returnList) {
        returnList.stream().forEach(item -> {
            List<EcsBudgetAccountEntity> listChild = this.getListByParentId(item.getId());
            if (ObjectUtil.isEmpty(listChild)) {
                return;
            }
            List listVO = JsonUtil.getJsonToList(listChild, EcsBudgetAccountInfoVO.class);
            item.setChildren(listVO);
            this.recursionTree(listVO);
        });
    }

    public void recursionTree(List<EcsBudgetAccountInfoVO> returnList, String menuId, String type) {
        returnList.stream().forEach(item -> {
            List<EcsBudgetAccountEntity> listChild = this.getListByParentId(item.getId(), menuId);
            if (ObjectUtil.isEmpty(listChild)) {
                return;
            }
            List listVO = JsonUtil.getJsonToList(listChild, EcsBudgetAccountInfoVO.class);
            item.setChildren(listVO);
            this.recursionTree(listVO);
        });
    }

    public void recursionTree(List<EcsBudgetAccountEntity> listByParentId, Map<String, String> typeMap, String key) {
        listByParentId.stream().forEach(item -> {
            String childKey = key + item.getFullName();
            typeMap.put(childKey, item.getId());
            List<EcsBudgetAccountEntity> listChild = this.getListByParentId(item.getId());
            if (ObjectUtil.isEmpty(listChild)) {
                return;
            }
            this.recursionTree(listChild, typeMap, childKey);
        });
    }

    public List<String> recursionTreeId(List<String> returnList) {
        ArrayList<String> returnIds = new ArrayList<String>();
        returnIds.addAll(returnList);
        for (String itemId : returnList) {
            List<EcsBudgetAccountEntity> listChild = this.getListByParentId(itemId);
            if (!ObjectUtil.isEmpty(listChild)) {
                List<String> listVO = JsonUtil.getJsonToList(listChild, EcsBudgetAccountEntity.class).stream().map(itemList -> itemList.getId()).collect(Collectors.toList());
                returnIds.addAll(listVO);
                this.recursionTreeId(listVO);
                continue;
            }
            return returnIds;
        }
        return returnIds;
    }
}

