/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBudgetAdjustDetailEntity;
import com.bringspring.ecs.entity.EcsBudgetAdjustEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountRecordEntity;
import com.bringspring.ecs.enums.AdjustStateEnum;
import com.bringspring.ecs.enums.BudgetRecordOperateTypeEnum;
import com.bringspring.ecs.mapper.EcsBudgetAdjustMapper;
import com.bringspring.ecs.model.ecsbudgetadjust.EcsBudgetAdjustPagination;
import com.bringspring.ecs.service.EcsBudgetAdjustDetailService;
import com.bringspring.ecs.service.EcsBudgetAdjustService;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountRecordService;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsBudgetAdjustServiceImpl
extends ServiceImpl<EcsBudgetAdjustMapper, EcsBudgetAdjustEntity>
implements EcsBudgetAdjustService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsBudgetOrganizeAccountService organizeAccountService;
    @Autowired
    private EcsBudgetOrganizeAccountRecordService accountRecordService;
    @Autowired
    private EcsBudgetAdjustDetailService adjustDetailService;

    @Override
    public List<EcsBudgetAdjustEntity> getList(EcsBudgetAdjustPagination ecsBudgetAdjustPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBudgetAdjustNum = 0;
        QueryWrapper ecsBudgetAdjustQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getYear())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getYear, (Object)ecsBudgetAdjustPagination.getYear());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getApplyTime())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getApplyTime, (Object)ecsBudgetAdjustPagination.getApplyTime());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getOrganizeId())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getOrganizeId, (Object)ecsBudgetAdjustPagination.getOrganizeId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getCode())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getCode, (Object)ecsBudgetAdjustPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getWriteUserId())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().eq(EcsBudgetAdjustEntity::getWriteUserId, (Object)ecsBudgetAdjustPagination.getWriteUserId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getWriteDept())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().eq(EcsBudgetAdjustEntity::getWriteDept, (Object)ecsBudgetAdjustPagination.getWriteDept());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getApplyUserId())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().eq(EcsBudgetAdjustEntity::getApplyUserId, (Object)ecsBudgetAdjustPagination.getApplyUserId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getApplyDept())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().eq(EcsBudgetAdjustEntity::getApplyDept, (Object)ecsBudgetAdjustPagination.getApplyDept());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getDescription())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getDescription, (Object)ecsBudgetAdjustPagination.getDescription());
        }
        if (AllIdList.size() > 0) {
            ecsBudgetAdjustQueryWrapper.lambda().in(EcsBudgetAdjustEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBudgetAdjustPagination.getSidx())) {
            ecsBudgetAdjustQueryWrapper.lambda().orderByDesc(EcsBudgetAdjustEntity::getId);
        } else {
            try {
                String sidx = ecsBudgetAdjustPagination.getSidx();
                EcsBudgetAdjustEntity ecsBudgetAdjustEntity = new EcsBudgetAdjustEntity();
                Field declaredField = ecsBudgetAdjustEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBudgetAdjustQueryWrapper = "asc".equals(ecsBudgetAdjustPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBudgetAdjustQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBudgetAdjustQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ecsBudgetAdjustPagination.getCurrentPage(), ecsBudgetAdjustPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsBudgetAdjustQueryWrapper);
            return ecsBudgetAdjustPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ecsBudgetAdjustPagination.setData(list, list.size());
    }

    @Override
    public List<EcsBudgetAdjustEntity> getTypeList(EcsBudgetAdjustPagination ecsBudgetAdjustPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBudgetAdjustNum = 0;
        QueryWrapper ecsBudgetAdjustQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getYear())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getYear, (Object)ecsBudgetAdjustPagination.getYear());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getApplyTime())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getApplyTime, (Object)ecsBudgetAdjustPagination.getApplyTime());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getOrganizeId())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getOrganizeId, (Object)ecsBudgetAdjustPagination.getOrganizeId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getCode())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getCode, (Object)ecsBudgetAdjustPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getWriteUserId())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().eq(EcsBudgetAdjustEntity::getWriteUserId, (Object)ecsBudgetAdjustPagination.getWriteUserId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getWriteDept())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().eq(EcsBudgetAdjustEntity::getWriteDept, (Object)ecsBudgetAdjustPagination.getWriteDept());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getApplyUserId())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().eq(EcsBudgetAdjustEntity::getApplyUserId, (Object)ecsBudgetAdjustPagination.getApplyUserId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getApplyDept())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().eq(EcsBudgetAdjustEntity::getApplyDept, (Object)ecsBudgetAdjustPagination.getApplyDept());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetAdjustPagination.getDescription())) {
            ++ecsBudgetAdjustNum;
            ecsBudgetAdjustQueryWrapper.lambda().like(EcsBudgetAdjustEntity::getDescription, (Object)ecsBudgetAdjustPagination.getDescription());
        }
        if (AllIdList.size() > 0) {
            ecsBudgetAdjustQueryWrapper.lambda().in(EcsBudgetAdjustEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBudgetAdjustPagination.getSidx())) {
            ecsBudgetAdjustQueryWrapper.lambda().orderByDesc(EcsBudgetAdjustEntity::getId);
        } else {
            try {
                String sidx = ecsBudgetAdjustPagination.getSidx();
                EcsBudgetAdjustEntity ecsBudgetAdjustEntity = new EcsBudgetAdjustEntity();
                Field declaredField = ecsBudgetAdjustEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBudgetAdjustQueryWrapper = "asc".equals(ecsBudgetAdjustPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBudgetAdjustQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBudgetAdjustQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ecsBudgetAdjustPagination.getCurrentPage(), ecsBudgetAdjustPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ecsBudgetAdjustQueryWrapper);
                return ecsBudgetAdjustPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ecsBudgetAdjustPagination.setData(list, list.size());
        }
        return this.list((Wrapper)ecsBudgetAdjustQueryWrapper);
    }

    @Override
    public EcsBudgetAdjustEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBudgetAdjustEntity::getId, (Object)id);
        return (EcsBudgetAdjustEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(EcsBudgetAdjustEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, EcsBudgetAdjustEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        EcsBudgetAdjustEntity adjustEntity = this.getInfo(id);
        if (enableMark == 4) {
            this.processAgreement(adjustEntity, id);
        }
        if (enableMark == 5) {
            this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetAdjustEntity::getState, (Object)AdjustStateEnum.REJECT.getCode())).eq(EcsBudgetAdjustEntity::getId, (Object)id));
        }
        return false;
    }

    private boolean processAgreement(EcsBudgetAdjustEntity adjustEntity, String id) {
        List adjustDetailEntities = this.adjustDetailService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetAdjustDetailEntity::getAdjustId, (Object)id));
        adjustDetailEntities.forEach(adjustDetailEntity -> {
            String orgAccountId = adjustDetailEntity.getOrgAccountId();
            BigDecimal applyBudget = adjustDetailEntity.getApplyBudget();
            String type = adjustDetailEntity.getApplyType();
            EcsBudgetOrganizeAccountEntity organizeAccountEntity = (EcsBudgetOrganizeAccountEntity)this.organizeAccountService.getById((Serializable)((Object)orgAccountId));
            BigDecimal annualBudget = organizeAccountEntity.getAnnualBudget();
            BigDecimal result = BigDecimal.ZERO;
            if (type.equals(BudgetRecordOperateTypeEnum.BUDGET_INCREASE.getCode())) {
                result = organizeAccountEntity.getAnnualBudget().add(applyBudget);
            }
            if (type.equals(BudgetRecordOperateTypeEnum.BUDGET_DECREASE.getCode())) {
                result = organizeAccountEntity.getAnnualBudget().subtract(applyBudget);
            }
            organizeAccountEntity.setAnnualUseBudget(result);
            EcsBudgetOrganizeAccountRecordEntity recordEntity = new EcsBudgetOrganizeAccountRecordEntity();
            recordEntity.setId(RandomUtil.uuId());
            recordEntity.setOrgAccountId(orgAccountId);
            recordEntity.setBeforeBudget(annualBudget);
            recordEntity.setAfterBudget(result);
            recordEntity.setOperateCost(applyBudget);
            recordEntity.setOperateType(type);
            recordEntity.setCreatorUserId(adjustEntity.getCreatorUserId());
            recordEntity.setCreatorTime(new Date());
            this.accountRecordService.save(recordEntity);
            this.organizeAccountService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeAccountEntity::getAnnualBudget, (Object)result)).eq(EcsBudgetOrganizeAccountEntity::getId, (Object)orgAccountId));
        });
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetAdjustEntity::getState, (Object)AdjustStateEnum.COMPLETE.getCode())).eq(EcsBudgetAdjustEntity::getId, (Object)id));
        return true;
    }

    @Override
    public void delete(EcsBudgetAdjustEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

