/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.ecs.constants.GlobalConstants;
import com.bringspring.ecs.entity.EcsBudgetAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetControlModeEntity;
import com.bringspring.ecs.entity.EcsBudgetEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountRecordEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.enums.BudgetRecordOperateTypeEnum;
import com.bringspring.ecs.exception.ExcelValidationException;
import com.bringspring.ecs.mapper.EcsBudgetOrganizeAccountMapper;
import com.bringspring.ecs.mapper.EcsBudgetOrganizeAccountRecordMapper;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.BudgetAccountTotalVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.BudgetOrganizeAccountImportModel;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.BudgetOrganizeAccountImportVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.BudgetQuarterStatisticsVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountCrForm;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountListVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountPagination;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountPaginationExportModel;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountTreeVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountUpForm;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.ImportDataRequest;
import com.bringspring.ecs.service.EcsBudgetAccountService;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountRecordService;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountService;
import com.bringspring.ecs.service.EcsBudgetOrganizeService;
import com.bringspring.ecs.service.EcsBudgetService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsBudgetOrganizeAccountServiceImpl
extends ServiceImpl<EcsBudgetOrganizeAccountMapper, EcsBudgetOrganizeAccountEntity>
implements EcsBudgetOrganizeAccountService {
    private static final Logger log = LoggerFactory.getLogger(EcsBudgetOrganizeAccountServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private EcsBudgetAccountService ecsBudgetAccountService;
    @Autowired
    private EcsBudgetService budgetService;
    @Autowired
    private EcsBudgetOrganizeService ecsBudgetOrganizeService;
    @Autowired
    private EcsBudgetOrganizeAccountRecordService recordService;
    @Autowired
    private EcsBudgetOrganizeAccountRecordService accountRecordService;
    @Autowired
    private EcsBudgetOrganizeAccountRecordMapper organizeAccountRecordMapper;

    @Override
    public List<EcsBudgetOrganizeAccountEntity> getList(EcsBudgetOrganizeAccountPagination ecsBudgetOrganizeAccountPagination) {
        return this.getTypeList(ecsBudgetOrganizeAccountPagination, "0");
    }

    @Override
    public List<EcsBudgetOrganizeAccountEntity> getTypeList(EcsBudgetOrganizeAccountPagination pagination, String dataType) {
        Object object;
        QueryWrapper ecsBudgetOrganizeAccountQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsBudgetOrganizeAccountQueryWrapper, pagination.getMenuId(), "ecs_budget_organize_account"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsBudgetOrganizeAccountEntity>();
            }
            ecsBudgetOrganizeAccountQueryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsBudgetOrganizeAccountQueryWrapper, pagination.getMenuId(), "ecs_budget_organize_account"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsBudgetOrganizeAccountEntity>();
            }
            ecsBudgetOrganizeAccountQueryWrapper = (QueryWrapper)object;
        }
        if (StringUtils.isNotEmpty((String)pagination.getYear())) {
            ecsBudgetOrganizeAccountQueryWrapper.lambda().eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)pagination.getYear());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCostDept())) {
            ArrayList<String> listTreeId = new ArrayList<String>();
            listTreeId.add(pagination.getCostDept());
            listTreeId.addAll(this.ecsBudgetOrganizeService.getListTreeId(pagination.getCostDept(), pagination.getYear()));
            ecsBudgetOrganizeAccountQueryWrapper.lambda().in(EcsBudgetOrganizeAccountEntity::getCostDept, listTreeId);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)ecsBudgetOrganizeAccountQueryWrapper.lambda().eq(StringUtils.isNotEmpty((String)pagination.getEnabledMark()), EcsBudgetOrganizeAccountEntity::getEnabledMark, (Object)pagination.getEnabledMark())).like(StringUtils.isNotEmpty((String)pagination.getOrganizeId()), EcsBudgetOrganizeAccountEntity::getOrganizeId, (Object)pagination.getOrganizeId())).like(StringUtils.isNotEmpty((String)pagination.getAccountId()), EcsBudgetOrganizeAccountEntity::getAccountId, (Object)pagination.getAccountId())).like(StringUtils.isNotEmpty((String)pagination.getProject()), EcsBudgetOrganizeAccountEntity::getProject, (Object)pagination.getProject())).like(StringUtils.isNotEmpty((String)pagination.getWriteProject()), EcsBudgetOrganizeAccountEntity::getWriteProject, (Object)pagination.getWriteProject())).like(StringUtils.isNotEmpty((String)pagination.getAnnualBudget()), EcsBudgetOrganizeAccountEntity::getAnnualBudget, (Object)pagination.getAnnualBudget())).like(StringUtils.isNotEmpty((String)pagination.getAnnualUseBudget()), EcsBudgetOrganizeAccountEntity::getAnnualUseBudget, (Object)pagination.getAnnualUseBudget());
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            ecsBudgetOrganizeAccountQueryWrapper.lambda().orderByAsc(EcsBudgetOrganizeAccountEntity::getId);
        } else {
            try {
                String sidx = pagination.getSidx();
                EcsBudgetOrganizeAccountEntity ecsBudgetOrganizeAccountEntity = new EcsBudgetOrganizeAccountEntity();
                Field declaredField = ecsBudgetOrganizeAccountEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBudgetOrganizeAccountQueryWrapper = "asc".equalsIgnoreCase(pagination.getSort()) ? (QueryWrapper)ecsBudgetOrganizeAccountQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBudgetOrganizeAccountQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsBudgetOrganizeAccountQueryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)ecsBudgetOrganizeAccountQueryWrapper);
    }

    @Override
    public EcsBudgetOrganizeAccountEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBudgetOrganizeAccountEntity::getId, (Object)id);
        return (EcsBudgetOrganizeAccountEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(EcsBudgetOrganizeAccountCrForm ecsBudgetOrganizeAccountCrForm) {
        String mainId = RandomUtil.uuId();
        EcsBudgetOrganizeAccountEntity entity = (EcsBudgetOrganizeAccountEntity)JsonUtil.getJsonToBean((Object)ecsBudgetOrganizeAccountCrForm, EcsBudgetOrganizeAccountEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public void update(String id, EcsBudgetOrganizeAccountUpForm ecsBudgetOrganizeAccountUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsBudgetOrganizeAccountEntity entity = this.getInfo(id);
        if (entity != null) {
            EcsBudgetOrganizeAccountEntity subentity = (EcsBudgetOrganizeAccountEntity)JsonUtil.getJsonToBean((Object)ecsBudgetOrganizeAccountUpForm, EcsBudgetOrganizeAccountEntity.class);
            BigDecimal oldBudget = entity.getAnnualBudget();
            BigDecimal newBudget = subentity.getAnnualBudget();
            BigDecimal subtract = newBudget.subtract(oldBudget);
            String operateType = "";
            if (subtract.compareTo(BigDecimal.ZERO) != 0) {
                if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                    operateType = BudgetRecordOperateTypeEnum.BUDGET_INCREASE.getCode();
                } else if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                    operateType = BudgetRecordOperateTypeEnum.BUDGET_DECREASE.getCode();
                }
                EcsBudgetOrganizeAccountRecordEntity recordEntity = new EcsBudgetOrganizeAccountRecordEntity();
                recordEntity.setId(RandomUtil.uuId());
                recordEntity.setOrgAccountId(id);
                recordEntity.setBeforeBudget(oldBudget);
                recordEntity.setAfterBudget(newBudget);
                recordEntity.setOperateCost(subtract.abs());
                recordEntity.setOperateType(operateType);
                recordEntity.setCreatorUserId(userInfo.getUserId());
                recordEntity.setCreatorTime(new Date());
                this.accountRecordService.save(recordEntity);
            }
            this.updateById(subentity);
        }
    }

    @Override
    public DownloadVO getTemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u9884\u7b97\u6a21\u7248.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u9884\u7b97\u6a21\u7248.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return vo;
    }

    @Override
    public ActionResult importOrganizeAccountPreview(String fileName) {
        ArrayList<BudgetOrganizeAccountImportModel> assetList = new ArrayList<BudgetOrganizeAccountImportModel>();
        try {
            String filePath = this.configValueUtil.getTemporaryFilePath();
            File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
            XSSFWorkbook workbook = new XSSFWorkbook(temporary);
            Sheet sheet = workbook.getSheetAt(0);
            this.unmergeCells(sheet);
            int startRow = 4;
            Map<String, Integer> columnIndexMap = this.getColumnIndexMap(sheet);
            for (int rowIndex = startRow; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                Field[] fields;
                Row row = sheet.getRow(rowIndex);
                if (row == null) continue;
                BudgetOrganizeAccountImportModel model = new BudgetOrganizeAccountImportModel();
                for (Field field : fields = BudgetOrganizeAccountImportModel.class.getDeclaredFields()) {
                    Object value;
                    Excel excelAnnotation;
                    String columnName;
                    Integer columnIndex;
                    Cell cell;
                    if (!field.isAnnotationPresent(Excel.class) || (cell = row.getCell((columnIndex = columnIndexMap.get(columnName = (excelAnnotation = field.getAnnotation(Excel.class)).name())).intValue())) == null) continue;
                    switch (field.getType().getSimpleName()) {
                        case "String": {
                            value = cell.toString();
                            break;
                        }
                        case "BigDecimal": {
                            if (cell.getCellType() == CellType.NUMERIC) {
                                value = BigDecimal.valueOf(cell.getNumericCellValue());
                                break;
                            }
                            value = null;
                            break;
                        }
                        default: {
                            value = null;
                        }
                    }
                    field.setAccessible(true);
                    field.set((Object)model, value);
                }
                assetList.add(model);
            }
            workbook.close();
        }
        catch (IOException | IllegalAccessException | InvalidFormatException e) {
            e.printStackTrace();
        }
        Map<String, Object> map = this.importPreview(assetList);
        return ActionResult.success(map);
    }

    private void unmergeCells(Sheet sheet) {
        int mergedRegionsCount = sheet.getNumMergedRegions();
        for (int i = 0; i < mergedRegionsCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            String value = sheet.getRow(range.getFirstRow()).getCell(range.getFirstColumn()).toString();
            for (int rowIndex = range.getFirstRow(); rowIndex <= range.getLastRow(); ++rowIndex) {
                for (int colIndex = range.getFirstColumn(); colIndex <= range.getLastColumn(); ++colIndex) {
                    Cell cell;
                    Row row = sheet.getRow(rowIndex);
                    if (row == null || (cell = row.getCell(colIndex)) == null || rowIndex == range.getFirstRow() && colIndex == range.getFirstColumn()) continue;
                    cell.setCellValue(value);
                }
            }
        }
    }

    private Map<String, Integer> getColumnIndexMap(Sheet sheet) {
        HashMap<String, Integer> columnIndexMap = new HashMap<String, Integer>();
        Row headerRow = sheet.getRow(3);
        if (headerRow != null) {
            for (int colIndex = 0; colIndex <= headerRow.getLastCellNum(); ++colIndex) {
                Cell cell = headerRow.getCell(colIndex);
                if (cell == null) continue;
                String columnName = cell.toString();
                columnIndexMap.put(columnName, colIndex);
            }
        }
        return columnIndexMap;
    }

    @Override
    public ActionResult importOrganizeAccountData(ImportDataRequest data, String menuId) {
        boolean isUsed;
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25");
        }
        BudgetOrganizeAccountImportModel budgetOrganizeAccountImportModel = data.getData();
        List dataList = JsonUtil.getJsonToList(budgetOrganizeAccountImportModel.getList(), BudgetOrganizeAccountImportModel.class);
        List budgetList = this.budgetService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetEntity::getCompanyId, (Object)data.getOrganizeId())).eq(EcsBudgetEntity::getYear, (Object)data.getYear()));
        EcsBudgetEntity latestRecord = budgetList.stream().findFirst().orElse(null);
        if (ObjectUtil.isNotEmpty((Object)latestRecord) && latestRecord.getCloseMark() == GlobalConstants.CLOSE_FLAG_NO) {
            return ActionResult.fail((String)"\u5bfc\u5165\u5931\u8d25: \u8be5\u5e74\u5ea6\u9884\u7b97\u586b\u62a5\u5df2\u622a\u6b62!");
        }
        List existList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeAccountEntity::getOrganizeId, (Object)data.getOrganizeId())).eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)data.getYear())).eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)data.getDepartmentId()));
        if (CollectionUtil.isNotEmpty((Collection)existList) && (isUsed = existList.stream().anyMatch(entity -> entity.getAnnualUseBudget().compareTo(BigDecimal.ZERO) != 0 || entity.getPendingBudget().compareTo(BigDecimal.ZERO) != 0))) {
            return ActionResult.fail((String)"\u5bfc\u5165\u5931\u8d25: \u8be5\u5e74\u5ea6\u9884\u7b97\u5df2\u4f7f\u7528!");
        }
        try {
            BudgetOrganizeAccountImportVO result = this.importData(dataList, menuId, data.getFiles(), data.getOrganizeId(), data.getDepartmentId(), data.getYear());
            return ActionResult.success((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public BudgetOrganizeAccountImportVO importData(List<BudgetOrganizeAccountImportModel> dt, String menuId, String files, String organizeId, String departmentId, String year) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        List accountEntities = this.ecsBudgetAccountService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetAccountEntity::getYear, (Object)year));
        List filteredEntities = accountEntities.stream().filter(entity -> !"-1".equals(entity.getParentId())).collect(Collectors.toList());
        Map<String, String> accountMap = accountEntities.stream().collect(Collectors.toMap(entity -> entity.getEnCode() + entity.getFullName(), EcsBudgetAccountEntity::getId, (existingValue, newValue) -> existingValue));
        Map<String, String> accountProjectMap = filteredEntities.stream().collect(Collectors.toMap(entity -> entity.getEnCode() + entity.getFullName(), EcsBudgetAccountEntity::getId, (existingValue, newValue) -> existingValue));
        int sum = 0;
        int num = 0;
        ArrayList<BudgetOrganizeAccountImportModel> errList = new ArrayList<BudgetOrganizeAccountImportModel>();
        ArrayList<EcsBudgetOrganizeAccountEntity> organizeAccountEntityList = new ArrayList<EcsBudgetOrganizeAccountEntity>();
        for (BudgetOrganizeAccountImportModel model : dt) {
            try {
                this.validateImportData(model, accountMap, accountProjectMap);
                EcsBudgetOrganizeAccountEntity entity2 = (EcsBudgetOrganizeAccountEntity)JsonUtil.getJsonToBean((Object)((Object)model), EcsBudgetOrganizeAccountEntity.class);
                if (entity2.getAnnualBudget() == null) {
                    entity2.setAnnualUseBudget(BigDecimal.ZERO);
                    entity2.setInitBudget(BigDecimal.ZERO);
                    entity2.setAnnualBudget(BigDecimal.ZERO);
                }
                entity2.setId(RandomUtil.uuId());
                entity2.setEnabledMark(1);
                entity2.setOrganizeId(organizeId);
                entity2.setYear(year);
                entity2.setInitBudget(entity2.getAnnualBudget());
                entity2.setCostDept(departmentId);
                entity2.setCreatorUserId(this.userProvider.get().getUserId());
                entity2.setCreatorTime(new Date());
                organizeAccountEntityList.add(entity2);
                ++sum;
            }
            catch (ExcelValidationException e) {
                log.error("\u5bfc\u5165\u7b2c" + (num + 1) + "\u6761\u6570\u636e\u5931\u8d25");
                int index = 0;
                int size = e.getErrorMessages().size();
                StringBuilder em = new StringBuilder();
                for (Map.Entry<String, String> error : e.getErrorMessages().entrySet()) {
                    em.append(error.getKey()).append(" : ").append(error.getValue());
                    if (index != size - 1) {
                        em.append("\n");
                    }
                    ++index;
                }
                model.setErrorMessage(em.toString());
                log.error(model.getErrorMessage());
                errList.add(model);
                ++num;
            }
            catch (Exception e) {
                log.error("\u5bfc\u5165\u7b2c" + (num + 1) + "\u6761\u6570\u636e\u5931\u8d25");
                model.setErrorMessage(e.toString());
                errList.add(model);
                ++num;
            }
        }
        if (CollectionUtil.isNotEmpty(organizeAccountEntityList)) {
            this.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)departmentId)).eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)year));
            this.saveBatch(organizeAccountEntityList);
            this.ecsBudgetOrganizeService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeEntity::getFiles, (Object)files)).eq(EcsBudgetOrganizeEntity::getId, (Object)departmentId)).eq(EcsBudgetOrganizeEntity::getYear, (Object)year));
        }
        BudgetOrganizeAccountImportVO vo = new BudgetOrganizeAccountImportVO();
        vo.setSnum(sum);
        vo.setFnum(num);
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            List jsonToList = JsonUtil.getJsonToList(errList, BudgetOrganizeAccountImportModel.class);
            vo.setFailResult(jsonToList);
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public Map<String, Object> importPreview(List<BudgetOrganizeAccountImportModel> personList) {
        ArrayList dataRow = new ArrayList();
        if (personList != null) {
            for (int i = 0; i < personList.size(); ++i) {
                HashMap<String, Object> dataRowMap = new HashMap<String, Object>();
                BudgetOrganizeAccountImportModel model = personList.get(i);
                dataRowMap.put("accountId", model.getAccountId());
                dataRowMap.put("project", model.getProject());
                dataRowMap.put("writeProject", model.getWriteProject());
                dataRowMap.put("annualBudget", model.getAnnualBudget());
                dataRow.add(dataRowMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        return map;
    }

    @Override
    public DownloadVO exportOrganizeAccount(EcsBudgetOrganizeAccountPaginationExportModel exportModel) {
        EcsBudgetOrganizeAccountPagination ecsBudgetOrganizeAccountPagination = (EcsBudgetOrganizeAccountPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)exportModel), EcsBudgetOrganizeAccountPagination.class));
        List<EcsBudgetOrganizeAccountEntity> list = this.getTypeList(ecsBudgetOrganizeAccountPagination, exportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, EcsBudgetOrganizeAccountListVO.class);
        List budgetAccountEntityList = this.ecsBudgetAccountService.list();
        List organizeEntities = this.ecsBudgetOrganizeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeEntity::getYear, (Object)ecsBudgetOrganizeAccountPagination.getYear())).eq(EcsBudgetOrganizeEntity::getOrganizeId, (Object)ecsBudgetOrganizeAccountPagination.getOrganizeId()));
        Map<String, String> deptMap = organizeEntities.stream().collect(Collectors.toMap(EcsBudgetOrganizeEntity::getId, EcsBudgetOrganizeEntity::getFullName));
        Map<String, String> accountMap = budgetAccountEntityList.stream().collect(Collectors.toMap(EcsBudgetAccountEntity::getId, EcsBudgetAccountEntity::getFullName));
        for (EcsBudgetOrganizeAccountListVO vo : listVO) {
            vo.setOrganizeId(deptMap.get(vo.getOrganizeId()));
            vo.setCostDept(deptMap.get(vo.getCostDept()));
            vo.setAccountId(accountMap.get(vo.getAccountId()));
            vo.setProject(accountMap.get(vo.getProject()));
            vo.setEnabledMark("1".equals(vo.getEnabledMark()) ? "\u6b63\u5e38" : "\u505c\u7528");
            if (vo.getAnnualBudget() == null || vo.getAnnualUseBudget() == null || vo.getPendingBudget() == null) continue;
            BigDecimal annualBudget = new BigDecimal(vo.getAnnualBudget());
            BigDecimal usedBudget = new BigDecimal(vo.getAnnualUseBudget());
            BigDecimal pendingBudget = new BigDecimal(vo.getPendingBudget());
            BigDecimal availableBudget = annualBudget.subtract(usedBudget).subtract(pendingBudget);
            vo.setAvailableBudget(availableBudget.toString());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "organizeId": {
                        entitys.add(new ExcelExportEntity("\u7ec4\u7ec7", (Object)"organizeId"));
                        continue block34;
                    }
                    case "year": {
                        entitys.add(new ExcelExportEntity("\u5e74\u5ea6", (Object)"year"));
                        continue block34;
                    }
                    case "accountId": {
                        entitys.add(new ExcelExportEntity("\u9884\u7b97\u79d1\u76ee", (Object)"accountId"));
                        continue block34;
                    }
                    case "project": {
                        entitys.add(new ExcelExportEntity("\u8d39\u7528\u9879\u76ee", (Object)"project"));
                        continue block34;
                    }
                    case "writeProject": {
                        entitys.add(new ExcelExportEntity("\u5bf9\u5e94\u586b\u62a5\u79d1\u76ee", (Object)"writeProject"));
                        continue block34;
                    }
                    case "costDept": {
                        entitys.add(new ExcelExportEntity("\u8d39\u7528\u6240\u5c5e\u90e8\u95e8", (Object)"costDept"));
                        continue block34;
                    }
                    case "annualBudget": {
                        entitys.add(new ExcelExportEntity("\u5168\u5e74\u9884\u7b97\u8d39\u7528\u91d1\u989d", (Object)"annualBudget"));
                        continue block34;
                    }
                    case "annualUseBudget": {
                        entitys.add(new ExcelExportEntity("\u5168\u5e74\u9884\u7b97\u4f7f\u7528\u91d1\u989d", (Object)"annualUseBudget"));
                        continue block34;
                    }
                    case "pendingBudget": {
                        entitys.add(new ExcelExportEntity("\u5ba1\u6279\u4e2d\u91d1\u989d", (Object)"pendingBudget"));
                        continue block34;
                    }
                    case "availableBudget": {
                        entitys.add(new ExcelExportEntity("\u53ef\u7528\u9884\u7b97", (Object)"availableBudget"));
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"enabledMark"));
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                if (workbook.getNumberOfSheets() > 0) {
                    Sheet sheet = workbook.getSheetAt(0);
                    int lastRowNum = sheet.getLastRowNum();
                    Row noteRow = sheet.createRow(lastRowNum + 2);
                    Cell noteCell = noteRow.createCell(0);
                    noteCell.setCellValue("\u8bf4\u660e\uff1a\u63d0\u4ea4\u62a5\u9500\u5355\u65f6\uff0c\u53ef\u7528\u9884\u7b97(\u5168\u5e74\u9884\u7b97-\u5df2\u4f7f\u7528-\u5ba1\u6279\u4e2d\u9884\u7b97)\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u63d0\u4ea4\u7684\u62a5\u9500\u91d1\u989d\uff0c\u5426\u5219\u65e0\u6cd5\u63d0\u4ea4\u62a5\u9500\u5355\u3002");
                    CellStyle noteStyle = workbook.createCellStyle();
                    Font font = workbook.createFont();
                    font.setBold(true);
                    font.setColor(IndexedColors.RED.getIndex());
                    noteStyle.setFont(font);
                    noteCell.setCellStyle(noteStyle);
                    sheet.addMergedRegion(new CellRangeAddress(lastRowNum + 2, lastRowNum + 2, 0, entitys.size() - 1));
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    public void validateImportData(BudgetOrganizeAccountImportModel model, Map<String, String> accountMap, Map<String, String> accountProjectMap) {
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        String accountId = model.getAccountId();
        if (StringUtils.isNotEmpty((String)accountId)) {
            if (accountMap.containsKey(accountId)) {
                model.setAccountId(accountMap.get(accountId));
            } else {
                errorMessages.put("\u9884\u7b97\u79d1\u76ee", "\u4e3a\u7a7a\u6216\u914d\u7f6e\u4e0d\u5b58\u5728" + accountId);
            }
        } else {
            errorMessages.put("\u9884\u7b97\u79d1\u76ee", "isNull");
        }
        String project = model.getProject();
        if (StringUtils.isNotEmpty((String)project)) {
            if (accountProjectMap.containsKey(project)) {
                model.setProject(accountProjectMap.get(project));
            } else {
                errorMessages.put("\u8d39\u7528\u9879\u76ee", "\u4e3a\u7a7a\u6216\u914d\u7f6e\u4e0d\u5b58\u5728" + project);
            }
        } else {
            errorMessages.put("\u8d39\u7528\u9879\u76ee", "isNull");
        }
        if (!errorMessages.isEmpty()) {
            throw new ExcelValidationException(errorMessages);
        }
    }

    @Override
    public void delete(EcsBudgetOrganizeAccountEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public EcsBudgetOrganizeAccountEntity getDepartmentBudge(String departmentId, String accountCode) {
        int currentYear = DateUtil.year((Date)new Date());
        LambdaQueryWrapper accountQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetAccountEntity::getEnCode, (Object)accountCode)).eq(EcsBudgetAccountEntity::getYear, (Object)currentYear);
        EcsBudgetAccountEntity ecsBudgetAccountEntity = (EcsBudgetAccountEntity)this.ecsBudgetAccountService.getOne((Wrapper)accountQuery, false);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)departmentId)).eq(EcsBudgetOrganizeAccountEntity::getProject, (Object)ecsBudgetAccountEntity.getId())).eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)currentYear)).eq(EcsBudgetOrganizeAccountEntity::getEnabledMark, (Object)1);
        return (EcsBudgetOrganizeAccountEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public Boolean isBudgetSufficient(EcsBudgetOrganizeAccountEntity departmentBudge, BigDecimal reimbAmount) {
        if (reimbAmount == null) {
            return false;
        }
        if (departmentBudge == null || departmentBudge.getAnnualBudget() == null) {
            return false;
        }
        BigDecimal residueBudget = departmentBudge.getAnnualBudget().subtract(departmentBudge.getAnnualUseBudget().subtract(departmentBudge.getPendingBudget()));
        return residueBudget.compareTo(reimbAmount) >= 0;
    }

    @Override
    @DSTransactional
    public void budgetApproval(EcsRecordsEntity entity, EcsBudgetOrganizeAccountEntity departmentBudge, BigDecimal reimbAmount, @NotNull BudgetRecordOperateTypeEnum operateType) {
        BigDecimal newPendingBudget = BigDecimal.ZERO;
        BigDecimal newUseBudget = departmentBudge.getAnnualUseBudget();
        switch (operateType) {
            case REIMBURSEMENT_SUBMIT: {
                newPendingBudget = departmentBudge.getPendingBudget().add(reimbAmount);
                break;
            }
            case REIMBURSEMENT_CANCEL: {
                newPendingBudget = departmentBudge.getPendingBudget().subtract(reimbAmount);
                break;
            }
            case REIMBURSEMENT_PASS: {
                newPendingBudget = departmentBudge.getPendingBudget().subtract(reimbAmount);
                newUseBudget = departmentBudge.getAnnualUseBudget().add(reimbAmount);
                break;
            }
            case REIMBURSEMENT_CHANGE: {
                newPendingBudget = departmentBudge.getPendingBudget().add(reimbAmount);
            }
        }
        EcsBudgetOrganizeAccountRecordEntity recordEntity = new EcsBudgetOrganizeAccountRecordEntity();
        recordEntity.setId(RandomUtil.uuId());
        recordEntity.setRecordId(entity.getId());
        recordEntity.setRecordNumber(entity.getOrderNumber());
        recordEntity.setOrgAccountId(departmentBudge.getId());
        recordEntity.setBeforeBudget(departmentBudge.getPendingBudget());
        recordEntity.setAfterBudget(newPendingBudget);
        recordEntity.setOperateCost(reimbAmount);
        recordEntity.setOperateType(operateType.getCode());
        this.recordService.save(recordEntity);
        departmentBudge.setAnnualUseBudget(newUseBudget);
        departmentBudge.setPendingBudget(newPendingBudget);
        this.updateById(departmentBudge);
    }

    @Override
    public void stopBudgetAccount(String year, String costDept) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeAccountEntity::getEnabledMark, (Object)0)).eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)costDept)).eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)year));
    }

    @Override
    public List<EcsBudgetOrganizeAccountTreeVO> getOrganizeAccountList(String year, String costDept) {
        List budgetAccountEntityList = this.ecsBudgetAccountService.list();
        Map<String, String> accountMap = budgetAccountEntityList.stream().collect(Collectors.toMap(EcsBudgetAccountEntity::getId, EcsBudgetAccountEntity::getFullName));
        Map<String, String> accountCodeMap = budgetAccountEntityList.stream().collect(Collectors.toMap(EcsBudgetAccountEntity::getId, EcsBudgetAccountEntity::getEnCode));
        List accountEntities = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)year)).eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)costDept)).eq(EcsBudgetOrganizeAccountEntity::getEnabledMark, (Object)1)).orderByAsc(EcsBudgetOrganizeAccountEntity::getId));
        accountEntities.forEach(o -> {
            o.setAccountName((String)accountMap.get(o.getAccountId()));
            o.setAccountCode((String)accountCodeMap.get(o.getAccountId()));
            o.setProjectName((String)accountMap.get(o.getProject()));
            o.setProjectCode((String)accountCodeMap.get(o.getProject()));
        });
        return EcsBudgetOrganizeAccountServiceImpl.buildTree(accountEntities);
    }

    public static List<EcsBudgetOrganizeAccountTreeVO> buildTree(List<EcsBudgetOrganizeAccountEntity> items) {
        HashMap<String, EcsBudgetOrganizeAccountTreeVO> accountMap = new HashMap<String, EcsBudgetOrganizeAccountTreeVO>();
        HashMap<String, List> groupedItems = new HashMap<String, List>();
        for (EcsBudgetOrganizeAccountEntity item : items) {
            groupedItems.computeIfAbsent(item.getAccountId(), k -> new ArrayList()).add(item);
        }
        for (String accountId : groupedItems.keySet()) {
            List groupedEntities = (List)groupedItems.get(accountId);
            if (groupedEntities.isEmpty()) continue;
            EcsBudgetOrganizeAccountTreeVO treeNode = new EcsBudgetOrganizeAccountTreeVO();
            EcsBudgetOrganizeAccountEntity organizeAccountEntity = (EcsBudgetOrganizeAccountEntity)groupedEntities.get(0);
            treeNode.setId(organizeAccountEntity.getId());
            treeNode.setAccountId(organizeAccountEntity.getAccountId());
            treeNode.setAccountCode(organizeAccountEntity.getAccountCode());
            treeNode.setAccountName(organizeAccountEntity.getAccountCode() + organizeAccountEntity.getAccountName());
            for (EcsBudgetOrganizeAccountEntity entity : groupedEntities) {
                if (entity.getProject().isEmpty()) continue;
                EcsBudgetOrganizeAccountTreeVO childNode = new EcsBudgetOrganizeAccountTreeVO();
                childNode.setId(entity.getId());
                childNode.setAccountId(entity.getProject());
                childNode.setAccountName(entity.getProjectCode() + entity.getProjectName());
                childNode.setAccountCode(entity.getProjectCode());
                List<EcsBudgetOrganizeAccountTreeVO> children = treeNode.getChildren();
                children.add(childNode);
            }
            accountMap.put(accountId, treeNode);
        }
        ArrayList<EcsBudgetOrganizeAccountTreeVO> treeVOS = new ArrayList<EcsBudgetOrganizeAccountTreeVO>(accountMap.values());
        treeVOS.sort(Comparator.comparing(EcsBudgetOrganizeAccountTreeVO::getId));
        return treeVOS;
    }

    @Override
    public BudgetAccountTotalVO getBudgetTotal(EcsBudgetOrganizeAccountEntity entity) {
        EcsBudgetOrganizeAccountPagination pagination = new EcsBudgetOrganizeAccountPagination();
        pagination.setOrganizeId(entity.getOrganizeId());
        pagination.setYear(entity.getYear());
        pagination.setAccountId(entity.getAccountId());
        pagination.setProject(entity.getProject());
        pagination.setCostDept(entity.getCostDept());
        pagination.setMenuId(entity.getMenuId());
        List<EcsBudgetOrganizeAccountEntity> list = this.getTypeList(pagination, "1");
        BudgetAccountTotalVO totalVO = EcsBudgetOrganizeAccountServiceImpl.calculateBudgetTotals(list);
        return totalVO;
    }

    public static BudgetAccountTotalVO calculateBudgetTotals(List<EcsBudgetOrganizeAccountEntity> budgetList) {
        BigDecimal initBudgetTotal = budgetList.stream().map(b -> b.getInitBudget() != null ? b.getInitBudget() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal annualBudgetTotal = budgetList.stream().map(b -> b.getAnnualBudget() != null ? b.getAnnualBudget() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal annualUseBudgetTotal = budgetList.stream().map(b -> b.getAnnualUseBudget() != null ? b.getAnnualUseBudget() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal pendingBudgetTotal = budgetList.stream().map(b -> b.getPendingBudget() != null ? b.getPendingBudget() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal netAnnualUseBudgetTotal = budgetList.stream().map(b -> {
            BigDecimal annualBudg = b.getAnnualBudget() != null ? b.getAnnualBudget() : BigDecimal.ZERO;
            BigDecimal annualUseBudg = b.getAnnualUseBudget() != null ? b.getAnnualUseBudget() : BigDecimal.ZERO;
            BigDecimal pendBudg = b.getPendingBudget() != null ? b.getPendingBudget() : BigDecimal.ZERO;
            return annualBudg.subtract(annualUseBudg).subtract(pendBudg);
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        BudgetAccountTotalVO totalVO = new BudgetAccountTotalVO();
        totalVO.setInitBudgetTotal(initBudgetTotal.setScale(2, RoundingMode.HALF_UP));
        totalVO.setAnnualBudgetTotal(annualBudgetTotal.setScale(2, RoundingMode.HALF_UP));
        totalVO.setNetAnnualUseBudgetTotal(netAnnualUseBudgetTotal.setScale(2, RoundingMode.HALF_UP));
        totalVO.setAnnualUseBudgetTotal(annualUseBudgetTotal.setScale(2, RoundingMode.HALF_UP));
        totalVO.setPendingBudgetTotal(pendingBudgetTotal.setScale(2, RoundingMode.HALF_UP));
        return totalVO;
    }

    @Override
    public List<BudgetQuarterStatisticsVO> getQuarterStatistics(List<EcsBudgetControlModeEntity> modeEntities, EcsBudgetOrganizeAccountListVO vo) {
        BigDecimal totalAnnualBudget;
        String annualBudget = vo.getAnnualBudget();
        String orgAccountId = vo.getId();
        try {
            totalAnnualBudget = new BigDecimal(annualBudget);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Annual budget is not a valid number", e);
        }
        ArrayList<BudgetQuarterStatisticsVO> quarterStatisticsVOList = new ArrayList<BudgetQuarterStatisticsVO>();
        modeEntities.forEach(entity -> {
            BudgetQuarterStatisticsVO quarterStatisticsVO = this.createQuarterStatistics((EcsBudgetControlModeEntity)entity, totalAnnualBudget, orgAccountId);
            quarterStatisticsVOList.add(quarterStatisticsVO);
        });
        return quarterStatisticsVOList;
    }

    private BudgetQuarterStatisticsVO createQuarterStatistics(EcsBudgetControlModeEntity entity, BigDecimal totalAnnualBudget, String orgAccountId) {
        BudgetQuarterStatisticsVO quarterStatisticsVO = new BudgetQuarterStatisticsVO();
        BigDecimal ratePercentage = new BigDecimal(entity.getRate()).divide(new BigDecimal(100));
        BigDecimal budgetForQuarter = totalAnnualBudget.multiply(ratePercentage);
        BigDecimal reimburseByQuarter = this.organizeAccountRecordMapper.getReimburseByQuarter(orgAccountId, entity.getBeginDate(), entity.getEndDate());
        quarterStatisticsVO.setQuarter(entity.getName());
        quarterStatisticsVO.setBudget(budgetForQuarter);
        quarterStatisticsVO.setUseBudget(reimburseByQuarter);
        if (budgetForQuarter.compareTo(reimburseByQuarter) < 0) {
            quarterStatisticsVO.setIsExceed("\u662f");
        } else {
            quarterStatisticsVO.setIsExceed("\u5426");
        }
        return quarterStatisticsVO;
    }
}

