/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.mapper.EcsCompanyMapper;
import com.bringspring.ecs.mapper.EcsRecordsMapper;
import com.bringspring.ecs.model.ecscompany.EcsCompanyCrForm;
import com.bringspring.ecs.model.ecscompany.EcsCompanyListVO;
import com.bringspring.ecs.model.ecscompany.EcsCompanyPagination;
import com.bringspring.ecs.model.ecscompany.EcsCompanyUpForm;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsCompanyServiceImpl
extends ServiceImpl<EcsCompanyMapper, EcsCompanyEntity>
implements EcsCompanyService {
    private static final Logger log = LoggerFactory.getLogger(EcsCompanyServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsRecordsMapper ecsRecordsMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserRelationService userRelationService;

    @Override
    public List<EcsCompanyEntity> getList(EcsCompanyPagination ecsCompanyPagination) {
        return this.getTypeList(ecsCompanyPagination, ecsCompanyPagination.getListQuery());
    }

    @Override
    public List<EcsCompanyEntity> getTypeList(EcsCompanyPagination ecsCompanyPagination, String dataType) {
        Object object;
        QueryWrapper ecsCompanyQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && dataType.equals("0") && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsCompanyQueryWrapper, ecsCompanyPagination.getMenuId(), "ecs_company"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsCompanyEntity>();
            }
            ecsCompanyQueryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && dataType.equals("0") && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsCompanyQueryWrapper, ecsCompanyPagination.getMenuId(), "ecs_company"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsCompanyEntity>();
            }
            ecsCompanyQueryWrapper = (QueryWrapper)object;
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)ecsCompanyQueryWrapper.lambda().eq(StringUtils.isNotEmpty((String)ecsCompanyPagination.getParentId()), EcsCompanyEntity::getParentId, (Object)ecsCompanyPagination.getParentId())).like(StringUtils.isNotEmpty((String)ecsCompanyPagination.getName()), EcsCompanyEntity::getName, (Object)ecsCompanyPagination.getName())).like(StringUtils.isNotEmpty((String)ecsCompanyPagination.getTaxId()), EcsCompanyEntity::getTaxId, (Object)ecsCompanyPagination.getTaxId())).like(StringUtils.isNotEmpty((String)ecsCompanyPagination.getCode()), EcsCompanyEntity::getCode, (Object)ecsCompanyPagination.getCode());
        if (StringUtils.isEmpty((String)ecsCompanyPagination.getSidx())) {
            ecsCompanyQueryWrapper.lambda().orderByDesc(EcsCompanyEntity::getId);
        } else {
            try {
                String sidx = ecsCompanyPagination.getSidx();
                EcsCompanyEntity ecsCompanyEntity = new EcsCompanyEntity();
                Field declaredField = ecsCompanyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsCompanyQueryWrapper = "asc".equalsIgnoreCase(ecsCompanyPagination.getSort()) ? (QueryWrapper)ecsCompanyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsCompanyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(ecsCompanyPagination.getCurrentPage(), ecsCompanyPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsCompanyQueryWrapper);
            return ecsCompanyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        List list = this.list((Wrapper)ecsCompanyQueryWrapper);
        return list;
    }

    @Override
    public List<EcsCompanyListVO> getCompanyCommonList(EcsCompanyPagination pagination) {
        if (StringUtils.isNotBlank((CharSequence)pagination.getUserId())) {
            UserInfo userInfo = this.userProvider.get(pagination.getUserId(), null);
            pagination.setCompanyId(userInfo.getOrganizeId());
            UserEntity userEntity = (UserEntity)this.userService.getById((Serializable)((Object)pagination.getUserId()));
            String organizeId = userEntity.getOrganizeId();
            OrganizeEntity organizeEntity = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)organizeId));
            pagination.setCompanyId(organizeEntity.getOrganizeId());
            String organizeIdTree = organizeEntity.getOrganizeIdTree();
            String[] jsonToList = organizeIdTree.split(",");
            StringBuilder deptId = new StringBuilder("[");
            for (String s : jsonToList) {
                deptId.append("\"").append(s).append("\"").append(",");
            }
            deptId.deleteCharAt(deptId.length() - 1);
            deptId.append("]");
            pagination.setUserDeptId(deptId.toString());
        }
        return ((EcsCompanyMapper)this.baseMapper).getCompanyCommonList(pagination);
    }

    @Override
    public EcsCompanyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsCompanyEntity::getId, (Object)id);
        return (EcsCompanyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public ActionResult create(EcsCompanyCrForm ecsCompanyCrForm) {
        String mainId = RandomUtil.uuId();
        EcsCompanyEntity entity = (EcsCompanyEntity)JsonUtil.getJsonToBean((Object)ecsCompanyCrForm, EcsCompanyEntity.class);
        if (StringUtils.isBlank((CharSequence)ecsCompanyCrForm.getParentId())) {
            entity.setParentId(null);
            entity.setParentName(null);
        }
        entity.setId(mainId);
        ActionResult validationResult = this.checkUniqueFields(entity.getName(), entity.getTaxId(), entity.getEnterpriseAccount());
        if (validationResult.getCode() != 200) {
            return validationResult;
        }
        this.save(entity);
        return ActionResult.success();
    }

    public ActionResult checkUniqueFields(String name, String taxId, String enterpriseAccount) {
        Long nameCount = ((EcsCompanyMapper)this.baseMapper).selectCount((Wrapper)Wrappers.lambdaQuery().eq(EcsCompanyEntity::getName, (Object)name.trim()));
        if (nameCount > 0L) {
            return ActionResult.fail((String)("\u516c\u53f8\u540d\u79f0\u91cd\u590d: " + name));
        }
        Long taxIdCount = ((EcsCompanyMapper)this.baseMapper).selectCount((Wrapper)Wrappers.lambdaQuery().eq(EcsCompanyEntity::getTaxId, (Object)taxId.trim()));
        if (taxIdCount > 0L) {
            return ActionResult.fail((String)("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u91cd\u590d: " + taxId));
        }
        return ActionResult.success((String)"\u65b0\u589e\u6210\u529f");
    }

    @Override
    @DSTransactional
    public ActionResult update(String id, EcsCompanyUpForm ecsCompanyUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsCompanyEntity entity = this.getInfo(id);
        if (entity != null) {
            ActionResult actionResult;
            EcsCompanyEntity subEntity;
            Long aLong = this.ecsRecordsMapper.selectCount((Wrapper)Wrappers.lambdaQuery().eq(EcsRecordsEntity::getReimbCompany, (Object)id));
            if (aLong > 0L && !this.isOnlyVisibilityFieldsChanged(entity, subEntity = (EcsCompanyEntity)JsonUtil.getJsonToBean((Object)ecsCompanyUpForm, EcsCompanyEntity.class))) {
                return ActionResult.fail((String)"\u8be5\u516c\u53f8\u6709\u5173\u8054\u62a5\u9500\u5355,\u4e0d\u5141\u8bb8\u7f16\u8f91\u5176\u4ed6\u5b57\u6bb5!");
            }
            subEntity = (EcsCompanyEntity)JsonUtil.getJsonToBean((Object)ecsCompanyUpForm, EcsCompanyEntity.class);
            if (subEntity.getId().equalsIgnoreCase(subEntity.getParentId())) {
                subEntity.setParentId(null);
                subEntity.setParentName(null);
            }
            if ((actionResult = this.checkUniqueFields(subEntity)).getCode() != 200) {
                return actionResult;
            }
            this.updateById(subEntity);
        }
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    private boolean isOnlyVisibilityFieldsChanged(EcsCompanyEntity oldEntity, EcsCompanyEntity newEntity) {
        return Objects.equals(oldEntity.getName(), newEntity.getName()) && Objects.equals(oldEntity.getTaxId(), newEntity.getTaxId());
    }

    private ActionResult checkUniqueFields(EcsCompanyEntity subEntity) {
        Long nameCount = ((EcsCompanyMapper)this.baseMapper).selectCount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsCompanyEntity::getName, (Object)subEntity.getName().trim())).ne(EcsCompanyEntity::getId, (Object)subEntity.getId()));
        if (nameCount > 0L) {
            return ActionResult.fail((String)("\u516c\u53f8\u540d\u79f0\u91cd\u590d: " + subEntity.getName()));
        }
        Long taxIdCount = ((EcsCompanyMapper)this.baseMapper).selectCount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsCompanyEntity::getTaxId, (Object)subEntity.getTaxId().trim())).ne(EcsCompanyEntity::getId, (Object)subEntity.getId()));
        if (taxIdCount > 0L) {
            return ActionResult.fail((String)("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u91cd\u590d: " + subEntity.getTaxId()));
        }
        return ActionResult.success();
    }

    @Override
    @DSTransactional
    public void delete(EcsCompanyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public String getNameById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return ((EcsCompanyEntity)this.getById((Serializable)((Object)id))).getName();
    }

    @Override
    public List<String> getUserIdsByReimbCompany(String reimbCompanyId, String type) {
        EcsCompanyEntity companyEntity = this.getInfo(reimbCompanyId);
        String roleToUse = "";
        if ("1".equals(type)) {
            roleToUse = companyEntity.getCashierRole();
        } else if ("2".equals(type)) {
            roleToUse = companyEntity.getPaymentRole();
        }
        if (StrUtil.isNotBlank((CharSequence)roleToUse)) {
            List data = this.userRelationService.getListByObjectId(roleToUse);
            return data.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

