/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.mapper.EcsConfigMapper;
import com.bringspring.ecs.model.ecsconfig.EcsConfigCrForm;
import com.bringspring.ecs.model.ecsconfig.EcsConfigPagination;
import com.bringspring.ecs.model.ecsconfig.EcsConfigUpForm;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsConfigServiceImpl
extends ServiceImpl<EcsConfigMapper, EcsConfigEntity>
implements EcsConfigService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<EcsConfigEntity> getByRuleKey(String ruleKey) {
        if (StringUtils.isBlank((CharSequence)ruleKey)) {
            return new ArrayList<EcsConfigEntity>();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsConfigEntity::getRuleKey, (Object)ruleKey);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public EcsConfigEntity getByKeyName(String category, String companyId) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{category, companyId})) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsConfigEntity::getCategory, (Object)category)).eq(EcsConfigEntity::getCompanyId, (Object)companyId);
        EcsConfigEntity one = (EcsConfigEntity)this.getOne((Wrapper)queryWrapper, false);
        if (one == null) {
            queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsConfigEntity::getCategory, (Object)category)).eq(EcsConfigEntity::getCompanyId, (Object)"1");
            one = (EcsConfigEntity)this.getOne((Wrapper)queryWrapper, false);
        }
        return one;
    }

    @Override
    public List<EcsConfigEntity> getList(EcsConfigPagination ecsConfigPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsConfigNum = 0;
        QueryWrapper ecsConfigQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsConfigPagination.getCategory())) {
            ++ecsConfigNum;
            ecsConfigQueryWrapper.lambda().like(EcsConfigEntity::getCategory, (Object)ecsConfigPagination.getCategory());
        }
        if (StringUtils.isNotEmpty((String)ecsConfigPagination.getKeyValue())) {
            ++ecsConfigNum;
            ecsConfigQueryWrapper.lambda().like(EcsConfigEntity::getKeyValue, (Object)ecsConfigPagination.getKeyValue());
        }
        if (StringUtils.isNotEmpty((String)ecsConfigPagination.getKeyName())) {
            ++ecsConfigNum;
            ecsConfigQueryWrapper.lambda().like(EcsConfigEntity::getKeyName, (Object)ecsConfigPagination.getKeyName());
        }
        if (AllIdList.size() > 0) {
            ecsConfigQueryWrapper.lambda().in(EcsConfigEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsConfigPagination.getSidx())) {
            ecsConfigQueryWrapper.lambda().orderByDesc(EcsConfigEntity::getId);
        } else {
            try {
                String sidx = ecsConfigPagination.getSidx();
                EcsConfigEntity ecsConfigEntity = new EcsConfigEntity();
                Field declaredField = ecsConfigEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsConfigQueryWrapper = "asc".equals(ecsConfigPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsConfigQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsConfigQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ecsConfigPagination.getCurrentPage(), ecsConfigPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsConfigQueryWrapper);
            return ecsConfigPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ecsConfigPagination.setData(list, list.size());
    }

    @Override
    public List<EcsConfigEntity> getTypeList(EcsConfigPagination ecsConfigPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsConfigNum = 0;
        QueryWrapper ecsConfigQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsConfigPagination.getCategory())) {
            ++ecsConfigNum;
            ecsConfigQueryWrapper.lambda().like(EcsConfigEntity::getCategory, (Object)ecsConfigPagination.getCategory());
        }
        if (StringUtils.isNotEmpty((String)ecsConfigPagination.getKeyValue())) {
            ++ecsConfigNum;
            ecsConfigQueryWrapper.lambda().like(EcsConfigEntity::getKeyValue, (Object)ecsConfigPagination.getKeyValue());
        }
        if (StringUtils.isNotEmpty((String)ecsConfigPagination.getKeyName())) {
            ++ecsConfigNum;
            ecsConfigQueryWrapper.lambda().like(EcsConfigEntity::getKeyName, (Object)ecsConfigPagination.getKeyName());
        }
        if (AllIdList.size() > 0) {
            ecsConfigQueryWrapper.lambda().in(EcsConfigEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsConfigPagination.getSidx())) {
            ecsConfigQueryWrapper.lambda().orderByDesc(EcsConfigEntity::getId);
        } else {
            try {
                String sidx = ecsConfigPagination.getSidx();
                EcsConfigEntity ecsConfigEntity = new EcsConfigEntity();
                Field declaredField = ecsConfigEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsConfigQueryWrapper = "asc".equals(ecsConfigPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsConfigQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsConfigQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ecsConfigPagination.getCurrentPage(), ecsConfigPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ecsConfigQueryWrapper);
                return ecsConfigPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ecsConfigPagination.setData(list, list.size());
        }
        return this.list((Wrapper)ecsConfigQueryWrapper);
    }

    @Override
    public EcsConfigEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsConfigEntity::getId, (Object)id);
        return (EcsConfigEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(EcsConfigCrForm ecsConfigCrForm) {
        String mainId = RandomUtil.uuId();
        EcsConfigEntity entity = (EcsConfigEntity)JsonUtil.getJsonToBean((Object)ecsConfigCrForm, EcsConfigEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, EcsConfigUpForm ecsConfigUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsConfigEntity entity = this.getInfo(id);
        if (entity != null) {
            EcsConfigEntity subEntity = (EcsConfigEntity)JsonUtil.getJsonToBean((Object)ecsConfigUpForm, EcsConfigEntity.class);
            this.updateById(subEntity);
        }
    }

    @Override
    @DSTransactional
    public void delete(EcsConfigEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

