/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.mapper.EcsExtendMapper;
import com.bringspring.ecs.model.customer.CustomerInfoVO;
import com.bringspring.ecs.model.hrms.archive.HrmsEmployeeArchiveInfoVO;
import com.bringspring.ecs.model.hrms.detailcc.HrmsAttendanceGetapprovaldetailCcPagination;
import com.bringspring.ecs.model.oa.fms.SignApplyPagination;
import com.bringspring.ecs.model.relationcc.EcsRecordsRelationCcInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.service.EcsExtendService;
import com.bringspring.ecs.service.EcsRecordsRelationCcService;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsExtendServiceImpl
implements EcsExtendService {
    private static final Logger log = LoggerFactory.getLogger(EcsExtendServiceImpl.class);
    @Autowired
    private SynThirdInfoService thirdInfoService;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private EcsRecordsRelationCcService recordsRelationCcService;
    @Autowired
    private EcsConfigService configService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsExtendMapper ecsExtendMapper;

    @Override
    public List<EcsRecordsRelationCcInfoVO> getListByUserId(String userId, HrmsAttendanceGetapprovaldetailCcPagination pagination) {
        SynThirdInfoEntity infoBySysObjId = this.thirdInfoService.getInfoBySysObjId("1", "2", pagination.getUserid());
        if (infoBySysObjId == null) {
            return new ArrayList<EcsRecordsRelationCcInfoVO>();
        }
        String thirdObjectId = infoBySysObjId.getThirdObjectId();
        if (StringUtils.isBlank((CharSequence)thirdObjectId)) {
            return new ArrayList<EcsRecordsRelationCcInfoVO>();
        }
        pagination.setUserid(thirdObjectId);
        Long startTime = pagination.getStartTime() != null ? Long.valueOf(pagination.getStartTime().getTime() / 1000L) : null;
        Long endTime = pagination.getEndTime() != null ? Long.valueOf(pagination.getEndTime().getTime() / 1000L) : null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", thirdObjectId);
        params.put("spNo", pagination.getSpNo());
        params.put("adCcdd", pagination.getAdCcdd());
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        PageHelper.startPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()));
        List<EcsRecordsRelationCcInfoVO> ecsRecordsRelationInfos = this.recordsRelationCcService.selectNonReimbList(params);
        long total = this.recordsRelationCcService.selectNonReimbListCount(params);
        return pagination.setData(ecsRecordsRelationInfos, total);
    }

    @Override
    public List<Tree<String>> getProvinceTree() {
        List allParents = this.provinceService.getListByParentId("-1");
        List parentIds = allParents.stream().map(ProvinceEntity::getId).collect(Collectors.toList());
        List allList = this.provinceService.getAllList();
        List collect = allList.stream().filter(entity -> !"-1".equals(entity.getParentId())).map(entity -> {
            if (parentIds.contains(entity.getParentId())) {
                entity.setParentId("0");
            }
            TreeNode treeNode = new TreeNode((Object)entity.getId(), (Object)entity.getParentId(), entity.getFullName(), (Comparable)entity.getSortCode());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("cityLevel", entity.getCityLevel());
            map.put("type", entity.getType());
            treeNode.setExtra(map);
            return treeNode;
        }).collect(Collectors.toList());
        List treeNodes = TreeUtil.build(collect, (Object)"0");
        return treeNodes;
    }

    @Override
    public List<String> getFullPathByAreaId(String areaId) {
        if (StringUtils.isBlank((CharSequence)areaId)) {
            return Collections.emptyList();
        }
        ArrayList<String> fullPath = new ArrayList<String>();
        this.getFullPathByAreaId(areaId, fullPath);
        return fullPath;
    }

    private void getFullPathByAreaId(String areaId, List<String> fullPath) {
        if (StringUtils.isBlank((CharSequence)areaId) || "-1".equals(areaId)) {
            return;
        }
        ProvinceEntity provinceEntity = (ProvinceEntity)this.provinceService.getById((Serializable)((Object)areaId));
        if (provinceEntity != null) {
            fullPath.add(0, provinceEntity.getId());
            if (!"-1".equals(provinceEntity.getParentId())) {
                this.getFullPathByAreaId(provinceEntity.getParentId(), fullPath);
            }
        }
    }

    @Override
    public List<String> getUserForReimbUserIds() {
        String keyValue;
        UserInfo userInfo = this.userProvider.get();
        EcsConfigEntity config = this.configService.getByKeyName("tripAddBtn", userInfo.getOrganizeId());
        if (config != null && StringUtils.isNotBlank((CharSequence)(keyValue = config.getKeyValue()))) {
            try {
                List jsonToListMap = JsonUtil.getJsonToListMap((String)keyValue);
                ArrayList<String> reimbUserIds = new ArrayList<String>();
                for (Map stringObjectMap : jsonToListMap) {
                    Object creatorId = stringObjectMap.get("creatorId");
                    Object reimbUserId = stringObjectMap.get("reimbUserId");
                    if (creatorId == null || reimbUserId == null || !userInfo.getUserId().equals(creatorId)) continue;
                    reimbUserIds.add(reimbUserId.toString());
                }
                return reimbUserIds;
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u51fa\u5dee\u7533\u8bf7\u4eba\u5458\u5931\u8d25", (Throwable)e);
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<Tree<String>> getCbspList(SignApplyPagination pagination) {
        if (pagination == null || StringUtils.isBlank((CharSequence)pagination.getUserId())) {
            return Collections.emptyList();
        }
        PageHelper.startPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()));
        return null;
    }

    @Override
    public HrmsEmployeeArchiveInfoVO getEmployeeArchiveInfoById(String id) {
        return this.ecsExtendMapper.getEmployeeArchiveInfoById(id);
    }

    @Override
    public List<CustomerInfoVO> getCustomerList(String companyId, String customerName) {
        if (StringUtils.isBlank((CharSequence)companyId)) {
            return Collections.emptyList();
        }
        return this.ecsExtendMapper.getCustomerList(companyId, customerName);
    }
}

