/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBaseEntity;
import com.bringspring.ecs.entity.EcsProjectEntity;
import com.bringspring.ecs.enums.EnableMarkEnum;
import com.bringspring.ecs.mapper.EcsProjectMapper;
import com.bringspring.ecs.model.ecsproject.EcsProjectCrForm;
import com.bringspring.ecs.model.ecsproject.EcsProjectPagination;
import com.bringspring.ecs.model.ecsproject.EcsProjectUpForm;
import com.bringspring.ecs.service.EcsProjectService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsProjectServiceImpl
extends ServiceImpl<EcsProjectMapper, EcsProjectEntity>
implements EcsProjectService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OrganizeService organizeService;

    @Override
    public List<EcsProjectEntity> getList(EcsProjectPagination ecsProjectPagination) {
        return this.getTypeList(ecsProjectPagination, "0");
    }

    @Override
    public List<EcsProjectEntity> getTypeList(EcsProjectPagination ecsProjectPagination, String dataType) {
        Object object;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper ecsProjectQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsProjectQueryWrapper, ecsProjectPagination.getMenuId(), "ecs_project"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsProjectEntity>();
            }
            ecsProjectQueryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsProjectQueryWrapper, ecsProjectPagination.getMenuId(), "ecs_project"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsProjectEntity>();
            }
            ecsProjectQueryWrapper = (QueryWrapper)object;
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)ecsProjectQueryWrapper.lambda().eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode())).like(StringUtils.isNotEmpty((String)ecsProjectPagination.getCode()), EcsProjectEntity::getCode, (Object)ecsProjectPagination.getCode())).like(StringUtils.isNotEmpty((String)ecsProjectPagination.getName()), EcsProjectEntity::getName, (Object)ecsProjectPagination.getName())).like(StringUtils.isNotEmpty((String)ecsProjectPagination.getParentCode()), EcsProjectEntity::getParentCode, (Object)ecsProjectPagination.getParentCode())).like(StringUtils.isNotEmpty((String)ecsProjectPagination.getParentId()), EcsProjectEntity::getParentId, (Object)ecsProjectPagination.getParentId())).like(StringUtils.isNotEmpty((String)ecsProjectPagination.getQueryCity()), EcsProjectEntity::getProjectCity, (Object)ecsProjectPagination.getQueryCity())).eq(StringUtils.isNotEmpty((String)ecsProjectPagination.getManager()), EcsProjectEntity::getManager, (Object)ecsProjectPagination.getManager())).eq(StringUtils.isNotEmpty((String)ecsProjectPagination.getDirector()), EcsProjectEntity::getDirector, (Object)ecsProjectPagination.getDirector());
        if (StringUtils.isEmpty((String)ecsProjectPagination.getSidx())) {
            ecsProjectQueryWrapper.lambda().orderByDesc(EcsProjectEntity::getId);
        } else {
            try {
                String sidx = ecsProjectPagination.getSidx();
                EcsProjectEntity ecsProjectEntity = new EcsProjectEntity();
                Field declaredField = ecsProjectEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsProjectQueryWrapper = "asc".equalsIgnoreCase(ecsProjectPagination.getSort()) ? (QueryWrapper)ecsProjectQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsProjectQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(ecsProjectPagination.getCurrentPage(), ecsProjectPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsProjectQueryWrapper);
            return ecsProjectPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)ecsProjectQueryWrapper);
    }

    @Override
    public List<EcsProjectEntity> getVisibleList(EcsProjectPagination ecsProjectPagination) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper ecsProjectQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)ecsProjectQueryWrapper.lambda().eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode())).eq(EcsProjectEntity::getEnableMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        String companyId = userInfo.getOrganizeId();
        String departmentId = userInfo.getDepartmentId();
        ArrayList userDeptIds = new ArrayList();
        this.organizeService.getOrganizeIdTree(departmentId, userDeptIds);
        String objectToString = JsonUtil.getObjectToString((Object)CollUtil.reverse(userDeptIds));
        String userId = userInfo.getUserId();
        if (Objects.equals(ecsProjectPagination.getIsAuth(), 1)) {
            ecsProjectQueryWrapper.lambda().and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wq.nested(nwq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)nwq.eq(EcsProjectEntity::getVisibleType, (Object)"all")).or()).nested(nwq2 -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)nwq2.eq(EcsProjectEntity::getVisibleType, (Object)"company")).apply("JSON_CONTAINS(visible, {0})", new Object[]{"\"" + companyId + "\""});
                    })).or()).nested(nwq3 -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)nwq3.eq(EcsProjectEntity::getVisibleType, (Object)"department-user")).and(qw4 -> {
                            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw4.apply("JSON_CONTAINS(visible_dept, {0})", new Object[]{objectToString})).or()).apply("JSON_CONTAINS(visible_user, {0})", new Object[]{"\"" + userId + "\""});
                        });
                    });
                });
            });
        }
        return this.list((Wrapper)ecsProjectQueryWrapper);
    }

    @Override
    public EcsProjectEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsProjectEntity::getId, (Object)id);
        return (EcsProjectEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(EcsProjectCrForm ecsProjectCrForm) throws DataException {
        String code = ecsProjectCrForm.getCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsProjectEntity::getCode, (Object)code);
        long count = this.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new DataException("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        String mainId = RandomUtil.uuId();
        EcsProjectEntity entity = (EcsProjectEntity)JsonUtil.getJsonToBean((Object)ecsProjectCrForm, EcsProjectEntity.class);
        if (StringUtils.isBlank((CharSequence)entity.getParentCode())) {
            entity.setParentCode("0");
        }
        if (StringUtils.isBlank((CharSequence)entity.getParentId())) {
            entity.setParentId("0");
        }
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        entity.setEnableMark(EnableMarkEnum.NORMAL.getEnableMark());
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public void update(String id, EcsProjectUpForm ecsProjectUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsProjectEntity entity = this.getInfo(id);
        if (entity != null) {
            EcsProjectEntity subentity = (EcsProjectEntity)JsonUtil.getJsonToBean((Object)ecsProjectUpForm, EcsProjectEntity.class);
            if (StringUtils.isBlank((CharSequence)subentity.getParentCode())) {
                subentity.setParentCode("0");
            }
            if (StringUtils.isBlank((CharSequence)subentity.getParentId())) {
                subentity.setParentId("0");
            }
            this.updateById(subentity);
        }
    }

    @Override
    public void delete(EcsProjectEntity entity) {
        if (entity != null) {
            entity.setDeleteMark(DeleteMarkEnum.DELETED.getCode());
            this.updateById(entity);
        }
    }
}

