/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.entity.EcsBaseEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsRecordsChargesDetailEntity;
import com.bringspring.ecs.mapper.EcsRecordsChargesDetailMapper;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.model.subject.EcsRecordsChargesDetailInfoVO;
import com.bringspring.ecs.service.EcsInvoiceService;
import com.bringspring.ecs.service.EcsRecordsChargesDetailService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsRecordsChargesDetailServiceImpl
extends ServiceImpl<EcsRecordsChargesDetailMapper, EcsRecordsChargesDetailEntity>
implements EcsRecordsChargesDetailService {
    @Autowired
    private EcsInvoiceService invoiceService;

    @Override
    @DSTransactional
    public Boolean deleteByRecordId(String recordId) {
        QueryWrapper relationQueryWrapper = new QueryWrapper();
        relationQueryWrapper.lambda().eq(EcsRecordsChargesDetailEntity::getRecordId, (Object)recordId);
        this.remove((Wrapper)relationQueryWrapper);
        UpdateWrapper invoiceUpdateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)invoiceUpdateWrapper.lambda().eq(EcsInvoiceEntity::getRecordId, (Object)recordId)).set(EcsInvoiceEntity::getRecordId, null)).set(EcsInvoiceEntity::getSubjectId, null)).set(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.DELETED.getCode());
        this.invoiceService.update((Wrapper)invoiceUpdateWrapper);
        return true;
    }

    @Override
    public List<EcsRecordsChargesDetailInfoVO> getSubjectList(String mainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsRecordsChargesDetailEntity::getRecordId, (Object)mainId)).orderByAsc(EcsRecordsChargesDetailEntity::getSortCode);
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && !list.isEmpty()) {
            List ids = list.stream().map(EcsRecordsChargesDetailEntity::getId).collect(Collectors.toList());
            QueryWrapper invoiceQueryWrapper = new QueryWrapper();
            invoiceQueryWrapper.lambda().select(EcsInvoiceEntity.class, info -> !"EXTENDED_FIELDS".equals(info.getColumn())).in(EcsInvoiceEntity::getSubjectId, ids);
            List invoiceList = this.invoiceService.list((Wrapper)invoiceQueryWrapper);
            Map<String, List<EcsInvoiceEntity>> collect = invoiceList.stream().collect(Collectors.groupingBy(EcsInvoiceEntity::getSubjectId));
            List jsonToList = JsonUtil.getJsonToList((Object)list, EcsRecordsChargesDetailInfoVO.class);
            for (EcsRecordsChargesDetailInfoVO infoVO : jsonToList) {
                List ecsInvoiceEntities = collect.getOrDefault(infoVO.getId(), Collections.emptyList());
                infoVO.setInvoiceList(JsonUtil.getJsonToList(ecsInvoiceEntities, EcsInvoiceInfoVO.class));
            }
            return jsonToList;
        }
        return Collections.emptyList();
    }
}

