/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.entity.EcsRecordsHolidayEntity;
import com.bringspring.ecs.enums.ConfigServiceTypeEnum;
import com.bringspring.ecs.mapper.EcsRecordsHolidayEntityMapper;
import com.bringspring.ecs.model.holiday.EcsRecordsHolidayPagination;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.service.EcsRecordsHolidayService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsRecordsHolidayServiceImpl
extends ServiceImpl<EcsRecordsHolidayEntityMapper, EcsRecordsHolidayEntity>
implements EcsRecordsHolidayService {
    private static final String HOLIDAY_NAME = "holidayNames";
    @Autowired
    private EcsConfigService ecsConfigService;

    private List<EcsRecordsHolidayEntity> generateHolidayList(String companyId, String userId, Integer year) {
        EcsConfigEntity config = this.ecsConfigService.getByKeyName(HOLIDAY_NAME, companyId);
        if (Objects.isNull(config)) {
            return new ArrayList<EcsRecordsHolidayEntity>();
        }
        String holidayNames = config.getKeyValue();
        if (!ConfigServiceTypeEnum.MIX.getCode().equals(config.getRuleKey())) {
            return new ArrayList<EcsRecordsHolidayEntity>();
        }
        if (StringUtils.isBlank((CharSequence)holidayNames)) {
            return new ArrayList<EcsRecordsHolidayEntity>();
        }
        List holidayList = JsonUtil.getJsonToList((String)holidayNames, String.class);
        ArrayList<EcsRecordsHolidayEntity> holidayEntityList = new ArrayList<EcsRecordsHolidayEntity>();
        for (String name : holidayList) {
            EcsRecordsHolidayEntity entity = new EcsRecordsHolidayEntity();
            entity.setId(RandomUtil.uuId());
            entity.setRecordId(null);
            entity.setHolidayName(year + "\u5e74" + name);
            entity.setHolidayYear(year);
            entity.setUserId(userId);
            holidayEntityList.add(entity);
        }
        if (!holidayEntityList.isEmpty()) {
            this.saveBatch(holidayEntityList);
        }
        return holidayEntityList;
    }

    @Override
    public List<EcsRecordsHolidayEntity> getHolidayList(EcsRecordsHolidayPagination pagination) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{pagination.getCompanyId(), pagination.getUserId()}) || pagination.getYear() == null) {
            return new ArrayList<EcsRecordsHolidayEntity>();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsRecordsHolidayEntity::getUserId, (Object)pagination.getUserId())).eq(EcsRecordsHolidayEntity::getHolidayYear, (Object)pagination.getYear());
        List<EcsRecordsHolidayEntity> holidayEntityList = this.list((Wrapper)queryWrapper);
        if (holidayEntityList.isEmpty()) {
            holidayEntityList = this.generateHolidayList(pagination.getCompanyId(), pagination.getUserId(), pagination.getYear());
        }
        return holidayEntityList;
    }

    @Override
    public EcsRecordsHolidayEntity getInfo(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (EcsRecordsHolidayEntity)this.getById((Serializable)((Object)id));
    }

    @Override
    public EcsRecordsHolidayEntity getInfoByRecordId(String recordId) {
        if (StringUtils.isBlank((CharSequence)recordId)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsRecordsHolidayEntity::getRecordId, (Object)recordId);
        return (EcsRecordsHolidayEntity)this.getOne((Wrapper)queryWrapper, false);
    }

    @Override
    public void deleteByRecordId(String recordId) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.set(EcsRecordsHolidayEntity::getRecordId, null)).eq(EcsRecordsHolidayEntity::getRecordId, (Object)recordId);
        this.update((Wrapper)wrapper);
    }
}

