/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.ecs.docking.entity.vo.PaymentVO;
import com.bringspring.ecs.docking.service.SkPaymentService;
import com.bringspring.ecs.docking.service.VoucherPushService;
import com.bringspring.ecs.docking.task.PaymentTask;
import com.bringspring.ecs.entity.EcsAdvancePaymentEntity;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsBaseEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeEntity;
import com.bringspring.ecs.entity.EcsCompanyAccountEntity;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsInvoiceRecordEntity;
import com.bringspring.ecs.entity.EcsProjectEntity;
import com.bringspring.ecs.entity.EcsRecordsAdvanceEntity;
import com.bringspring.ecs.entity.EcsRecordsChargesDetailEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsHolidayEntity;
import com.bringspring.ecs.entity.EcsRecordsProjectEntity;
import com.bringspring.ecs.entity.EcsRecordsRelationCcEntity;
import com.bringspring.ecs.entity.EcsRecordsSubsidyEntity;
import com.bringspring.ecs.enums.BudgetRecordOperateTypeEnum;
import com.bringspring.ecs.enums.InvoiceRecordEnum;
import com.bringspring.ecs.enums.RecordAuditEnum;
import com.bringspring.ecs.enums.RecordFileTypeEnum;
import com.bringspring.ecs.enums.RecordNeedReceiveInvoiceEnum;
import com.bringspring.ecs.enums.RecordReviewStatusEnum;
import com.bringspring.ecs.enums.RecordsPdfEnum;
import com.bringspring.ecs.enums.SendCashierTypeEnum;
import com.bringspring.ecs.enums.VoucherPushStateEnum;
import com.bringspring.ecs.exception.RecordsValidateException;
import com.bringspring.ecs.exception.VoucherPushException;
import com.bringspring.ecs.mapper.EcsRecordsMapper;
import com.bringspring.ecs.model.bankcard.EcsBankCardInfoVO;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentInfoVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsUploadVO;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.model.invoicerecord.EcsInvoiceRecordInfoVO;
import com.bringspring.ecs.model.recordproject.EcsRecordsProjectInfoVO;
import com.bringspring.ecs.model.records.EcsRecordsCrForm;
import com.bringspring.ecs.model.records.EcsRecordsExportModel;
import com.bringspring.ecs.model.records.EcsRecordsInfoVO;
import com.bringspring.ecs.model.records.EcsRecordsPagination;
import com.bringspring.ecs.model.records.EcsRecordsPaginationExportModel;
import com.bringspring.ecs.model.records.EcsRecordsPaymentVO;
import com.bringspring.ecs.model.records.EcsRecordsUpForm;
import com.bringspring.ecs.model.relationcc.EcsRecordsRelationCcInfoVO;
import com.bringspring.ecs.model.subject.EcsRecordsChargesDetailInfoVO;
import com.bringspring.ecs.service.EcsAdvancePaymentService;
import com.bringspring.ecs.service.EcsBankCardService;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountService;
import com.bringspring.ecs.service.EcsBudgetOrganizeService;
import com.bringspring.ecs.service.EcsCompanyAccountService;
import com.bringspring.ecs.service.EcsCompanyCommonService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.service.EcsInvoiceRecordService;
import com.bringspring.ecs.service.EcsInvoiceService;
import com.bringspring.ecs.service.EcsMessageService;
import com.bringspring.ecs.service.EcsPdfService;
import com.bringspring.ecs.service.EcsProjectService;
import com.bringspring.ecs.service.EcsRecordsAdvanceService;
import com.bringspring.ecs.service.EcsRecordsChargesDetailService;
import com.bringspring.ecs.service.EcsRecordsHolidayService;
import com.bringspring.ecs.service.EcsRecordsProjectService;
import com.bringspring.ecs.service.EcsRecordsRelationCcService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.service.EcsRecordsSubsidyService;
import com.bringspring.ecs.strategy.records.RecordsStrategyManager;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskListModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsRecordsServiceImpl
extends ServiceImpl<EcsRecordsMapper, EcsRecordsEntity>
implements EcsRecordsService {
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsRecordsChargesDetailService chargesDetailService;
    @Autowired
    private EcsInvoiceService invoiceService;
    @Autowired
    private EcsInvoiceRecordService invoiceRecordService;
    @Autowired
    private EcsRecordsRelationCcService relationCcService;
    @Autowired
    private EcsRecordsSubsidyService subsidyService;
    @Autowired
    private EcsRecordsProjectService recordsProjectService;
    @Autowired
    private EcsRecordsHolidayService ecsRecordsHolidayService;
    @Autowired
    private EcsBudgetOrganizeAccountService budgetOrganizeAccountService;
    @Autowired
    private EcsBankCardService bankCardService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private EcsMessageService ecsMessageService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsCompanyCommonService ecsCompanyCommonService;
    @Autowired
    private RecordsStrategyManager recordsStrategyManager;
    @Autowired
    private EcsCompanyService ecsCompanyService;
    @Autowired
    private EcsProjectService projectService;
    @Autowired
    private UserService userService;
    @Autowired
    private EcsBudgetOrganizeService budgetOrganizeService;
    @Autowired
    private EcsPdfService ecsPdfService;
    @Autowired
    private Executor ecsExecutor;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private SkPaymentService skPaymentService;
    @Autowired
    private PaymentTask paymentTask;
    @Autowired
    private VoucherPushService voucherPushService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private EcsCompanyAccountService companyAccountService;
    @Autowired
    private EcsRecordsAdvanceService ecsRecordsAdvanceService;
    @Autowired
    private EcsAdvancePaymentService advanceService;
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public List<EcsRecordsEntity> getList(EcsRecordsPagination ecsRecordsPagination) {
        return this.getTypeList(ecsRecordsPagination, "0");
    }

    @Override
    public List<EcsRecordsEntity> getTypeList(EcsRecordsPagination pagination, String dataType) {
        QueryWrapper ecsRecordsQueryWrapper = this.getQueryWrapper(pagination);
        if (Objects.isNull(ecsRecordsQueryWrapper)) {
            return new ArrayList<EcsRecordsEntity>();
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            ecsRecordsQueryWrapper.lambda().orderByDesc(EcsRecordsEntity::getId);
        } else {
            try {
                String sidx = pagination.getSidx();
                EcsRecordsEntity ecsRecordsEntity = new EcsRecordsEntity();
                Field declaredField = ecsRecordsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsRecordsQueryWrapper = "asc".equalsIgnoreCase(pagination.getSort()) ? (QueryWrapper)ecsRecordsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsRecordsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                this.log.error("\u6392\u5e8f\u5b57\u6bb5\u4e0d\u5b58\u5728", (Throwable)e);
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsRecordsQueryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)ecsRecordsQueryWrapper);
    }

    @Override
    public List<Map<String, Object>> countByState(EcsRecordsPagination pagination) {
        QueryWrapper<EcsRecordsEntity> queryWrapper = this.getQueryWrapper(pagination);
        if (Objects.isNull(queryWrapper)) {
            return new ArrayList<Map<String, Object>>();
        }
        queryWrapper.select(new String[]{"count(*) as count,audit_status as state"});
        queryWrapper.groupBy((Object)"state");
        return this.listMaps((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> getSummaryInformation(EcsRecordsPagination pagination) {
        Map map = MapUtil.newHashMap();
        map.put("totalReimbAmount", "0");
        map.put("totalInvoiceAmount", "0");
        map.put("totalPaymentAmount", "0");
        QueryWrapper<EcsRecordsEntity> queryWrapper = this.getQueryWrapper(pagination);
        if (Objects.isNull(queryWrapper)) {
            return map;
        }
        queryWrapper.select(new String[]{"coalesce(sum(reimb_amount),0) as totalReimbAmount", "coalesce(sum(invoice_amount),0) as totalInvoiceAmount", "coalesce(sum(pay_amount),0) as totalPaymentAmount"});
        map = this.getMap((Wrapper)queryWrapper);
        return map;
    }

    private QueryWrapper<EcsRecordsEntity> getQueryWrapper(EcsRecordsPagination pagination) {
        Object object;
        QueryWrapper queryWrapper = new QueryWrapper();
        UserInfo userInfo = this.userProvider.get();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && pagination.getIsAuth() == 1 && !userInfo.getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_records"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return null;
            }
            queryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && pagination.getIsAuth() == 1 && !userInfo.getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_records"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return null;
            }
            queryWrapper = (QueryWrapper)object;
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getCompanyId())) {
            String[] split = pagination.getCompanyId().split(",");
            queryWrapper.lambda().in(EcsRecordsEntity::getCompanyId, Arrays.asList(split));
        }
        if ("-1".equals(pagination.getAuditStatus())) {
            pagination.setAuditStatus(null);
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getReviewStatus())) {
            queryWrapper.lambda().eq(EcsRecordsEntity::getReviewStatus, (Object)pagination.getReviewStatus());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(StringUtils.isNotBlank((CharSequence)pagination.getAuditStatus()), EcsRecordsEntity::getAuditStatus, (Object)pagination.getAuditStatus())).eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode())).eq(StringUtils.isNotBlank((CharSequence)pagination.getUserId()), EcsRecordsEntity::getUserId, (Object)pagination.getUserId())).eq(StringUtils.isNotBlank((CharSequence)pagination.getCreatorUserId()), EcsBaseEntity::getCreatorUserId, (Object)pagination.getCreatorUserId())).eq(StringUtils.isNotBlank((CharSequence)pagination.getDepartment()), EcsRecordsEntity::getOrganization, (Object)pagination.getDepartment())).like(StringUtils.isNotBlank((CharSequence)pagination.getTitle()), EcsRecordsEntity::getTitle, (Object)pagination.getTitle())).like(StringUtils.isNotBlank((CharSequence)pagination.getOrderNumber()), EcsRecordsEntity::getOrderNumber, (Object)pagination.getOrderNumber());
        if (Objects.nonNull(pagination.getStartTime())) {
            queryWrapper.lambda().ge(EcsBaseEntity::getCreatorTime, (Object)pagination.getStartTime());
        }
        if (Objects.nonNull(pagination.getEndTime())) {
            queryWrapper.lambda().le(EcsBaseEntity::getCreatorTime, (Object)pagination.getEndTime());
        }
        if (Objects.nonNull(pagination.getSubmitReviewStartTime())) {
            queryWrapper.lambda().ge(EcsRecordsEntity::getSubmitReviewTime, (Object)pagination.getSubmitReviewStartTime());
        }
        if (Objects.nonNull(pagination.getSubmitReviewEndTime())) {
            queryWrapper.lambda().le(EcsRecordsEntity::getSubmitReviewTime, (Object)pagination.getSubmitReviewEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getReimbCompanyId())) {
            queryWrapper.lambda().eq(EcsRecordsEntity::getReimbCompany, (Object)pagination.getReimbCompanyId());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getRecordTypeCode())) {
            queryWrapper.lambda().eq(EcsRecordsEntity::getRecordTypeCode, (Object)pagination.getRecordTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getRecordInvoiceType())) {
            queryWrapper.lambda().eq(EcsRecordsEntity::getRecordInvoiceType, (Object)pagination.getRecordInvoiceType());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getCostVoucherStatus())) {
            queryWrapper.lambda().eq(EcsRecordsEntity::getCostVoucherStatus, (Object)pagination.getCostVoucherStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getPayVoucherStatus())) {
            queryWrapper.lambda().eq(EcsRecordsEntity::getPayVoucherStatus, (Object)pagination.getPayVoucherStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getBankAccountType())) {
            queryWrapper.lambda().eq(EcsRecordsEntity::getBankAccountType, (Object)pagination.getBankAccountType());
        }
        if (!userInfo.getIsAdministrator().booleanValue()) {
            queryWrapper.lambda().and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.gt(EcsRecordsEntity::getAuditStatus, (Object)RecordAuditEnum.DRAFT.getCode())).or()).nested(nw -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)nw.eq(EcsRecordsEntity::getAuditStatus, (Object)RecordAuditEnum.DRAFT.getCode())).and(aw -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)aw.eq(EcsBaseEntity::getCreatorUserId, (Object)userInfo.getUserId())).or()).eq(EcsRecordsEntity::getUserId, (Object)userInfo.getUserId());
                    });
                });
            });
        }
        if (1 == pagination.getIsRunning()) {
            queryWrapper.lambda().notIn(EcsRecordsEntity::getAuditStatus, (Collection)Lists.newArrayList((Object[])new String[]{RecordAuditEnum.DRAFT.getCode(), RecordAuditEnum.PAID.getCode()}));
        }
        if (1 == pagination.getFlowToBe()) {
            PaginationFlowTask paginationFlowTask = new PaginationFlowTask();
            paginationFlowTask.setFlowCategory("ecsReimbManager");
            List waitList = this.flowTaskService.getWaitListAll(paginationFlowTask);
            ArrayList<String> ids = new ArrayList<String>();
            for (FlowTaskListModel flowTaskListModel : waitList) {
                ids.add(flowTaskListModel.getProcessId());
            }
            if (CollUtil.isNotEmpty(ids)) {
                queryWrapper.lambda().in(EcsRecordsEntity::getId, ids);
            } else {
                ids.add("1");
                queryWrapper.lambda().in(EcsRecordsEntity::getId, ids);
            }
        }
        return queryWrapper;
    }

    @Override
    public EcsRecordsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsRecordsEntity::getId, (Object)id);
        return (EcsRecordsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(String mainId, EcsRecordsCrForm crForm) throws DataException {
        if (crForm.getStatus() == 1) {
            this.departmentBudgetAdequate(crForm.getOrganization(), crForm.getSubjectList(), crForm.getSubsidyList());
        }
        crForm.setRecordYear(String.valueOf(DateUtil.getNowYear()));
        try {
            AnnotationContext annotationContext = new AnnotationContext();
            EcsRecordsInfoVO jsonToBean = (EcsRecordsInfoVO)JsonUtil.getJsonToBean((Object)((Object)crForm), EcsRecordsInfoVO.class);
            this.recordsStrategyManager.execute(jsonToBean, annotationContext);
        }
        catch (RecordsValidateException e) {
            throw new DataException(e.getMessage());
        }
        try {
            CompletableFuture.runAsync(() -> {
                String reimbCompany = crForm.getReimbCompany();
                String userId = crForm.getUserId();
                this.ecsCompanyCommonService.saveCompanyCommon(reimbCompany, userId);
                this.bankCardService.setDefault(crForm.getBankCardId());
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        EcsRecordsEntity entity = (EcsRecordsEntity)JsonUtil.getJsonToBean((Object)((Object)crForm), EcsRecordsEntity.class);
        String ecsOrderNumber = null;
        ecsOrderNumber = crForm.getTempSaveData() == 1 || crForm.getStatus() == 0 ? this.baseDataUtil.getBillNumber("ecsReimbBak", Boolean.valueOf(false)) : this.baseDataUtil.getBillNumber("ecsReimb", Boolean.valueOf(false));
        crForm.setOrderNumber(ecsOrderNumber);
        entity.setOrderNumber(ecsOrderNumber);
        crForm.setId(mainId);
        entity.setId(mainId);
        Integer status = crForm.getStatus();
        entity.setAuditStatus(status == 1 ? "20" : "10");
        this.saveAdditionalInfo(mainId, entity, crForm.getUserId(), crForm.getCcList(), crForm.getSubjectList(), crForm.getSubsidyList(), crForm.getProjectList(), crForm.getHolidayId(), crForm.getAdvanceList());
        this.handleRecordInfo(entity, crForm.getRecordYear());
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        this.save(entity);
    }

    private void departmentBudgetAdequate(String organization, List<EcsRecordsChargesDetailInfoVO> subjectList, List<EcsRecordsSubsidyEntity> subsidyList) throws DataException {
        String subjectCode;
        if (StringUtils.isEmpty((String)organization)) {
            throw new DataException("\u8d39\u7528\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, BigDecimal> accountBudgetMap = new HashMap<String, BigDecimal>();
        Map<Object, Object> subjectChargesMap = new HashMap();
        if (CollUtil.isNotEmpty(subjectList)) {
            for (EcsRecordsChargesDetailInfoVO ecsRecordsChargesDetailInfoVO : subjectList) {
                subjectCode = ecsRecordsChargesDetailInfoVO.getSubjectCode();
                BigDecimal actualAmount = ecsRecordsChargesDetailInfoVO.getActualAmount();
                BigDecimal reimbAmount = ecsRecordsChargesDetailInfoVO.getReimbAmount();
                if (actualAmount == null) {
                    actualAmount = BigDecimal.ZERO;
                }
                if (reimbAmount == null) {
                    reimbAmount = BigDecimal.ZERO;
                }
                actualAmount = actualAmount.add(reimbAmount);
                accountBudgetMap.merge(subjectCode, actualAmount, BigDecimal::add);
            }
            subjectChargesMap = subjectList.stream().collect(Collectors.groupingBy(EcsRecordsChargesDetailInfoVO::getSubjectCode));
        }
        if (CollUtil.isNotEmpty(subsidyList)) {
            for (EcsRecordsSubsidyEntity ecsRecordsSubsidyEntity : subsidyList) {
                subjectCode = "0101";
                BigDecimal totalAmount = ecsRecordsSubsidyEntity.getTotalAmount();
                if (totalAmount == null) {
                    totalAmount = BigDecimal.ZERO;
                }
                accountBudgetMap.merge(subjectCode, totalAmount, BigDecimal::add);
            }
        }
        for (Map.Entry entry : accountBudgetMap.entrySet()) {
            EcsBudgetOrganizeAccountEntity departmentBudge = this.budgetOrganizeAccountService.getDepartmentBudge(organization, (String)entry.getKey());
            if (!this.budgetOrganizeAccountService.isBudgetSufficient(departmentBudge, (BigDecimal)entry.getValue()).booleanValue()) {
                throw new DataException("\u62a5\u9500\u91d1\u989d\u8d85\u8fc7\u90e8\u95e8\u9884\u7b97");
            }
            List ecsRecordsChargesDetailInfoVOS = (List)subjectChargesMap.get(entry.getKey());
            if (CollUtil.isNotEmpty((Collection)ecsRecordsChargesDetailInfoVOS)) {
                for (EcsRecordsChargesDetailInfoVO ecsRecordsChargesDetailInfoVO : ecsRecordsChargesDetailInfoVOS) {
                    ecsRecordsChargesDetailInfoVO.setBudgetId(departmentBudge.getId());
                }
            }
            if (!CollUtil.isNotEmpty(subsidyList)) continue;
            for (EcsRecordsSubsidyEntity ecsRecordsSubsidyEntity : subsidyList) {
                ecsRecordsSubsidyEntity.setBudgetId(departmentBudge.getId());
            }
        }
    }

    private void saveAdditionalInfo(String recordId, EcsRecordsEntity entity, String reimbUserId, List<EcsRecordsRelationCcInfoVO> ccList, List<EcsRecordsChargesDetailInfoVO> detailList, List<EcsRecordsSubsidyEntity> subsidyList, List<EcsRecordsProjectInfoVO> projectList, String holidayId, List<EcsAdvancePaymentInfoVO> advanceList) {
        if (CollUtil.isNotEmpty(ccList)) {
            List ccEntities = JsonUtil.getJsonToList(ccList, EcsRecordsRelationCcEntity.class);
            for (EcsRecordsRelationCcEntity ccEntity : ccEntities) {
                ccEntity.setRecordId(recordId);
                ccEntity.setSystemUserId(reimbUserId);
                if (!"custom".equals(ccEntity.getDataType())) continue;
                ccEntity.setId(RandomUtil.uuId());
                ccEntity.setSpNo(RandomUtil.uuId());
                ccEntity.setSpName("\u51fa\u5dee");
                ccEntity.setDt(new Date());
            }
            this.relationCcService.saveBatch(ccEntities);
        }
        if (CollUtil.isNotEmpty(detailList)) {
            List errorFieldList2;
            String errorFields;
            Object detailId;
            Iterator<EcsRecordsProjectInfoVO> updateList = new ArrayList();
            int totalInvoiceNum = 0;
            int invoiceNum = detailList.size();
            int electronicNum = 0;
            int paperNum = 0;
            int sort = 1;
            String amountConsistent = "90";
            boolean isChange = true;
            for (EcsRecordsChargesDetailInfoVO subjectEntity : detailList) {
                detailId = RandomUtil.uuId();
                subjectEntity.setId((String)detailId);
                subjectEntity.setRecordId(recordId);
                subjectEntity.setSortCode(sort++);
                for (EcsInvoiceInfoVO infoVO : subjectEntity.getInvoiceList()) {
                    infoVO.setSubjectId((String)detailId);
                    infoVO.setRecordId(recordId);
                    errorFields = infoVO.getErrorFields();
                    if (!StringUtils.isNotBlank((CharSequence)errorFields)) continue;
                    try {
                        errorFieldList2 = JsonUtil.getJsonToList((String)errorFields, String.class);
                        if (!CollUtil.isNotEmpty((Collection)errorFieldList2)) continue;
                        for (String field : errorFieldList2) {
                            if (!"invoiceAmount".equals(field)) continue;
                            infoVO.setInvoiceAmount(subjectEntity.getInvoiceTotalAmount());
                        }
                    }
                    catch (Exception errorFieldList2) {
                    }
                }
                if (isChange && !subjectEntity.getInvoiceTotalAmount().equals(subjectEntity.getActualAmount())) {
                    amountConsistent = "10";
                    isChange = false;
                }
                totalInvoiceNum += subjectEntity.getFileSizeNum().intValue();
                updateList.addAll(subjectEntity.getInvoiceList());
            }
            this.chargesDetailService.saveBatch(JsonUtil.getJsonToList(detailList, EcsRecordsChargesDetailEntity.class));
            if (!updateList.isEmpty()) {
                ArrayList<EcsInvoiceEntity> invoiceList = new ArrayList<EcsInvoiceEntity>();
                ArrayList<EcsInvoiceRecordEntity> invoiceRecordList = new ArrayList<EcsInvoiceRecordEntity>();
                detailId = updateList.iterator();
                while (detailId.hasNext()) {
                    EcsInvoiceInfoVO infoVO = (EcsInvoiceInfoVO)detailId.next();
                    EcsInvoiceEntity ecsInvoiceEntity = new EcsInvoiceEntity();
                    ecsInvoiceEntity.setId(infoVO.getId());
                    ecsInvoiceEntity.setRecordId(recordId);
                    ecsInvoiceEntity.setSubjectId(infoVO.getSubjectId());
                    ecsInvoiceEntity.setReimbUserId(reimbUserId);
                    ecsInvoiceEntity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
                    errorFields = infoVO.getErrorFields();
                    if (StringUtils.isNotBlank((CharSequence)errorFields)) {
                        try {
                            errorFieldList2 = JsonUtil.getJsonToList((String)errorFields, String.class);
                            if (CollUtil.isNotEmpty((Collection)errorFieldList2)) {
                                for (String field : errorFieldList2) {
                                    if ("invoiceDate".equals(field)) {
                                        ecsInvoiceEntity.setInvoiceDate(infoVO.getInvoiceDate());
                                        continue;
                                    }
                                    if ("invoiceAmount".equals(field)) {
                                        ecsInvoiceEntity.setInvoiceAmount(infoVO.getInvoiceAmount());
                                        continue;
                                    }
                                    if (!"invoiceNumber".equals(field)) continue;
                                    ecsInvoiceEntity.setInvoiceNumber(infoVO.getInvoiceNumber());
                                }
                            }
                        }
                        catch (Exception errorFieldList3) {
                            // empty catch block
                        }
                    }
                    invoiceList.add(ecsInvoiceEntity);
                    if (RecordFileTypeEnum.PAPER_INVOICE.getCode().equals(infoVO.getFileType())) {
                        EcsInvoiceRecordEntity recordEntity = new EcsInvoiceRecordEntity();
                        recordEntity.setId(RandomUtil.uuId());
                        recordEntity.setRecordId(recordId);
                        recordEntity.setInvoiceId(infoVO.getId());
                        recordEntity.setInvoiceStatus(InvoiceRecordEnum.PENDING.getCode());
                        invoiceRecordList.add(recordEntity);
                    }
                    if (!RecordFileTypeEnum.ELECTRONIC_INVOICE.getCode().equals(infoVO.getFileType())) continue;
                    ++electronicNum;
                }
                paperNum = invoiceNum - electronicNum;
                entity.setTotalInvoiceNum(totalInvoiceNum);
                entity.setInvoiceNum(invoiceNum);
                entity.setElectronicNum(electronicNum);
                entity.setPaperNum(paperNum);
                String recordInvoiceType = paperNum > 0 ? "0" : "1";
                entity.setRecordInvoiceType(recordInvoiceType);
                entity.setAmountConsistent(amountConsistent);
                entity.setNeedReceiveInvoice(RecordNeedReceiveInvoiceEnum.NOT_NEED_RECEIVE_INVOICE.getCode());
                this.invoiceService.updateBatchById(invoiceList);
                if (CollUtil.isNotEmpty(invoiceRecordList)) {
                    this.invoiceRecordService.saveBatch(invoiceRecordList);
                    entity.setNeedReceiveInvoice(RecordNeedReceiveInvoiceEnum.NEED_RECEIVE_INVOICE.getCode());
                }
            }
        } else {
            entity.setNeedReceiveInvoice(RecordNeedReceiveInvoiceEnum.NOT_NEED_RECEIVE_INVOICE.getCode());
            entity.setRecordInvoiceType("-1");
        }
        if (CollUtil.isNotEmpty(subsidyList)) {
            for (EcsRecordsSubsidyEntity subsidyEntity : subsidyList) {
                subsidyEntity.setId(RandomUtil.uuId());
                subsidyEntity.setRecordId(recordId);
            }
            this.subsidyService.saveBatch(subsidyList);
        }
        if (CollUtil.isNotEmpty(projectList)) {
            for (EcsRecordsProjectInfoVO ecsRecordsProjectInfoVO : projectList) {
                ecsRecordsProjectInfoVO.setId(RandomUtil.uuId());
                ecsRecordsProjectInfoVO.setRecordId(recordId);
            }
            List entityList = JsonUtil.getJsonToList(projectList, EcsRecordsProjectEntity.class);
            this.recordsProjectService.saveBatch(entityList);
        }
        if (StringUtils.isNotBlank((CharSequence)holidayId)) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.lambda().set(EcsRecordsHolidayEntity::getRecordId, (Object)recordId)).eq(EcsRecordsHolidayEntity::getId, (Object)holidayId);
            this.ecsRecordsHolidayService.update((Wrapper)updateWrapper);
        }
        if (CollUtil.isNotEmpty(advanceList)) {
            ArrayList<EcsRecordsAdvanceEntity> advanceDetailList = new ArrayList<EcsRecordsAdvanceEntity>();
            BigDecimal reimbAmount = entity.getReimbAmount();
            for (EcsAdvancePaymentInfoVO infoVO : advanceList) {
                BigDecimal repaymentAmount;
                EcsRecordsAdvanceEntity advanceDetailEntity = new EcsRecordsAdvanceEntity();
                advanceDetailEntity.setId(RandomUtil.uuId());
                advanceDetailEntity.setRecordId(recordId);
                advanceDetailEntity.setAdvanceId(infoVO.getId());
                advanceDetailEntity.setTotalAdvanceAmount(infoVO.getTotalAdvanceAmount());
                BigDecimal shouldAmount = infoVO.getTotalAdvanceAmount().subtract(infoVO.getRepaymentAmount()).subtract(infoVO.getRepayingAmount());
                advanceDetailEntity.setShouldRepaymentAmount(shouldAmount);
                advanceDetailEntity.setRepaymentAmount(infoVO.getRepaymentAmount());
                advanceDetailEntity.setRepayingAmount(infoVO.getRepayingAmount());
                if (shouldAmount.compareTo(reimbAmount) >= 0) {
                    repaymentAmount = reimbAmount;
                    reimbAmount = BigDecimal.ZERO;
                } else {
                    repaymentAmount = shouldAmount;
                    reimbAmount = reimbAmount.subtract(shouldAmount);
                }
                advanceDetailEntity.setCurrentPaymentAmount(repaymentAmount);
                advanceDetailList.add(advanceDetailEntity);
            }
            if (CollUtil.isNotEmpty(advanceDetailList)) {
                this.ecsRecordsAdvanceService.saveBatch(advanceDetailList);
            }
        }
    }

    private void handleRecordInfo(EcsRecordsEntity entity, String recordYear) {
        boolean isPc;
        EcsBankCardEntity bankCardEntity;
        String bankCardId;
        String organization = entity.getOrganization();
        if (StringUtils.isNotBlank((CharSequence)organization)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getId, (Object)organization)).eq(EcsBudgetOrganizeEntity::getYear, (Object)recordYear);
            EcsBudgetOrganizeEntity one = (EcsBudgetOrganizeEntity)this.budgetOrganizeService.getOne((Wrapper)queryWrapper, false);
            if (one != null) {
                entity.setOrganizationName(one.getFullName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(bankCardId = entity.getBankCardId())) && (bankCardEntity = (EcsBankCardEntity)this.bankCardService.getById((Serializable)((Object)bankCardId))) != null) {
            entity.setBankAccountType(bankCardEntity.getAccountType());
        }
        entity.setDataSource((isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc")) ? "pc" : "app");
    }

    @Override
    public void update(String id, EcsRecordsUpForm upForm) throws DataException {
        if (upForm.getStatus() == 1) {
            this.departmentBudgetAdequate(upForm.getOrganization(), upForm.getSubjectList(), upForm.getSubsidyList());
            if (upForm.getOrderNumber().startsWith("B-")) {
                upForm.setOrderNumber(this.baseDataUtil.getBillNumber("ecsReimb", Boolean.valueOf(false)));
            }
        }
        upForm.setRecordYear(String.valueOf(DateUtil.getNowYear()));
        try {
            AnnotationContext annotationContext = new AnnotationContext();
            EcsRecordsInfoVO jsonToBean = (EcsRecordsInfoVO)JsonUtil.getJsonToBean((Object)((Object)upForm), EcsRecordsInfoVO.class);
            this.recordsStrategyManager.execute(jsonToBean, annotationContext);
        }
        catch (RecordsValidateException e) {
            throw new DataException(e.getMessage());
        }
        EcsRecordsEntity entity = this.getInfo(id);
        if (entity != null) {
            this.relationCcService.deleteByRecordId(id);
            this.chargesDetailService.deleteByRecordId(id);
            this.subsidyService.deleteByRecordId(id);
            this.invoiceRecordService.deleteByRecordId(id);
            this.recordsProjectService.deleteByRecordId(id);
            this.ecsRecordsHolidayService.deleteByRecordId(id);
            this.ecsRecordsAdvanceService.deleteByRecordId(id);
            EcsRecordsEntity subEntity = (EcsRecordsEntity)JsonUtil.getJsonToBean((Object)((Object)upForm), EcsRecordsEntity.class);
            this.saveAdditionalInfo(id, subEntity, upForm.getUserId(), upForm.getCcList(), upForm.getSubjectList(), upForm.getSubsidyList(), upForm.getProjectList(), upForm.getHolidayId(), upForm.getAdvanceList());
            this.handleRecordInfo(subEntity, upForm.getRecordYear());
            this.updateById(subEntity);
        }
    }

    @Override
    public void delete(EcsRecordsEntity entity) {
        if (entity != null && RecordAuditEnum.DRAFT.getCode().equals(entity.getAuditStatus())) {
            entity.setDeleteMark(DeleteMarkEnum.DELETED.getCode());
            this.updateById(entity);
            this.ecsRecordsHolidayService.deleteByRecordId(entity.getId());
        }
    }

    @Override
    public void getRecordsSubjectInfo(EcsRecordsInfoVO vo) {
        String mainId = vo.getId();
        List<EcsRecordsRelationCcInfoVO> tripList = this.relationCcService.getTripList(mainId);
        vo.setCcList(tripList);
        List<EcsRecordsChargesDetailInfoVO> subjectList = this.chargesDetailService.getSubjectList(mainId);
        vo.setSubjectList(subjectList);
        List<EcsRecordsSubsidyEntity> subsidyList = this.subsidyService.getSubsidyList(mainId);
        vo.setSubsidyList(subsidyList);
        List<EcsRecordsProjectEntity> projectList = this.recordsProjectService.getProjectList(mainId);
        vo.setProjectList(JsonUtil.getJsonToList(projectList, EcsRecordsProjectInfoVO.class));
        String bankCardId = vo.getBankCardId();
        if (StringUtils.isNotBlank((CharSequence)bankCardId)) {
            EcsBankCardEntity byId = (EcsBankCardEntity)this.bankCardService.getById((Serializable)((Object)bankCardId));
            vo.setBankCardInfo((EcsBankCardInfoVO)JsonUtil.getJsonToBean((Object)byId, EcsBankCardInfoVO.class));
        }
        EcsRecordsHolidayEntity holidayInfo = this.ecsRecordsHolidayService.getInfoByRecordId(mainId);
        vo.setHolidayInfo(holidayInfo);
        if (holidayInfo != null) {
            vo.setHolidayId(holidayInfo.getId());
        }
        List<EcsAdvancePaymentEntity> advanceDetailList = this.advanceService.getAdvanceList(mainId);
        List advanceInfos = JsonUtil.getJsonToList(advanceDetailList, EcsAdvancePaymentInfoVO.class);
        for (EcsAdvancePaymentInfoVO advanceInfo : advanceInfos) {
            advanceInfo.setTotalUnpaidLoan(advanceInfo.getTotalAdvanceAmount().subtract(advanceInfo.getRepaymentAmount()).subtract(advanceInfo.getRepayingAmount()));
        }
        vo.setAdvanceList(advanceInfos);
    }

    @Override
    public void paymentAmount(String id) {
        EcsRecordsEntity entity = (EcsRecordsEntity)this.getById((Serializable)((Object)id));
        if (entity == null) {
            return;
        }
        entity.setAuditStatus(RecordAuditEnum.PAID.getCode());
        this.updateById(entity);
    }

    @Override
    public Map<String, Object> getApprovedByCode(String taskId, Integer type) {
        HashMap map = MapUtil.newHashMap();
        map.put("handleId", "");
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return map;
        }
        FlowTaskEntity flowTask = FlowUtil.getFlowTaskSubmited((String)taskId, (SFunction[])new SFunction[]{FlowTaskEntity::getProcessId});
        String processId = flowTask.getProcessId();
        EcsRecordsEntity info = (EcsRecordsEntity)this.getById((Serializable)((Object)processId));
        if (info == null) {
            return map;
        }
        String organization = info.getOrganization();
        if (StringUtils.isBlank((CharSequence)organization)) {
            return map;
        }
        OrganizeEntity organizeInfo = this.serviceUtil.getOrganizeInfo(organization);
        String managerId = organizeInfo.getManagerId();
        managerId = this.getManagerByLevel(managerId, type.intValue(), new ArrayList<UserEntity>());
        map.put("handleId", managerId);
        return map;
    }

    @Override
    public Map<String, Object> getApprovedByUser(String taskId, Integer type) {
        HashMap map = MapUtil.newHashMap();
        map.put("handleId", "");
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return map;
        }
        FlowTaskEntity flowTask = FlowUtil.getFlowTaskSubmited((String)taskId, (SFunction[])new SFunction[]{FlowTaskEntity::getProcessId});
        String processId = flowTask.getProcessId();
        EcsRecordsEntity info = (EcsRecordsEntity)this.getById((Serializable)((Object)processId));
        if (info == null) {
            return map;
        }
        String userId = info.getUserId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            return map;
        }
        type = type + 1;
        String managerId = this.getManagerByLevel(userId, type.intValue(), new ArrayList<UserEntity>());
        map.put("handleId", managerId);
        return map;
    }

    private String getManagerByLevel(String managerId, long level, List<UserEntity> userList) {
        if (--level == 0L) {
            return managerId;
        }
        UserEntity userEntity = userList.stream().filter(t -> t.getId().equals(managerId)).findFirst().orElse(null);
        if (userEntity == null && (userEntity = this.serviceUtil.getUserInfo(managerId)) != null) {
            userList.add(userEntity);
        }
        return userEntity != null ? this.getManagerByLevel(userEntity.getManagerId(), level, userList) : "";
    }

    private String getParentOrganization(String organizationId, long level, List<OrganizeEntity> organizeList) {
        if (--level == 0L) {
            return organizationId;
        }
        OrganizeEntity organizeEntity = organizeList.stream().filter(t -> t.getId().equals(organizationId)).findFirst().orElse(null);
        if (organizeEntity == null && (organizeEntity = this.serviceUtil.getOrganizeInfo(organizationId)) != null) {
            organizeList.add(organizeEntity);
        }
        return organizeEntity != null ? this.getParentOrganization(organizeEntity.getParentId(), level, organizeList) : "";
    }

    @Override
    @FlowCallBackMethod(fullName="\u8d39\u63a7\u62a5\u9500\u7533\u8bf7")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        EcsRecordsEntity entity = this.getInfo(id);
        List<EcsRecordsChargesDetailInfoVO> subjectList = this.chargesDetailService.getSubjectList(id);
        List<EcsRecordsSubsidyEntity> subsidyList = this.subsidyService.getSubsidyList(id);
        switch (enableMark) {
            case 1: {
                this.handleDepartmentBudge(entity, subjectList, subsidyList, BudgetRecordOperateTypeEnum.REIMBURSEMENT_SUBMIT);
                entity.setAuditStatus(RecordAuditEnum.AUDITING.getCode());
                entity.setSubmitTime(DateUtil.getNowDate());
                if (RecordsPdfEnum.FORCE.getCode().equals(entity.getGeneratePdfStatus())) {
                    entity.setGeneratePdfStatus(RecordsPdfEnum.FORCE_SYSTEM.getCode());
                    entity.setIsPrinted("9");
                    this.auditHandler(id);
                }
                this.updateById(entity);
                this.advanceService.advanceApproval(id, BudgetRecordOperateTypeEnum.REIMBURSEMENT_SUBMIT);
                break;
            }
            case 2: {
                this.handleDepartmentBudge(entity, subjectList, subsidyList, BudgetRecordOperateTypeEnum.REIMBURSEMENT_PASS);
                this.advanceService.advanceApproval(id, BudgetRecordOperateTypeEnum.REIMBURSEMENT_PASS);
                boolean hasPaperInvoice = RecordNeedReceiveInvoiceEnum.NEED_RECEIVE_INVOICE.getCode().equals(entity.getNeedReceiveInvoice());
                EcsConfigEntity config = this.ecsConfigService.getByKeyName("voucher", "1");
                String keyValue = config.getKeyValue();
                boolean isAuto = "1".equals(keyValue);
                if (hasPaperInvoice) {
                    List<EcsInvoiceRecordInfoVO> receiveInvoiceList = this.invoiceRecordService.getReceiveInvoiceList(id);
                    boolean allInvoiceReceived = true;
                    for (EcsInvoiceRecordInfoVO infoVO : receiveInvoiceList) {
                        if (infoVO.getInvoiceStatus() != 0) continue;
                        allInvoiceReceived = false;
                        break;
                    }
                    boolean bl = hasPaperInvoice = !allInvoiceReceived;
                }
                if (hasPaperInvoice) {
                    entity.setAuditStatus(RecordAuditEnum.WAITING_RECEIPT.getCode());
                } else if (isAuto || entity.getCompanyId().equals("14")) {
                    entity.setAuditStatus(RecordAuditEnum.WAITING_PAYMENT.getCode());
                } else {
                    entity.setAuditStatus(RecordAuditEnum.WAITING_VOUCHER.getCode());
                }
                entity.setGeneratePdfStatus(RecordsPdfEnum.FINAL.getCode());
                if (!hasPaperInvoice && isAuto) {
                    String title = "\u60a8\u6709\u4e00\u7b14\u5f85\u63d0\u4ea4\u590d\u6838\u7684\u62a5\u9500\u5355\u5f85\u5904\u7406";
                    HashMap<String, String> map = new HashMap<String, String>();
                    List<String> userIds = this.getUserIdsByReimbCompany(entity, "1");
                    this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_1.getCode(), userIds, title, "\u300c" + title + "\u300d,\u5355\u53f7\uff1a" + entity.getOrderNumber(), map, "\u63d0\u4ea4\u590d\u6838");
                    boolean voucher = false;
                    try {
                        voucher = this.voucherPushService.pushVoucher(entity.getId());
                        if (voucher) {
                            String voucherNum = this.voucherPushService.getVoucherNum(entity.getId());
                            entity.setCostVoucherStatus(VoucherPushStateEnum.SUCCESS.getCode());
                            entity.setCostVoucherTime(new Date());
                            entity.setCostVoucherNum(voucherNum);
                        } else {
                            entity.setCostVoucherStatus(VoucherPushStateEnum.FAIL.getCode());
                            entity.setCostVoucherTime(new Date());
                        }
                    }
                    catch (VoucherPushException voucherPushException) {
                        // empty catch block
                    }
                }
                this.updateById(entity);
                String userId = entity.getUserId();
                String creatorUserId1 = entity.getCreatorUserId();
                if (Objects.equals(userId, creatorUserId1)) break;
                String creatorUserName = this.baseDataUtil.userSelectValue(entity.getCreatorUserId());
                this.ecsMessageService.sendAuditMessage(entity.getId(), entity.getUserId(), creatorUserName, () -> "\u60a8\u63d0\u4ea4\u7684\u300c" + entity.getTitle() + "\u300d" + entity.getRecordType() + "\u62a5\u9500\u5355\u636e\u5df2\u5ba1\u6838\u5b8c\u6210, \u7b49\u5f85\u4ed8\u6b3e", () -> "\u60a8\u63d0\u4ea4\u7684\u300c" + entity.getTitle() + "\u300d" + entity.getRecordType() + "\u62a5\u9500\u5355\u636e\u5df2\u5ba1\u6838\u5b8c\u6210, \u7b49\u5f85\u4ed8\u6b3e, \u5355\u53f7\uff1a" + entity.getOrderNumber());
                break;
            }
            case 4: {
                try {
                    entity.setIsPrinted("9");
                    this.updateById(entity);
                    this.auditHandler(id);
                }
                catch (Exception e) {
                    this.log.error("\u53d1\u9001\u6253\u5370\u6d88\u606f\u5931\u8d25", (Throwable)e);
                }
                break;
            }
            case 5: {
                if (!"0".equals(model.getRejectAgreeStep())) break;
                if ("1".equals(model.getRejectAuditType())) {
                    entity.setGeneratePdfStatus(RecordsPdfEnum.FORCE.getCode());
                }
            }
            case 3: {
                this.handleDepartmentBudge(entity, subjectList, subsidyList, BudgetRecordOperateTypeEnum.REIMBURSEMENT_CANCEL);
                this.advanceService.advanceApproval(id, BudgetRecordOperateTypeEnum.REIMBURSEMENT_CANCEL);
                entity.setAuditStatus(RecordAuditEnum.DRAFT.getCode());
                entity.setIsPrinted("0");
                this.updateById(entity);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.delete(entity);
                break;
            }
        }
        return false;
    }

    private void auditHandler(String id) {
        CompletableFuture.runAsync(() -> {
            for (int retryCount = 0; retryCount < 3; ++retryCount) {
                EcsRecordsEntity entity = this.getInfo(id);
                if ("9".equals(entity.getIsPrinted())) {
                    this.generatePDF(id);
                    boolean hasPaperInvoice = RecordNeedReceiveInvoiceEnum.NEED_RECEIVE_INVOICE.getCode().equals(entity.getNeedReceiveInvoice());
                    if (!hasPaperInvoice) break;
                    String creatorUserId = entity.getCreatorUserId();
                    String title = entity.getTitle();
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("preview", "1");
                    params.put("previewRecordId", id);
                    this.ecsMessageService.sendPrintMessage(Lists.newArrayList((Object[])new String[]{creatorUserId}), "\u60a8\u6709\u5f85\u6253\u5370\u7684\u62a5\u9500\u5355\u636e\uff0c\u8bf7\u524d\u5f80PC\u7aef\u9875\u9762\u67e5\u770b\u5e76\u6253\u5370", "\u300c" + title + "\u300d,\u5355\u53f7\uff1a" + entity.getOrderNumber(), params);
                    break;
                }
                if (retryCount >= 2) continue;
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.log.error("\u7761\u7720\u4e2d\u65ad", (Throwable)e);
                    break;
                }
            }
        }, this.ecsExecutor);
    }

    private void handleDepartmentBudge(EcsRecordsEntity entity, List<EcsRecordsChargesDetailInfoVO> subjectList, List<EcsRecordsSubsidyEntity> subsidyList, BudgetRecordOperateTypeEnum operateTypeEnum) {
        String budgetId;
        HashMap<String, BigDecimal> budgetMap = new HashMap<String, BigDecimal>();
        for (EcsRecordsChargesDetailInfoVO ecsRecordsChargesDetailInfoVO : subjectList) {
            budgetId = ecsRecordsChargesDetailInfoVO.getBudgetId();
            if (!StringUtils.isNotBlank((CharSequence)budgetId)) continue;
            BigDecimal reimb = ecsRecordsChargesDetailInfoVO.getReimbAmount();
            BigDecimal actualAmount = ecsRecordsChargesDetailInfoVO.getActualAmount();
            BigDecimal totalAmount = reimb.add(actualAmount);
            budgetMap.merge(budgetId, totalAmount, BigDecimal::add);
        }
        if (CollUtil.isNotEmpty(subsidyList)) {
            for (EcsRecordsSubsidyEntity ecsRecordsSubsidyEntity : subsidyList) {
                budgetId = ecsRecordsSubsidyEntity.getBudgetId();
                if (!StringUtils.isNotBlank((CharSequence)budgetId)) continue;
                BigDecimal totalAmount = ecsRecordsSubsidyEntity.getTotalAmount();
                budgetMap.merge(budgetId, totalAmount, BigDecimal::add);
            }
        }
        for (Map.Entry entry : budgetMap.entrySet()) {
            EcsBudgetOrganizeAccountEntity departmentBudge = (EcsBudgetOrganizeAccountEntity)this.budgetOrganizeAccountService.getById((Serializable)entry.getKey());
            this.budgetOrganizeAccountService.budgetApproval(entity, departmentBudge, (BigDecimal)entry.getValue(), operateTypeEnum);
        }
    }

    @Override
    public int leaveCount(String userId, String year, String recordType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsRecordsEntity::getUserId, (Object)userId)).eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode())).eq(EcsRecordsEntity::getRecordYear, (Object)year)).eq(EcsRecordsEntity::getRecordType, (Object)recordType);
        long count = this.count((Wrapper)queryWrapper);
        return (int)count;
    }

    @Override
    public EcsUploadVO getRecordPDF(String id) {
        return this.ecsPdfService.getRecordPDF(id);
    }

    @Override
    public DownloadVO generatePDF(String id) {
        EcsRecordsEntity recordEntity = this.updateRecordPrintStatus(id);
        EcsRecordsInfoVO vo = (EcsRecordsInfoVO)JsonUtil.getJsonToBean((Object)recordEntity, EcsRecordsInfoVO.class);
        this.getRecordsSubjectInfo(vo);
        return this.ecsPdfService.generatePDF(id, vo);
    }

    private EcsRecordsEntity updateRecordPrintStatus(String id) {
        EcsRecordsEntity recordEntity = (EcsRecordsEntity)this.getById((Serializable)((Object)id));
        String isPrinted = recordEntity.getIsPrinted();
        if ("0".equals(isPrinted) || "9".equals(isPrinted) || StringUtils.isEmpty((String)isPrinted)) {
            recordEntity.setIsPrinted("1");
            recordEntity.setGeneratePdfStatus(RecordsPdfEnum.AUTO.getCode());
            recordEntity.setGeneratePdfTime(DateUtil.getNowDate());
            this.updateById(recordEntity);
        }
        return recordEntity;
    }

    @Override
    public DownloadVO exportExcel(EcsRecordsPaginationExportModel exportModel) {
        EcsRecordsPagination ecsRecordsPagination = (EcsRecordsPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)exportModel), EcsRecordsPagination.class));
        UserInfo userInfo = this.userProvider.get();
        List<EcsRecordsEntity> typeList = this.getTypeList(ecsRecordsPagination, exportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(typeList, EcsRecordsInfoVO.class);
        ArrayList<EcsRecordsExportModel> exportModelList = new ArrayList<EcsRecordsExportModel>();
        if (ObjectUtil.isNotEmpty((Object)listVO)) {
            DecimalFormat df = new DecimalFormat("#,##0.00");
            List bankCardEntities = this.bankCardService.list();
            Map<String, EcsBankCardEntity> bankCardEntityMap = bankCardEntities.stream().collect(Collectors.toMap(EcsBankCardEntity::getId, v -> v));
            List projectEntities = this.projectService.list();
            Map<String, EcsProjectEntity> projectEntityMap = projectEntities.stream().collect(Collectors.toMap(EcsProjectEntity::getId, v -> v));
            List recordsProjectEntities = this.recordsProjectService.list();
            Map<String, List<EcsRecordsProjectEntity>> recordsProjectMap = recordsProjectEntities.stream().collect(Collectors.groupingBy(EcsRecordsProjectEntity::getRecordId));
            List userEntities = this.userService.list();
            Map<String, UserEntity> userEntityMap = userEntities.stream().collect(Collectors.toMap(UserEntity::getId, v -> v));
            List list = this.ecsCompanyService.list();
            Map<String, EcsCompanyEntity> companyEntityMap = list.stream().collect(Collectors.toMap(EcsCompanyEntity::getId, v -> v));
            for (EcsRecordsInfoVO ecsRecordsInfoVO : listVO) {
                RecordAuditEnum enumByCode;
                EcsCompanyEntity company;
                UserEntity userEntity;
                String id;
                JSONObject jsonObject;
                List<EcsRecordsProjectEntity> projectEntityList;
                EcsRecordsExportModel exportModel1 = new EcsRecordsExportModel();
                BeanUtil.copyProperties((Object)ecsRecordsInfoVO, (Object)exportModel1, (String[])new String[0]);
                String bankCardId = ecsRecordsInfoVO.getBankCardId();
                if (bankCardEntityMap.containsKey(bankCardId)) {
                    EcsBankCardEntity bankCard = bankCardEntityMap.get(bankCardId);
                    exportModel1.setReceivingAccount(bankCard.getCardNumber());
                    exportModel1.setAccountName(bankCard.getUsername());
                    exportModel1.setBankName("");
                    exportModel1.setBankBranch(bankCard.getBankName());
                    exportModel1.setAccountType("\u4e2a\u4eba");
                }
                if (CollUtil.isNotEmpty(projectEntityList = recordsProjectMap.get(ecsRecordsInfoVO.getId()))) {
                    StringJoiner projectCodes = new StringJoiner(",");
                    StringJoiner projectNames = new StringJoiner(",");
                    for (EcsRecordsProjectEntity ecsRecordsProjectEntity : projectEntityList) {
                        EcsProjectEntity ecsProjectEntity = projectEntityMap.get(ecsRecordsProjectEntity.getProjectId());
                        if (!ObjectUtil.isNotEmpty((Object)ecsProjectEntity)) continue;
                        projectCodes.add(ecsProjectEntity.getCode());
                        projectNames.add(ecsProjectEntity.getName());
                    }
                    exportModel1.setProjectCodes(projectCodes.toString());
                    exportModel1.setProjectNames(projectNames.toString());
                }
                String applicantInfo = ecsRecordsInfoVO.getApplicantInfo();
                String creatorUserInfo = ecsRecordsInfoVO.getCreatorUserInfo();
                if (StringUtils.isNotEmpty((String)creatorUserInfo)) {
                    jsonObject = JSONUtil.parseObj((String)creatorUserInfo);
                    id = jsonObject.getStr((Object)"id");
                    userEntity = userEntityMap.get(id);
                    exportModel1.setSubmitterCode(userEntity.getCode());
                    exportModel1.setSubmitterName(jsonObject.getStr((Object)"name"));
                    exportModel1.setCreatorDeptName(jsonObject.getStr((Object)"entryDepartmentName"));
                }
                if (StringUtils.isNotEmpty((String)applicantInfo)) {
                    jsonObject = JSONUtil.parseObj((String)applicantInfo);
                    id = jsonObject.getStr((Object)"id");
                    userEntity = userEntityMap.get(id);
                    exportModel1.setReimbCode(userEntity.getCode());
                    exportModel1.setReimbName(jsonObject.getStr((Object)"name"));
                }
                if (ObjectUtil.isNotEmpty((Object)(company = companyEntityMap.get(ecsRecordsInfoVO.getReimbCompany())))) {
                    exportModel1.setCompanyCode(company.getTaxId());
                    exportModel1.setCompanyName(company.getName());
                }
                exportModel1.setAuditStatusName((enumByCode = RecordAuditEnum.getEnumByCode(exportModel1.getAuditStatus())) == null ? "" : enumByCode.getDesc());
                RecordReviewStatusEnum enumByCode1 = RecordReviewStatusEnum.getEnumByCode(exportModel1.getReviewStatus());
                exportModel1.setReviewStatusName(enumByCode1 == null ? "" : enumByCode1.getDesc());
                exportModel1.setInvoiceAmount(ecsRecordsInfoVO.getInvoiceAmount() == null ? null : df.format(ecsRecordsInfoVO.getInvoiceAmount().setScale(2, RoundingMode.HALF_UP)));
                exportModel1.setReimbAmount(ecsRecordsInfoVO.getReimbAmount() == null ? null : df.format(ecsRecordsInfoVO.getReimbAmount().setScale(2, RoundingMode.HALF_UP)));
                exportModel1.setPayAmount(ecsRecordsInfoVO.getPayAmount() == null ? null : df.format(ecsRecordsInfoVO.getPayAmount().setScale(2, RoundingMode.HALF_UP)));
                exportModelList.add(exportModel1);
            }
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(exportModelList, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        return this.creatModelExcel(mapList, keys, userInfo, "\u62a5\u9500\u8bb0\u5f55");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadVO creatModelExcel(List<Map<String, Object>> list, String[] keys, UserInfo userInfo, String appendStr) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        String[] stringArray = keys;
        int n = stringArray.length;
        block74: for (int i = 0; i < n; ++i) {
            String key;
            switch (key = stringArray[i]) {
                case "creatorDeptName": {
                    entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u4eba\u90e8\u95e8\u540d\u79f0", (Object)"creatorDeptName", 30));
                    continue block74;
                }
                case "auditStatus": {
                    entitys.add(new ExcelExportEntity("\u5ba1\u6279\u72b6\u6001", (Object)"auditStatusName", 20));
                    continue block74;
                }
                case "recordType": {
                    entitys.add(new ExcelExportEntity("\u5355\u636e\u6a21\u677f\u540d\u79f0", (Object)"recordType", 20));
                    continue block74;
                }
                case "orderNumber": {
                    entitys.add(new ExcelExportEntity("\u5355\u53f7", (Object)"orderNumber", 20));
                    continue block74;
                }
                case "title": {
                    entitys.add(new ExcelExportEntity("\u6807\u9898", (Object)"title", 60));
                    continue block74;
                }
                case "submitterCode": {
                    entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u4eba\u7f16\u7801", (Object)"submitterCode", 20));
                    continue block74;
                }
                case "submitterName": {
                    entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u4eba\u540d\u79f0", (Object)"submitterName", 20));
                    continue block74;
                }
                case "creatorTime": {
                    entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u65e5\u671f", (Object)"creatorTime", 20));
                    continue block74;
                }
                case "reimbCode": {
                    entitys.add(new ExcelExportEntity("\u62a5\u9500\u4eba\u7f16\u7801", (Object)"reimbCode", 20));
                    continue block74;
                }
                case "reimbName": {
                    entitys.add(new ExcelExportEntity("\u62a5\u9500\u4eba\u540d\u79f0", (Object)"reimbName", 20));
                    continue block74;
                }
                case "organizationName": {
                    entitys.add(new ExcelExportEntity("\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u540d\u79f0", (Object)"organizationName", 20));
                    continue block74;
                }
                case "reimbAmount": {
                    entitys.add(new ExcelExportEntity("\u62a5\u9500\u91d1\u989d", (Object)"reimbAmount", 20));
                    continue block74;
                }
                case "reimbTime": {
                    entitys.add(new ExcelExportEntity("\u62a5\u9500\u65e5\u671f", (Object)"creatorTime", 20));
                    continue block74;
                }
                case "payableAmount": {
                    entitys.add(new ExcelExportEntity("\u5e94\u652f\u4ed8\u91d1\u989d", (Object)"payableAmount", 20));
                    continue block74;
                }
                case "payAmount": {
                    entitys.add(new ExcelExportEntity("\u5df2\u652f\u4ed8\u91d1\u989d", (Object)"payAmount", 20));
                    continue block74;
                }
                case "receivingAccount": {
                    entitys.add(new ExcelExportEntity("\u6536\u6b3e\u5e10\u53f7", (Object)"receivingAccount", 30));
                    continue block74;
                }
                case "accountName": {
                    entitys.add(new ExcelExportEntity("\u6237\u540d", (Object)"accountName", 20));
                    continue block74;
                }
                case "bankName": {
                    entitys.add(new ExcelExportEntity("\u5f00\u6237\u884c", (Object)"bankName", 20));
                    continue block74;
                }
                case "bankBranch": {
                    entitys.add(new ExcelExportEntity("\u5f00\u6237\u7f51\u70b9", (Object)"bankBranch", 50));
                    continue block74;
                }
                case "accountType": {
                    entitys.add(new ExcelExportEntity("\u8d26\u6237\u7c7b\u578b", (Object)"accountType", 20));
                    continue block74;
                }
                case "projectCodes": {
                    entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u7801", (Object)"projectCodes", 40));
                    continue block74;
                }
                case "projectNames": {
                    entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectNames", 40));
                    continue block74;
                }
                case "invoiceAmount": {
                    entitys.add(new ExcelExportEntity("\u53d1\u7968\u91d1\u989d", (Object)"invoiceAmount", 20));
                    continue block74;
                }
                case "taxAmount": {
                    entitys.add(new ExcelExportEntity("\u7a0e\u989d", (Object)"taxAmount", 20));
                    continue block74;
                }
                case "companyCode": {
                    entitys.add(new ExcelExportEntity("\u5355\u4f4d\u540d\u79f0\u7f16\u7801", (Object)"companyCode", 30));
                    continue block74;
                }
                case "companyName": {
                    entitys.add(new ExcelExportEntity("\u5355\u4f4d\u540d\u79f0\u540d\u79f0", (Object)"companyName", 50));
                    continue block74;
                }
                case "reviewStatus": {
                    entitys.add(new ExcelExportEntity("\u590d\u6838\u72b6\u6001", (Object)"reviewStatusName", 20));
                    continue block74;
                }
                case "submitReviewUserName": {
                    entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u590d\u6838\u4eba", (Object)"submitReviewUserName", 20));
                    continue block74;
                }
                case "submitReviewTime": {
                    entitys.add(new ExcelExportEntity("\u63d0\u4ea4\u590d\u6838\u65f6\u95f4", (Object)"submitReviewTime", 20));
                    continue block74;
                }
                case "reviewUserName": {
                    entitys.add(new ExcelExportEntity("\u590d\u6838\u4eba", (Object)"reviewUserName", 20));
                    continue block74;
                }
                case "reviewTime": {
                    entitys.add(new ExcelExportEntity("\u590d\u6838\u65f6\u95f4", (Object)"reviewTime", 20));
                    continue block74;
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = appendStr + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Throwable)e);
        }
        return vo;
    }

    @Override
    public void batchReview(List<String> ids) {
        UserInfo userInfo = this.userProvider.get();
        List list = this.listByIds(ids);
        ArrayList<EcsRecordsEntity> needUpdateList = new ArrayList<EcsRecordsEntity>();
        for (EcsRecordsEntity entity : list) {
            if (!Objects.equals(entity.getReviewStatus(), RecordReviewStatusEnum.SUBMITTED.getCode())) continue;
            this.processEntity(entity, userInfo, needUpdateList);
        }
        if (CollUtil.isNotEmpty(needUpdateList)) {
            this.updateBatchById(needUpdateList);
        }
    }

    private void processEntity(EcsRecordsEntity entity, UserInfo userInfo, List<EcsRecordsEntity> needUpdateList) {
        String payAccount = entity.getPayAccount();
        EcsCompanyAccountEntity accountEntity = (EcsCompanyAccountEntity)this.companyAccountService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getAccount, (Object)payAccount)).eq(EcsCompanyAccountEntity::getCompanyId, (Object)entity.getReimbCompany()));
        EcsRecordsEntity newEntity = this.createNewEntity(entity, userInfo);
        if (entity.getPayableAmount().compareTo(BigDecimal.ZERO) == 0) {
            this.handlePaidCase(newEntity, entity, needUpdateList);
        } else {
            this.handleUnpaidCase(newEntity, entity, accountEntity, needUpdateList);
        }
    }

    private void handleUnpaidCase(EcsRecordsEntity newEntity, EcsRecordsEntity originalEntity, EcsCompanyAccountEntity accountEntity, List<EcsRecordsEntity> needUpdateList) {
        if ("1".equals(accountEntity.getIsZl())) {
            this.processCashierPayment(newEntity, originalEntity, needUpdateList);
        } else {
            this.handlePaidCase(newEntity, originalEntity, needUpdateList);
        }
    }

    private void handlePaidCase(EcsRecordsEntity newEntity, EcsRecordsEntity originalEntity, List<EcsRecordsEntity> needUpdateList) {
        newEntity.setAuditStatus(RecordAuditEnum.PAID.getCode());
        needUpdateList.add(newEntity);
        this.sendAuditMessage(originalEntity);
    }

    private void processCashierPayment(EcsRecordsEntity newEntity, EcsRecordsEntity originalEntity, List<EcsRecordsEntity> needUpdateList) {
        PaymentVO paymentInfo = this.getPaymentInfo(originalEntity.getId());
        ActionResult<?> actionResult = this.skPaymentService.singlePayment(paymentInfo);
        if (actionResult.getCode() == 200) {
            needUpdateList.add(newEntity);
            this.sendCashierMessage(needUpdateList);
        }
    }

    private EcsRecordsEntity createNewEntity(EcsRecordsEntity entity, UserInfo userInfo) {
        EcsRecordsEntity newEntity = new EcsRecordsEntity();
        newEntity.setId(entity.getId());
        newEntity.setReviewStatus(RecordReviewStatusEnum.REVIEWED.getCode());
        newEntity.setReviewTime(new Date());
        newEntity.setReimbCompany(entity.getReimbCompany());
        newEntity.setReviewUserId(userInfo.getUserId());
        newEntity.setReimbCompany(entity.getReimbCompany());
        newEntity.setReviewUserName(userInfo.getRealName());
        newEntity.setPayAmount(entity.getPayableAmount());
        return newEntity;
    }

    private void sendCashierMessage(List<EcsRecordsEntity> needUpdateList) {
        String title = String.format("\u60a8\u6709%d\u7b14\u5f85\u4ed8\u6b3e\u7684\u62a5\u9500\u5355\u5f85\u5904\u7406", needUpdateList.size());
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> userIds = this.getUserIdsByReimbCompany(needUpdateList.get(0), "1");
        this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_3.getCode(), userIds, title, null, map, "\u4ed8\u6b3e");
    }

    private void sendAuditMessage(EcsRecordsEntity entity) {
        String creatorUserName = this.baseDataUtil.userSelectValue(entity.getCreatorUserId());
        this.ecsMessageService.sendAuditMessage(entity.getId(), entity.getUserId(), creatorUserName, () -> creatorUserName + "\u63d0\u4ea4\u7684\u300c" + entity.getTitle() + "\u300d" + entity.getRecordType() + "\u62a5\u9500\u5df2\u4ed8\u6b3e\u5b8c\u6bd5", () -> creatorUserName + "\u63d0\u4ea4\u7684\u300c" + entity.getTitle() + "\u300d" + entity.getRecordType() + "\u62a5\u9500\u5df2\u4ed8\u6b3e\u5b8c\u6bd5, \u5355\u53f7\uff1a" + entity.getOrderNumber());
    }

    @Override
    public ActionResult<?> batchReviewPayment(EcsRecordsPaymentVO paymentVO) {
        EcsRecordsEntity ecsRecordsEntity;
        EcsCompanyEntity companyEntity;
        if (StrUtil.isEmpty((CharSequence)paymentVO.getPayAccount())) {
            return ActionResult.fail((String)"\u4ed8\u6b3e\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)paymentVO.getBankPscpt())) {
            return ActionResult.fail((String)"\u94f6\u884c\u9644\u8a00\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> ids = paymentVO.getRecords();
        List list = this.listByIds(ids);
        UserInfo userInfo = this.userProvider.get();
        String userId = userInfo.getUserId();
        String userName = userInfo.getRealName();
        ArrayList entityList = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)list) && (StrUtil.isEmpty((CharSequence)(companyEntity = this.ecsCompanyService.getInfo((ecsRecordsEntity = (EcsRecordsEntity)list.get(0)).getReimbCompany())).getCashierRole()) || StrUtil.isEmpty((CharSequence)companyEntity.getPaymentRole()))) {
            return ActionResult.fail((String)(companyEntity.getName() + "\u672a\u8bbe\u7f6e\u51fa\u7eb3\u5ba1\u6838\u6216\u8005\u4ed8\u6b3e\u590d\u6838\u4eba!"));
        }
        list.iterator().forEachRemaining(entity -> {
            EcsRecordsEntity newEntity = new EcsRecordsEntity();
            newEntity.setId(entity.getId());
            newEntity.setReviewStatus(RecordReviewStatusEnum.SUBMITTED.getCode());
            newEntity.setAuditStatus(RecordAuditEnum.PAYMENT_IN.getCode());
            newEntity.setPayAccount(paymentVO.getPayAccount());
            newEntity.setPayRemark(paymentVO.getPayRemark());
            newEntity.setBankPscpt(paymentVO.getBankPscpt());
            newEntity.setSubmitReviewTime(new Date());
            newEntity.setReimbCompany(entity.getReimbCompany());
            newEntity.setSubmitReviewUserId(userId);
            newEntity.setSubmitReviewUserName(userName);
            entityList.add(newEntity);
        });
        if (!entityList.isEmpty()) {
            String title = String.format("\u60a8\u6709%d\u7b14\u5f85\u4ed8\u6b3e\u590d\u6838\u7684\u62a5\u9500\u5355\u5f85\u5904\u7406", entityList.size());
            HashMap<String, String> map = new HashMap<String, String>();
            List<String> userIds = this.getUserIdsByReimbCompany((EcsRecordsEntity)entityList.get(0), "2");
            this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_2.getCode(), userIds, title, null, map, "\u4ed8\u6b3e\u590d\u6838");
            this.updateBatchById(entityList);
        }
        return ActionResult.success((String)"\u590d\u6838\u6210\u529f");
    }

    @Override
    public List<String> getUserIdsByReimbCompany(EcsRecordsEntity entity, String type) {
        String reimbCompany = entity.getReimbCompany();
        EcsCompanyEntity companyEntity = this.ecsCompanyService.getInfo(reimbCompany);
        String paymentRole = companyEntity.getPaymentRole();
        String cashierRole = companyEntity.getCashierRole();
        String roleToUse = "";
        if ("1".equals(type)) {
            roleToUse = companyEntity.getCashierRole();
        } else if ("2".equals(type)) {
            roleToUse = companyEntity.getPaymentRole();
        }
        if (StrUtil.isNotBlank((CharSequence)roleToUse)) {
            List data = this.userRelationService.getListByObjectId(roleToUse);
            return data.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void refreshPayStateOrReceipt() {
        this.paymentTask.checkPayStatusTask();
    }

    @Override
    public PaymentVO getPaymentInfo(String id) {
        EcsRecordsEntity recordsEntity = this.getInfo(id);
        EcsBankCardEntity bankCardEntity = this.bankCardService.getInfo(recordsEntity.getBankCardId());
        EcsCompanyAccountEntity accountEntity = (EcsCompanyAccountEntity)this.companyAccountService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getAccount, (Object)recordsEntity.getPayAccount())).eq(EcsCompanyAccountEntity::getCompanyId, (Object)recordsEntity.getReimbCompany()));
        PaymentVO vo = new PaymentVO();
        vo.setEncode("EcsRecordsServiceImpl");
        vo.setSourceModule("ECS_REIMB");
        vo.setSourceId(id);
        vo.setSourceCode(recordsEntity.getOrderNumber());
        vo.setTitle(recordsEntity.getTitle());
        vo.setPypartyAccnum(recordsEntity.getPayAccount());
        vo.setRcvpyAccnum(bankCardEntity.getCardNumber().replaceAll("\\s+", ""));
        vo.setRcvpyAccnm(bankCardEntity.getUsername());
        vo.setBankFirmCode(bankCardEntity.getBankFirmCode());
        vo.setPyAccTp(bankCardEntity.getAccountType());
        vo.setAmt(recordsEntity.getPayableAmount().setScale(2, RoundingMode.HALF_UP));
        String pscpt = accountEntity.getOpenBank().contains("\u6c11\u751f\u94f6\u884c") ? "386" : (StrUtil.isNotBlank((CharSequence)recordsEntity.getBankPscpt()) ? recordsEntity.getBankPscpt() : recordsEntity.getTitle());
        vo.setPscpt(pscpt);
        return vo;
    }

    @Override
    public void updatePaymentStateById(String id) {
        EcsRecordsEntity entity = this.getInfo(id);
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(EcsRecordsEntity::getId, (Object)id)).set(EcsRecordsEntity::getAuditStatus, (Object)RecordAuditEnum.PAID.getCode()));
        String creatorUserName = this.baseDataUtil.userSelectValue(entity.getCreatorUserId());
        this.ecsMessageService.sendAuditMessage(entity.getId(), entity.getUserId(), creatorUserName, () -> creatorUserName + "\u63d0\u4ea4\u7684\u300c" + entity.getTitle() + "\u300d" + entity.getRecordType() + "\u62a5\u9500\u5df2\u4ed8\u6b3e\u5b8c\u6bd5", () -> creatorUserName + "\u63d0\u4ea4\u7684\u300c" + entity.getTitle() + "\u300d" + entity.getRecordType() + "\u62a5\u9500\u5df2\u4ed8\u6b3e\u5b8c\u6bd5, \u5355\u53f7\uff1a" + entity.getOrderNumber());
    }

    @Override
    public void batchVoucher(List<String> ids) {
        List recordsEntities = this.listByIds(ids);
        recordsEntities.forEach(record -> {
            boolean voucher = false;
            try {
                voucher = this.voucherPushService.pushVoucher(record.getId());
                if (voucher) {
                    String voucherNum = this.voucherPushService.getVoucherNum(record.getId());
                    record.setCostVoucherStatus(VoucherPushStateEnum.SUCCESS.getCode());
                    record.setCostVoucherTime(new Date());
                    record.setCostVoucherNum(voucherNum);
                } else {
                    record.setCostVoucherStatus(VoucherPushStateEnum.FAIL.getCode());
                    record.setCostVoucherTime(new Date());
                }
            }
            catch (VoucherPushException voucherPushException) {
                // empty catch block
            }
            record.setAuditStatus(RecordAuditEnum.WAITING_PAYMENT.getCode());
        });
        this.updateBatchById(recordsEntities);
        String title = String.format("\u60a8\u6709%d\u7b14\u5f85\u63d0\u4ea4\u590d\u6838\u7684\u62a5\u9500\u5355\u5f85\u5904\u7406", recordsEntities.size());
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> userIds = this.getUserIdsByReimbCompany((EcsRecordsEntity)recordsEntities.get(0), "1");
        this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_1.getCode(), userIds, title, null, map, "\u63d0\u4ea4\u590d\u6838");
    }
}

