/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBaseEntity;
import com.bringspring.ecs.entity.EcsReimbStandardEntity;
import com.bringspring.ecs.entity.EcsReimbStandardRelationEntity;
import com.bringspring.ecs.enums.EnableMarkEnum;
import com.bringspring.ecs.enums.StandardTypeEnum;
import com.bringspring.ecs.mapper.EcsReimbStandardMapper;
import com.bringspring.ecs.model.standard.EcsReimbStandardCrForm;
import com.bringspring.ecs.model.standard.EcsReimbStandardInfoVO;
import com.bringspring.ecs.model.standard.EcsReimbStandardPagination;
import com.bringspring.ecs.model.standard.EcsReimbStandardUpForm;
import com.bringspring.ecs.service.EcsReimbStandardRelationService;
import com.bringspring.ecs.service.EcsReimbStandardService;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EcsReimbStandardServiceImpl
extends ServiceImpl<EcsReimbStandardMapper, EcsReimbStandardEntity>
implements EcsReimbStandardService {
    private static final Logger log = LoggerFactory.getLogger(EcsReimbStandardServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsReimbStandardRelationService relationService;
    @Autowired
    private ProvinceService provinceService;

    @Override
    public List<EcsReimbStandardEntity> getList(EcsReimbStandardPagination ecsReimbStandardPagination) {
        return this.getTypeList(ecsReimbStandardPagination, "0");
    }

    @Override
    public List<EcsReimbStandardEntity> getTypeList(EcsReimbStandardPagination pagination, String dataType) {
        List<String> ids;
        Object object;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_reimb_standard"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsReimbStandardEntity>();
            }
            queryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_reimb_standard"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsReimbStandardEntity>();
            }
            queryWrapper = (QueryWrapper)object;
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsReimbStandardEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark())).eq(StringUtils.isNotBlank((CharSequence)pagination.getStandardType()), EcsReimbStandardEntity::getStandardType, (Object)pagination.getStandardType())).in(StringUtils.isNotBlank((CharSequence)pagination.getCompanyId()), EcsReimbStandardEntity::getCompanyId, new Object[]{pagination.getCompanyId()});
        List<String> allIdList = null;
        if (StringUtils.isNotBlank((CharSequence)pagination.getEmployeeLevel())) {
            allIdList = this.relationService.getRelationListByObjectId(pagination.getEmployeeLevel(), StandardTypeEnum.EMPLOYEE_LEVEL);
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getCityLevel())) {
            ids = this.relationService.getRelationListByObjectId(pagination.getCityLevel(), StandardTypeEnum.CITY_LEVEL);
            allIdList = allIdList == null ? ids : new ArrayList<String>(CollUtil.intersection(allIdList, ids));
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getOrganizationId())) {
            ids = this.relationService.getRelationListByObjectId(pagination.getOrganizationId(), StandardTypeEnum.ORGANIZATION);
            if (allIdList == null) {
                allIdList = ids;
            } else if (!allIdList.isEmpty() && !ids.isEmpty()) {
                allIdList = new ArrayList<String>(CollUtil.intersection(allIdList, ids));
            }
        }
        if (allIdList != null && !allIdList.isEmpty()) {
            queryWrapper.lambda().in(EcsReimbStandardEntity::getId, allIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(EcsReimbStandardEntity::getId);
        } else {
            try {
                String sidx = pagination.getSidx();
                EcsReimbStandardEntity ecsReimbStandardEntity = new EcsReimbStandardEntity();
                Field declaredField = ecsReimbStandardEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equalsIgnoreCase(pagination.getSort()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                log.error("\u67e5\u8be2\u5217\u8868\u9519\u8bef\uff0c\u6ca1\u6709\u8be5\u5b57\u6bb5", (Throwable)e);
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public EcsReimbStandardInfoVO getInfo(String id) throws DataException {
        EcsReimbStandardEntity entity = (EcsReimbStandardEntity)this.getById((Serializable)((Object)id));
        if (entity == null) {
            throw new DataException("\u62a5\u9500\u6807\u51c6\u4e0d\u5b58\u5728");
        }
        EcsReimbStandardInfoVO infoVO = (EcsReimbStandardInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsReimbStandardInfoVO.class);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EcsReimbStandardRelationEntity::getStandardId, (Object)id);
        List relationEntities = this.relationService.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)relationEntities)) {
            Map<String, List<EcsReimbStandardRelationEntity>> relationMap = relationEntities.stream().collect(Collectors.groupingBy(EcsReimbStandardRelationEntity::getObjectType));
            List organizationList = relationMap.getOrDefault(StandardTypeEnum.ORGANIZATION.getRelationType(), new ArrayList());
            List employeeLevelList = relationMap.getOrDefault(StandardTypeEnum.EMPLOYEE_LEVEL.getRelationType(), new ArrayList());
            List employeeList = relationMap.getOrDefault(StandardTypeEnum.EMPLOYEE.getRelationType(), new ArrayList());
            List cityLevelList = relationMap.getOrDefault(StandardTypeEnum.CITY_LEVEL.getRelationType(), new ArrayList());
            List provinceList = relationMap.getOrDefault(StandardTypeEnum.PROVINCE.getRelationType(), new ArrayList());
            infoVO.setOrganizationId(JsonUtil.getObjectToString(organizationList.stream().map(EcsReimbStandardRelationEntity::getObjectId).collect(Collectors.toList())));
            infoVO.setEmployeeLevel(JsonUtil.getObjectToString(employeeLevelList.stream().map(EcsReimbStandardRelationEntity::getObjectId).collect(Collectors.toList())));
            infoVO.setEmployee(JsonUtil.getObjectToString(employeeList.stream().map(EcsReimbStandardRelationEntity::getObjectId).collect(Collectors.toList())));
            infoVO.setCityLevel(((EcsReimbStandardRelationEntity)cityLevelList.get(0)).getObjectId());
            if (CollUtil.isNotEmpty((Collection)provinceList)) {
                List provinceListStr = provinceList.stream().map(EcsReimbStandardRelationEntity::getObjectId).collect(Collectors.toList());
                ArrayList<List> provinceListList = new ArrayList<List>();
                for (String provinceId : provinceListStr) {
                    List jsonToList = JsonUtil.getJsonToList((String)provinceId, String.class);
                    provinceListList.add(jsonToList);
                }
                infoVO.setProvince(JsonUtil.getObjectToString(provinceListList));
            }
        }
        return infoVO;
    }

    @Override
    public EcsReimbStandardInfoVO getStandard(EcsReimbStandardInfoVO info) throws DataException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{info.getProvince()})) {
            throw new DataException("\u6570\u636e\u9519\u8bef\uff0c\u7f3a\u5c11\u5fc5\u8981\u6761\u4ef6");
        }
        String cityLevel = this.getCityLevelByProvince(info.getProvince());
        if ("-1".equals(cityLevel)) {
            throw new DataException("\u57ce\u5e02\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        List<String> idsByCompanyId = this.getIdsByCompanyId(info.getCompanyId());
        String searchProvince = ",\"" + info.getProvince() + "\"]";
        List<String> idsByProvince = this.relationService.likeRelationListByObjectId(searchProvince, StandardTypeEnum.PROVINCE);
        List<String> idsByEmployeeLevel = this.relationService.getRelationListByObjectId(info.getEmployeeLevel(), StandardTypeEnum.EMPLOYEE_LEVEL);
        List<String> idsByEmployee = this.relationService.getRelationListByObjectId(info.getEmployee(), StandardTypeEnum.EMPLOYEE);
        List<String> idsByOrganization = this.relationService.getRelationListByObjectId(info.getOrganizationId(), StandardTypeEnum.ORGANIZATION);
        EcsReimbStandardEntity maxSortEntity = this.getMaxSortEntity(CollUtil.intersection(idsByProvince, idsByEmployee, (Collection[])new Collection[]{idsByCompanyId}), CollUtil.intersection(idsByEmployeeLevel, idsByProvince, (Collection[])new Collection[]{idsByOrganization, idsByCompanyId}), CollUtil.intersection(idsByProvince, idsByOrganization, (Collection[])new Collection[]{idsByCompanyId}), CollUtil.intersection(idsByEmployeeLevel, idsByProvince, (Collection[])new Collection[]{idsByCompanyId}));
        if (maxSortEntity == null) {
            ProvinceEntity province = (ProvinceEntity)this.provinceService.getById((Serializable)((Object)info.getProvince()));
            if (province == null) {
                throw new DataException("\u57ce\u5e02\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            searchProvince = ",\"" + province.getParentId() + "\"]";
            idsByProvince = this.relationService.likeRelationListByObjectId(searchProvince, StandardTypeEnum.PROVINCE);
            maxSortEntity = this.getMaxSortEntity(CollUtil.intersection(idsByProvince, idsByEmployee, (Collection[])new Collection[]{idsByCompanyId}), CollUtil.intersection(idsByEmployeeLevel, idsByProvince, (Collection[])new Collection[]{idsByOrganization, idsByCompanyId}), CollUtil.intersection(idsByProvince, idsByOrganization, (Collection[])new Collection[]{idsByCompanyId}), CollUtil.intersection(idsByEmployeeLevel, idsByProvince, (Collection[])new Collection[]{idsByCompanyId}));
        }
        if (maxSortEntity != null) {
            return (EcsReimbStandardInfoVO)JsonUtil.getJsonToBean((Object)maxSortEntity, EcsReimbStandardInfoVO.class);
        }
        throw new DataException("\u901a\u7528\u6807\u51c6\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @SafeVarargs
    private final EcsReimbStandardEntity getMaxSortEntity(Collection<String> ... collections) {
        List<Collection> nonEmptyCollections = Arrays.stream(collections).filter(collection -> collection != null && !collection.isEmpty()).collect(Collectors.toList());
        if (nonEmptyCollections.isEmpty()) {
            return null;
        }
        String firstId = (String)((Collection)nonEmptyCollections.get(0)).iterator().next();
        HashSet allIds = new HashSet();
        nonEmptyCollections.forEach(allIds::addAll);
        List standards = this.listByIds(allIds);
        if (CollUtil.isEmpty((Collection)standards)) {
            return null;
        }
        Optional<EcsReimbStandardEntity> maxStandard = standards.stream().max(Comparator.comparing(s -> Optional.ofNullable(s.getSort()).orElse(0)));
        if (maxStandard.isPresent()) {
            boolean allSameSort = standards.stream().allMatch(s -> Objects.equals(s.getSort(), ((EcsReimbStandardEntity)maxStandard.get()).getSort()));
            return allSameSort ? (EcsReimbStandardEntity)this.getById((Serializable)((Object)firstId)) : maxStandard.get();
        }
        return (EcsReimbStandardEntity)this.getById((Serializable)((Object)firstId));
    }

    @Override
    public void create(EcsReimbStandardCrForm ecsReimbStandardCrForm) {
        UserInfo userInfo = this.userProvider.get();
        String mainId = RandomUtil.uuId();
        EcsReimbStandardEntity entity = (EcsReimbStandardEntity)JsonUtil.getJsonToBean((Object)ecsReimbStandardCrForm, EcsReimbStandardEntity.class);
        entity.setId(mainId);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(new Date());
        entity.setEnabledMark(EnableMarkEnum.NORMAL.getEnableMark());
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        List<EcsReimbStandardRelationEntity> needSaveToDb = this.addMatchRelationData(mainId, userInfo, ecsReimbStandardCrForm.getOrganizationId(), ecsReimbStandardCrForm.getEmployeeLevel(), ecsReimbStandardCrForm.getCityLevel(), ecsReimbStandardCrForm.getProvince(), ecsReimbStandardCrForm.getEmployee());
        this.save(entity);
        if (!CollectionUtils.isEmpty(needSaveToDb)) {
            this.relationService.saveBatch(needSaveToDb);
        }
    }

    private List<EcsReimbStandardRelationEntity> addMatchRelationData(String mainId, UserInfo userInfo, String organizationId, String employeeLevel, String cityLevel, String province, String employee) {
        ArrayList<EcsReimbStandardRelationEntity> needSaveToDb = new ArrayList<EcsReimbStandardRelationEntity>();
        if (StringUtils.isNotBlank((CharSequence)organizationId)) {
            List organizationIdList = JsonUtil.getJsonToList((String)organizationId, String.class);
            this.createRelationEntity(userInfo, mainId, needSaveToDb, organizationIdList, StandardTypeEnum.ORGANIZATION.getRelationType());
        }
        List employeeLevelList = JsonUtil.getJsonToList((String)employeeLevel, String.class);
        this.createRelationEntity(userInfo, mainId, needSaveToDb, employeeLevelList, StandardTypeEnum.EMPLOYEE_LEVEL.getRelationType());
        if (StringUtils.isNotBlank((CharSequence)employee)) {
            List employeeList = JsonUtil.getJsonToList((String)employee, String.class);
            this.createRelationEntity(userInfo, mainId, needSaveToDb, employeeList, StandardTypeEnum.EMPLOYEE.getRelationType());
        }
        ArrayList cityLevelList = Lists.newArrayList((Object[])new String[]{cityLevel});
        this.createRelationEntity(userInfo, mainId, needSaveToDb, cityLevelList, StandardTypeEnum.CITY_LEVEL.getRelationType());
        if (StringUtils.isNotBlank((CharSequence)province)) {
            ArrayList<String> provinceList = new ArrayList<String>();
            List provinceListStr = JsonUtil.getJsonToList((String)province, String.class);
            for (String provinceId : provinceListStr) {
                List jsonToList = JsonUtil.getJsonToList((String)provinceId, String.class);
                provinceList.add(JsonUtil.getObjectToString((Object)jsonToList));
            }
            if (CollUtil.isNotEmpty(provinceList)) {
                this.createRelationEntity(userInfo, mainId, needSaveToDb, provinceList, StandardTypeEnum.PROVINCE.getRelationType());
            }
        }
        return needSaveToDb;
    }

    private void createRelationEntity(UserInfo userInfo, String mainId, List<EcsReimbStandardRelationEntity> needSaveToDb, List<String> objectIds, String type) {
        if (CollectionUtils.isEmpty(objectIds) || StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        objectIds.forEach(objectId -> {
            EcsReimbStandardRelationEntity relationEntity = new EcsReimbStandardRelationEntity();
            relationEntity.setId(RandomUtil.uuId());
            relationEntity.setStandardId(mainId);
            relationEntity.setObjectType(type);
            relationEntity.setObjectId((String)objectId);
            relationEntity.setCreatorTime(new Date());
            relationEntity.setCreatorUserId(userInfo.getUserId());
            needSaveToDb.add(relationEntity);
        });
    }

    @Override
    public void update(String id, EcsReimbStandardUpForm ecsReimbStandardUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        EcsReimbStandardEntity entity = (EcsReimbStandardEntity)this.getById((Serializable)((Object)id));
        if (entity == null) {
            throw new DataException("\u62a5\u9500\u6807\u51c6\u4e0d\u5b58\u5728");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EcsReimbStandardRelationEntity::getStandardId, (Object)id);
        this.relationService.remove((Wrapper)queryWrapper);
        EcsReimbStandardEntity updateEntity = (EcsReimbStandardEntity)JsonUtil.getJsonToBean((Object)ecsReimbStandardUpForm, EcsReimbStandardEntity.class);
        updateEntity.setId(id);
        List<EcsReimbStandardRelationEntity> needSaveToDb = this.addMatchRelationData(id, userInfo, ecsReimbStandardUpForm.getOrganizationId(), ecsReimbStandardUpForm.getEmployeeLevel(), ecsReimbStandardUpForm.getCityLevel(), ecsReimbStandardUpForm.getProvince(), ecsReimbStandardUpForm.getEmployee());
        this.updateById(updateEntity);
        if (!CollectionUtils.isEmpty(needSaveToDb)) {
            this.relationService.saveBatch(needSaveToDb);
        }
    }

    @Override
    public void delete(EcsReimbStandardEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(EcsReimbStandardRelationEntity::getStandardId, (Object)entity.getId());
            this.relationService.remove((Wrapper)queryWrapper);
        }
    }

    private String getCityLevelByProvince(String provinceId) {
        if (StringUtils.isBlank((CharSequence)provinceId)) {
            return "-1";
        }
        try {
            ProvinceEntity province = (ProvinceEntity)this.provinceService.getById((Serializable)((Object)provinceId));
            if (province == null) {
                return "-1";
            }
            return province.getCityLevel().toString();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u57ce\u5e02\u7b49\u7ea7\u9519\u8bef", (Throwable)e);
            return "-1";
        }
    }

    private List<String> getIdsByCompanyId(String companyId) {
        if (StringUtils.isBlank((CharSequence)companyId)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.select(new SFunction[]{EcsReimbStandardEntity::getId}).eq(EcsReimbStandardEntity::getCompanyId, (Object)companyId)).eq(EcsReimbStandardEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark())).eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        List list = this.list((Wrapper)queryWrapper);
        return list.stream().map(EcsReimbStandardEntity::getId).collect(Collectors.toList());
    }

    @Override
    public List<EcsReimbStandardRelationEntity> getRelationList(String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EcsReimbStandardRelationEntity::getStandardId, (Object)id);
        return this.relationService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<EcsReimbStandardRelationEntity> getRelationList(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<EcsReimbStandardRelationEntity>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(EcsReimbStandardRelationEntity::getStandardId, ids);
        return this.relationService.list((Wrapper)queryWrapper);
    }
}

