/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsTaxLoanInterestEntity;
import com.bringspring.ecs.entity.EcsTaxLoanInterestRecordsEntity;
import com.bringspring.ecs.mapper.EcsTaxLoanInterestMapper;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestPagination;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestRecordsModel;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestUpForm;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsTaxLoanInterestRecordsService;
import com.bringspring.ecs.service.EcsTaxLoanInterestService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsTaxLoanInterestServiceImpl
extends ServiceImpl<EcsTaxLoanInterestMapper, EcsTaxLoanInterestEntity>
implements EcsTaxLoanInterestService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsTaxLoanInterestRecordsService ecsTaxLoanInterestRecordsService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsCompanyService ecsCompanyService;

    @Override
    public List<EcsTaxLoanInterestEntity> getList(EcsTaxLoanInterestPagination ecsTaxLoanInterestPagination) {
        Object rkMarketLogObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsTaxLoanInterestNum = 0;
        QueryWrapper ecsTaxLoanInterestQueryWrapper = new QueryWrapper();
        boolean ecsTaxLoanInterestRecordsNum = false;
        QueryWrapper ecsTaxLoanInterestRecordsQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsTaxLoanInterestQueryWrapper, ecsTaxLoanInterestPagination.getMenuId(), "ecs_tax_loan_interest"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<EcsTaxLoanInterestEntity>();
            }
            ecsTaxLoanInterestQueryWrapper = (QueryWrapper)rkMarketLogObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsTaxLoanInterestQueryWrapper, ecsTaxLoanInterestPagination.getMenuId(), "ecs_tax_loan_interest"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<EcsTaxLoanInterestEntity>();
            }
            ecsTaxLoanInterestQueryWrapper = (QueryWrapper)rkMarketLogObj;
        }
        if (StringUtils.isNotEmpty((String)ecsTaxLoanInterestPagination.getReimbCompanyName())) {
            ++ecsTaxLoanInterestNum;
            ecsTaxLoanInterestQueryWrapper.lambda().like(EcsTaxLoanInterestEntity::getReimbCompanyName, (Object)ecsTaxLoanInterestPagination.getReimbCompanyName());
        }
        if (StringUtils.isNotEmpty((String)ecsTaxLoanInterestPagination.getTitle())) {
            ++ecsTaxLoanInterestNum;
            ecsTaxLoanInterestQueryWrapper.lambda().like(EcsTaxLoanInterestEntity::getTitle, (Object)ecsTaxLoanInterestPagination.getTitle());
        }
        if (StringUtils.isNotEmpty((String)ecsTaxLoanInterestPagination.getReason())) {
            ++ecsTaxLoanInterestNum;
            ecsTaxLoanInterestQueryWrapper.lambda().like(EcsTaxLoanInterestEntity::getReason, (Object)ecsTaxLoanInterestPagination.getReason());
        }
        if (AllIdList.size() > 0) {
            ecsTaxLoanInterestQueryWrapper.lambda().in(EcsTaxLoanInterestEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsTaxLoanInterestPagination.getSidx())) {
            ecsTaxLoanInterestQueryWrapper.lambda().orderByDesc(EcsTaxLoanInterestEntity::getId);
        } else {
            try {
                String sidx = ecsTaxLoanInterestPagination.getSidx();
                EcsTaxLoanInterestEntity ecsTaxLoanInterestEntity = new EcsTaxLoanInterestEntity();
                Field declaredField = ecsTaxLoanInterestEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsTaxLoanInterestQueryWrapper = "asc".equals(ecsTaxLoanInterestPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsTaxLoanInterestQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsTaxLoanInterestQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ecsTaxLoanInterestPagination.getCurrentPage(), ecsTaxLoanInterestPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsTaxLoanInterestQueryWrapper);
            return ecsTaxLoanInterestPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ecsTaxLoanInterestPagination.setData(list, list.size());
    }

    @Override
    public List<EcsTaxLoanInterestEntity> getTypeList(EcsTaxLoanInterestPagination ecsTaxLoanInterestPagination, String dataType) {
        Object rkMarketLogObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsTaxLoanInterestNum = 0;
        QueryWrapper ecsTaxLoanInterestQueryWrapper = new QueryWrapper();
        boolean ecsTaxLoanInterestRecordsNum = false;
        QueryWrapper ecsTaxLoanInterestRecordsQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsTaxLoanInterestQueryWrapper, ecsTaxLoanInterestPagination.getMenuId(), "ecs_tax_loan_interest"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<EcsTaxLoanInterestEntity>();
            }
            ecsTaxLoanInterestQueryWrapper = (QueryWrapper)rkMarketLogObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsTaxLoanInterestQueryWrapper, ecsTaxLoanInterestPagination.getMenuId(), "ecs_tax_loan_interest"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<EcsTaxLoanInterestEntity>();
            }
            ecsTaxLoanInterestQueryWrapper = (QueryWrapper)rkMarketLogObj;
        }
        if (StringUtils.isNotEmpty((String)ecsTaxLoanInterestPagination.getReimbCompanyName())) {
            ++ecsTaxLoanInterestNum;
            ecsTaxLoanInterestQueryWrapper.lambda().like(EcsTaxLoanInterestEntity::getReimbCompanyName, (Object)ecsTaxLoanInterestPagination.getReimbCompanyName());
        }
        if (StringUtils.isNotEmpty((String)ecsTaxLoanInterestPagination.getTitle())) {
            ++ecsTaxLoanInterestNum;
            ecsTaxLoanInterestQueryWrapper.lambda().like(EcsTaxLoanInterestEntity::getTitle, (Object)ecsTaxLoanInterestPagination.getTitle());
        }
        if (StringUtils.isNotEmpty((String)ecsTaxLoanInterestPagination.getReason())) {
            ++ecsTaxLoanInterestNum;
            ecsTaxLoanInterestQueryWrapper.lambda().like(EcsTaxLoanInterestEntity::getReason, (Object)ecsTaxLoanInterestPagination.getReason());
        }
        if (AllIdList.size() > 0) {
            ecsTaxLoanInterestQueryWrapper.lambda().in(EcsTaxLoanInterestEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsTaxLoanInterestPagination.getSidx())) {
            ecsTaxLoanInterestQueryWrapper.lambda().orderByDesc(EcsTaxLoanInterestEntity::getId);
        } else {
            try {
                String sidx = ecsTaxLoanInterestPagination.getSidx();
                EcsTaxLoanInterestEntity ecsTaxLoanInterestEntity = new EcsTaxLoanInterestEntity();
                Field declaredField = ecsTaxLoanInterestEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsTaxLoanInterestQueryWrapper = "asc".equals(ecsTaxLoanInterestPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsTaxLoanInterestQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsTaxLoanInterestQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ecsTaxLoanInterestPagination.getCurrentPage(), ecsTaxLoanInterestPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ecsTaxLoanInterestQueryWrapper);
                return ecsTaxLoanInterestPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ecsTaxLoanInterestPagination.setData(list, list.size());
        }
        return this.list((Wrapper)ecsTaxLoanInterestQueryWrapper);
    }

    @Override
    public EcsTaxLoanInterestEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsTaxLoanInterestEntity::getId, (Object)id);
        return (EcsTaxLoanInterestEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(EcsTaxLoanInterestEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, EcsTaxLoanInterestEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateFrom(String id, EcsTaxLoanInterestUpForm ecsTaxLoanInterestUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsTaxLoanInterestEntity entity = (EcsTaxLoanInterestEntity)JsonUtil.getJsonToBean((Object)((Object)ecsTaxLoanInterestUpForm), EcsTaxLoanInterestEntity.class);
        entity.setCompanyId(userInfo.getOrganizeId());
        EcsCompanyEntity companyEntity = this.ecsCompanyService.getInfo(entity.getReimbCompanyId());
        if (ObjectUtil.isNotEmpty((Object)companyEntity)) {
            entity.setReimbCompanyName(companyEntity.getName());
        }
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(userInfo.getUserId());
        this.ecsTaxLoanInterestRecordsService.deleteByTaxId(id);
        List<EcsTaxLoanInterestRecordsModel> ecsTaxLoanInterestList = ecsTaxLoanInterestUpForm.getEcsTaxLoanInterestList();
        List jsonToList = JsonUtil.getJsonToList(ecsTaxLoanInterestList, EcsTaxLoanInterestRecordsEntity.class);
        jsonToList.stream().forEach(interest -> {
            interest.setId(RandomUtil.uuId());
            interest.setTaxLoanInterestId(entity.getId());
            interest.setTaxTypeName(this.baseDataUtil.getDictName(interest.getTaxTypeCode(), "taxTypes"));
            interest.setCreatorUserId(userInfo.getUserId());
            interest.setCreatorTime(new Date());
        });
        this.ecsTaxLoanInterestRecordsService.saveBatch(jsonToList);
        return this.updateById(entity);
    }

    @Override
    public void delete(EcsTaxLoanInterestEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

