/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.config;

import com.bringspring.ecs.strategy.ocr.config.AliyunOcrClient;
import com.bringspring.ecs.strategy.ocr.config.BaiduOcrClient;
import com.bringspring.ecs.strategy.ocr.config.OcrClient;
import com.bringspring.ecs.strategy.ocr.config.OcrProperties;
import com.bringspring.ecs.strategy.ocr.config.TextInOcrClient;
import com.bringspring.ecs.strategy.ocr.parse.AliyunOcrResultParseFactory;
import com.bringspring.ecs.strategy.ocr.parse.BaiduOcrResultParseFactory;
import com.bringspring.ecs.strategy.ocr.parse.InvoiceOcrResultParseFactory;
import com.bringspring.ecs.strategy.ocr.parse.TextInOcrResultParseFactory;
import com.bringspring.ecs.strategy.ocr.recognize.AliyunInvoiceOcrService;
import com.bringspring.ecs.strategy.ocr.recognize.BaiduInvoiceOcrService;
import com.bringspring.ecs.strategy.ocr.recognize.InvoiceOcrService;
import com.bringspring.ecs.strategy.ocr.recognize.TextInInvoiceOcrService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OcrConfig {
    @Bean
    public InvoiceOcrResultParseFactory<?> ocrResultParseFactory(OcrProperties ocrProperties, ApplicationContext applicationContext) {
        if ("baidu".equals(ocrProperties.getProvider())) {
            return new BaiduOcrResultParseFactory(applicationContext);
        }
        if ("aliyun".equals(ocrProperties.getProvider())) {
            return new AliyunOcrResultParseFactory(applicationContext);
        }
        if ("textin".equalsIgnoreCase(ocrProperties.getProvider())) {
            return new TextInOcrResultParseFactory(applicationContext);
        }
        return null;
    }

    @Bean
    public OcrClient<?> ocrClient(OcrProperties ocrProperties, @Autowired(required=false) InvoiceOcrResultParseFactory<?> ocrResultParseFactory) {
        if (ocrResultParseFactory instanceof BaiduOcrResultParseFactory) {
            return new BaiduOcrClient(ocrProperties.getAppId(), ocrProperties.getAccessKey(), ocrProperties.getAccessKeySecret(), (BaiduOcrResultParseFactory)ocrResultParseFactory);
        }
        if (ocrResultParseFactory instanceof AliyunOcrResultParseFactory) {
            return new AliyunOcrClient(ocrProperties.getAccessKey(), ocrProperties.getAccessKeySecret(), (AliyunOcrResultParseFactory)ocrResultParseFactory);
        }
        if (ocrResultParseFactory instanceof TextInOcrResultParseFactory) {
            return new TextInOcrClient(ocrProperties.getAppId(), ocrProperties.getAccessKeySecret(), (TextInOcrResultParseFactory)ocrResultParseFactory);
        }
        throw new IllegalStateException("No suitable OcrResultParseFactory found");
    }

    @Bean
    public InvoiceOcrService invoiceOcrService(OcrClient<?> ocrClient) {
        if (ocrClient instanceof AliyunOcrClient) {
            return new AliyunInvoiceOcrService((AliyunOcrClient)ocrClient);
        }
        if (ocrClient instanceof BaiduOcrClient) {
            return new BaiduInvoiceOcrService((BaiduOcrClient)ocrClient);
        }
        if (ocrClient instanceof TextInOcrClient) {
            return new TextInInvoiceOcrService((TextInOcrClient)ocrClient);
        }
        throw new IllegalArgumentException("Unsupported OcrClient implementation");
    }
}

