/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.aliyun.rules;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.model.CommonPrintedInvoice;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.rules.AliyunInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="aliyun_common_printed_invoice")
public class CommonPrintedInvoiceProcessor
implements AliyunInvoiceOcrResultParse {
    private static final Logger log = LoggerFactory.getLogger(CommonPrintedInvoiceProcessor.class);

    @Override
    public EcsInvoiceInfoVO parse(AliyunResult msg) {
        try {
            Map<String, Object> result = msg.getResult();
            String data = result.get("data").toString();
            CommonPrintedInvoice invoice = (CommonPrintedInvoice)JsonUtil.getJsonToBean((String)data, CommonPrintedInvoice.class);
            EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
            invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)invoice));
            invoiceInfoVO.setInvoiceCode(invoice.getInvoiceCode());
            invoiceInfoVO.setInvoiceNumber(invoice.getInvoiceNumber());
            invoiceInfoVO.setInvoiceDate(invoice.getInvoiceDate());
            invoiceInfoVO.setInvoiceSummary(invoice.getTitle());
            invoiceInfoVO.setInvoiceOp(msg.getOp());
            invoiceInfoVO.setInvoiceOpZh(msg.getType());
            invoiceInfoVO.setInvoiceType("\u901a\u7528\u673a\u6253\u53d1\u7968");
            invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
            invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
            return invoiceInfoVO;
        }
        catch (Exception e) {
            log.error("Failed to process invoice: {}", (Object)msg, (Object)e);
            return null;
        }
    }
}

