/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.aliyun.rules;

import cn.hutool.core.date.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.model.RollTicket;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.rules.AliyunInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="aliyun_roll_ticket")
public class RollTicketProcessor
implements AliyunInvoiceOcrResultParse {
    private static final Logger log = LoggerFactory.getLogger(RollTicketProcessor.class);

    @Override
    public EcsInvoiceInfoVO parse(AliyunResult msg) {
        try {
            Map<String, Object> result = msg.getResult();
            String data = result.get("data").toString();
            RollTicket invoice = (RollTicket)JsonUtil.getJsonToBean((String)data, RollTicket.class);
            EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
            invoiceInfoVO.setInvoiceNumber(invoice.getInvoiceNumber());
            invoiceInfoVO.setInvoiceCode(invoice.getInvoiceCode());
            String invoiceDate = DateUtil.format((Date)DateUtil.parse((CharSequence)invoice.getInvoiceDate(), (String)"yyyy\u5e74MM\u6708dd\u65e5"), (String)"yyyy-MM-dd");
            invoiceInfoVO.setInvoiceDate(invoiceDate);
            invoiceInfoVO.setPurchaserName(invoice.getPurchaserName());
            invoiceInfoVO.setPurchaserTaxCode(invoice.getPurchaserTaxCode());
            invoiceInfoVO.setInvoiceAmount(new BigDecimal(invoice.getTotalAmount()));
            invoiceInfoVO.setInvoiceAmountPreTax(invoiceInfoVO.getInvoiceAmount());
            invoiceInfoVO.setInvoiceAmountWords(invoice.getTotalAmountInWords());
            invoiceInfoVO.setInvoiceSummary(invoice.getTitle());
            invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
            invoiceInfoVO.setInvoiceType("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968");
            invoiceInfoVO.setInvoiceCategory("\u666e\u901a\u53d1\u7968");
            invoiceInfoVO.setInvoiceOp(msg.getOp());
            invoiceInfoVO.setInvoiceOpZh(msg.getType());
            invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)invoice));
            return invoiceInfoVO;
        }
        catch (Exception e) {
            log.error("Failed to process roll_ticket: {}", (Object)msg, (Object)e);
            return null;
        }
    }
}

