/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.aliyun.rules;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.model.TaxiTicket;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.rules.AliyunInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="aliyun_taxi_ticket")
public class TaxiTicketProcessor
implements AliyunInvoiceOcrResultParse {
    private static final Logger log = LoggerFactory.getLogger(TaxiTicketProcessor.class);

    @Override
    public EcsInvoiceInfoVO parse(AliyunResult msg) {
        try {
            Map<String, Object> result = msg.getResult();
            String data = result.get("data").toString();
            TaxiTicket taxiTicket = (TaxiTicket)JsonUtil.getJsonToBean((String)data, TaxiTicket.class);
            EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
            invoiceInfoVO.setInvoiceNumber(taxiTicket.getInvoiceNumber());
            invoiceInfoVO.setInvoiceCode(taxiTicket.getInvoiceCode());
            invoiceInfoVO.setInvoiceDate(taxiTicket.getDate());
            invoiceInfoVO.setInvoiceAmountPreTax(new BigDecimal(taxiTicket.getFare()));
            invoiceInfoVO.setTrainNumber(taxiTicket.getLicensePlateNumber());
            invoiceInfoVO.setTravelDate(taxiTicket.getDate());
            invoiceInfoVO.setInvoiceAmount(new BigDecimal(taxiTicket.getFare()));
            invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
            invoiceInfoVO.setInvoiceSummary(taxiTicket.getPickUpTime() + "\u81f3" + taxiTicket.getDropOffTime() + ",\u91cc\u7a0b" + taxiTicket.getMileage() + "\u516c\u91cc");
            invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
            invoiceInfoVO.setInvoiceType("\u51fa\u79df\u8f66\u7968");
            invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
            invoiceInfoVO.setInvoiceOp(msg.getOp());
            invoiceInfoVO.setInvoiceOpZh(msg.getType());
            invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)taxiTicket));
            return invoiceInfoVO;
        }
        catch (Exception e) {
            log.error("Failed to process taxi_invoice: {}", (Object)msg, (Object)e);
            return null;
        }
    }
}

