/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.aliyun.rules;

import cn.hutool.core.date.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.model.TrainInvoice;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.rules.AliyunInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="aliyun_train_ticket")
public class TrainTicketProcessor
implements AliyunInvoiceOcrResultParse {
    private static final Logger log = LoggerFactory.getLogger(TrainTicketProcessor.class);

    @Override
    public EcsInvoiceInfoVO parse(AliyunResult msg) {
        try {
            Map<String, Object> result = msg.getResult();
            String data = result.get("data").toString();
            TrainInvoice trainInvoice = (TrainInvoice)JsonUtil.getJsonToBean((String)data, TrainInvoice.class);
            EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
            invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)trainInvoice));
            invoiceInfoVO.setInvoiceCode(trainInvoice.getTicketCode());
            invoiceInfoVO.setInvoiceNumber(trainInvoice.getTicketNumber());
            invoiceInfoVO.setInvoiceDate(trainInvoice.getDepartureTime().substring(0, 11));
            invoiceInfoVO.setDepartureStation(trainInvoice.getDepartureStation());
            invoiceInfoVO.setArrivalStation(trainInvoice.getArrivalStation());
            invoiceInfoVO.setTrainNumber(trainInvoice.getTrainNumber());
            invoiceInfoVO.setSeatType(trainInvoice.getSeatType());
            invoiceInfoVO.setPassengerName(trainInvoice.getPassengerName());
            String travelDate = DateUtil.format((Date)DateUtil.parse((CharSequence)invoiceInfoVO.getInvoiceDate(), (String)"yyyy\u5e74MM\u6708dd\u65e5"), (String)"yyyy-MM-dd");
            invoiceInfoVO.setTravelDate(travelDate);
            invoiceInfoVO.setInvoiceAmount(new BigDecimal(trainInvoice.getFare()));
            invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
            invoiceInfoVO.setInvoiceSummary(trainInvoice.getDepartureStation() + " -- " + trainInvoice.getArrivalStation());
            BigDecimal tax = invoiceInfoVO.getInvoiceAmount().divide(new BigDecimal(1).add(new BigDecimal("0.09")), 5, RoundingMode.HALF_UP).multiply(new BigDecimal("0.09"));
            invoiceInfoVO.setDeductibleTax(tax);
            invoiceInfoVO.setInvoiceOp(msg.getOp());
            invoiceInfoVO.setInvoiceOpZh(msg.getType());
            invoiceInfoVO.setInvoiceType("\u706b\u8f66\u7968");
            invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
            invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
            return invoiceInfoVO;
        }
        catch (Exception e) {
            log.error("Failed to process train_ticket: {}", (Object)msg, (Object)e);
            return null;
        }
    }
}

