/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.baidu.rules;

import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.baidu.enums.BaiduTypeEnum;
import com.bringspring.ecs.strategy.ocr.impl.baidu.model.AirTicket;
import com.bringspring.ecs.strategy.ocr.impl.baidu.rules.BaiduInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component(value="baidu_air_ticket")
public class AirTicketProcessor
implements BaiduInvoiceOcrResultParse {
    @Override
    public EcsInvoiceInfoVO parse(BaiduResult baiduResult) {
        String op = baiduResult.getType();
        String opZh = BaiduTypeEnum.getNameByCode(op);
        String result = baiduResult.getResult();
        AirTicket airTicket = (AirTicket)JsonUtil.getJsonToBean((String)result, AirTicket.class);
        EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
        invoiceInfoVO.setServiceTypeName(this.getWord(airTicket.getServiceType()));
        invoiceInfoVO.setInvoiceCode(this.getWord(airTicket.getSerial_number()));
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)this.getWord(airTicket.getStart_date())));
        invoiceInfoVO.setInvoiceDate(invoiceDate);
        String fare = this.getWord(airTicket.getFare());
        invoiceInfoVO.setInvoiceAmountPreTax(this.replaceAndToBigDecimal(fare));
        invoiceInfoVO.setInvoiceTax(this.replaceAndToBigDecimal(this.getWord(airTicket.getOther_tax())));
        String amount = this.getWord(airTicket.getTicket_rates());
        invoiceInfoVO.setInvoiceAmount(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
        invoiceInfoVO.setInvoiceSummary(invoiceInfoVO.getDepartureStation() + " \u81f3 " + invoiceInfoVO.getArrivalStation());
        invoiceInfoVO.setDepartureStation(this.getWord(airTicket.getStarting_station()));
        invoiceInfoVO.setArrivalStation(this.getWord(airTicket.getDestination_station()));
        invoiceInfoVO.setTrainNumber(this.getWord(airTicket.getFlight()));
        invoiceInfoVO.setSeatType(this.getWord(airTicket.getSeatClass()));
        invoiceInfoVO.setPassengerName(this.getWord(airTicket.getName()));
        invoiceInfoVO.setPassengerIdNum(this.getWord(airTicket.getId_no()));
        String travelDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)this.getWord(airTicket.getDate())));
        String travelTime = DateUtil.formatTime((Date)DateUtil.parse((CharSequence)this.getWord(airTicket.getTime())));
        if (StringUtils.isBlank((CharSequence)travelTime)) {
            travelTime = "00:00:00";
        }
        invoiceInfoVO.setTravelDate(travelDate + " " + travelTime);
        invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        invoiceInfoVO.setInvoiceOp(op);
        invoiceInfoVO.setInvoiceOpZh(opZh);
        invoiceInfoVO.setInvoiceType("\u98de\u673a\u7968");
        invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)airTicket));
        return invoiceInfoVO;
    }
}

