/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.baidu.rules;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.baidu.enums.BaiduTypeEnum;
import com.bringspring.ecs.strategy.ocr.impl.baidu.model.QuotaInvoice;
import com.bringspring.ecs.strategy.ocr.impl.baidu.rules.BaiduInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import org.springframework.stereotype.Component;

@Component(value="baidu_quota_invoice")
public class QuotaInvoiceProcessor
implements BaiduInvoiceOcrResultParse {
    @Override
    public EcsInvoiceInfoVO parse(BaiduResult baiduResult) {
        String op = baiduResult.getType();
        String opZh = BaiduTypeEnum.getNameByCode(op);
        String result = baiduResult.getResult();
        QuotaInvoice quotaInvoice = (QuotaInvoice)JsonUtil.getJsonToBean((String)result, QuotaInvoice.class);
        EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
        invoiceInfoVO.setServiceTypeName(this.getWord(quotaInvoice.getServiceType()));
        invoiceInfoVO.setInvoiceNumber(this.getWord(quotaInvoice.getInvoice_number()));
        invoiceInfoVO.setInvoiceCode(this.getWord(quotaInvoice.getInvoice_code()));
        String amount = this.getWord(quotaInvoice.getInvoice_rate_in_figure());
        invoiceInfoVO.setInvoiceAmount(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
        invoiceInfoVO.setInvoiceAmountPreTax(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceTax(this.replaceAndToBigDecimal("0"));
        invoiceInfoVO.setInvoiceSummary(this.getWord(quotaInvoice.getProvince()));
        invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        invoiceInfoVO.setInvoiceOp(op);
        invoiceInfoVO.setInvoiceOpZh(opZh);
        invoiceInfoVO.setInvoiceType("\u5b9a\u989d\u53d1\u7968");
        invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)quotaInvoice));
        return invoiceInfoVO;
    }
}

