/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.baidu.rules;

import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.baidu.enums.BaiduTypeEnum;
import com.bringspring.ecs.strategy.ocr.impl.baidu.model.TaxiReceipt;
import com.bringspring.ecs.strategy.ocr.impl.baidu.rules.BaiduInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component(value="baidu_taxi_receipt")
public class TaxiReceiptProcessor
implements BaiduInvoiceOcrResultParse {
    @Override
    public EcsInvoiceInfoVO parse(BaiduResult baiduResult) {
        String op = baiduResult.getType();
        String opZh = BaiduTypeEnum.getNameByCode(op);
        String result = baiduResult.getResult();
        TaxiReceipt taxiReceipt = (TaxiReceipt)JsonUtil.getJsonToBean((String)result, TaxiReceipt.class);
        EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
        invoiceInfoVO.setServiceTypeName(this.getWord(taxiReceipt.getServiceType()));
        invoiceInfoVO.setInvoiceNumber(this.getWord(taxiReceipt.getInvoiceNum()));
        invoiceInfoVO.setInvoiceCode(this.getWord(taxiReceipt.getInvoiceCode()));
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)this.getWord(taxiReceipt.getDate())));
        invoiceInfoVO.setInvoiceDate(invoiceDate);
        String amount = this.getWord(taxiReceipt.getTotalFare());
        invoiceInfoVO.setInvoiceAmount(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceAmountPreTax(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceTax(this.replaceAndToBigDecimal("0"));
        invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
        invoiceInfoVO.setInvoiceSummary(this.getWord(taxiReceipt.getCity()));
        invoiceInfoVO.setTrainNumber(this.getWord(taxiReceipt.getTaxiNum()));
        String travelTime = DateUtil.formatTime((Date)DateUtil.parse((CharSequence)this.getWord(taxiReceipt.getPickupTime())));
        if (StringUtils.isBlank((CharSequence)travelTime)) {
            travelTime = "00:00:00";
        }
        invoiceInfoVO.setTravelDate(invoiceDate + " " + travelTime);
        invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        invoiceInfoVO.setInvoiceOp(op);
        invoiceInfoVO.setInvoiceOpZh(opZh);
        invoiceInfoVO.setInvoiceType("\u51fa\u79df\u8f66\u7968");
        invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)taxiReceipt));
        return invoiceInfoVO;
    }
}

