/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.baidu.rules;

import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.baidu.enums.BaiduTypeEnum;
import com.bringspring.ecs.strategy.ocr.impl.baidu.model.TrainTicket;
import com.bringspring.ecs.strategy.ocr.impl.baidu.rules.BaiduInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component(value="baidu_train_ticket")
public class TrainTicketProcessor
implements BaiduInvoiceOcrResultParse {
    @Override
    public EcsInvoiceInfoVO parse(BaiduResult baiduResult) {
        String op = baiduResult.getType();
        String opZh = BaiduTypeEnum.getNameByCode(op);
        String result = baiduResult.getResult();
        TrainTicket trainTicket = (TrainTicket)JsonUtil.getJsonToBean((String)result, TrainTicket.class);
        EcsInvoiceInfoVO invoiceInfoVO = new EcsInvoiceInfoVO();
        invoiceInfoVO.setDepartureStation(this.getWord(trainTicket.getStarting_station()));
        invoiceInfoVO.setArrivalStation(this.getWord(trainTicket.getDestination_station()));
        invoiceInfoVO.setTrainNumber(this.getWord(trainTicket.getTrain_num()));
        invoiceInfoVO.setSeatType(this.getWord(trainTicket.getSeat_category()));
        invoiceInfoVO.setPassengerName(this.getWord(trainTicket.getName()));
        invoiceInfoVO.setPassengerIdNum(this.getWord(trainTicket.getID_card()));
        String travelDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)this.getWord(trainTicket.getDate())));
        String travelTime = DateUtil.formatTime((Date)DateUtil.parse((CharSequence)this.getWord(trainTicket.getTime())));
        if (StringUtils.isBlank((CharSequence)travelTime)) {
            travelTime = "00:00:00";
        }
        invoiceInfoVO.setTravelDate(travelDate + " " + travelTime);
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)this.getWord(trainTicket.getInvoice_date())));
        invoiceInfoVO.setInvoiceDate(invoiceDate);
        if (StringUtils.isBlank((CharSequence)invoiceDate)) {
            invoiceInfoVO.setInvoiceDate(travelDate);
        }
        String fare = this.getWord(trainTicket.getFare());
        invoiceInfoVO.setInvoiceAmountPreTax(this.replaceAndToBigDecimal(fare));
        invoiceInfoVO.setInvoiceTax(this.replaceAndToBigDecimal(this.getWord(trainTicket.getTax())));
        invoiceInfoVO.setInvoiceTaxRate(this.getWord(trainTicket.getTaxRate()));
        String amount = this.getWord(trainTicket.getTicket_rates());
        invoiceInfoVO.setInvoiceAmount(this.replaceAndToBigDecimal(amount));
        invoiceInfoVO.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoiceInfoVO.getInvoiceAmount().doubleValue()));
        if (StringUtils.isBlank((CharSequence)invoiceInfoVO.getInvoiceTaxRate())) {
            invoiceInfoVO.setInvoiceTaxRate("9%");
        }
        if (invoiceInfoVO.getInvoiceTax() == null || invoiceInfoVO.getInvoiceTax().compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal taxRate = new BigDecimal(invoiceInfoVO.getInvoiceTaxRate().replace("%", "")).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
            BigDecimal preTaxAmount = invoiceInfoVO.getInvoiceAmount().divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            invoiceInfoVO.setInvoiceAmountPreTax(preTaxAmount);
            invoiceInfoVO.setInvoiceTax(invoiceInfoVO.getInvoiceAmount().subtract(preTaxAmount));
        }
        invoiceInfoVO.setInvoiceSummary(invoiceInfoVO.getDepartureStation() + " \u81f3 " + invoiceInfoVO.getArrivalStation());
        String elecTicketNum = this.getWord(trainTicket.getElec_ticket_num());
        if (StringUtils.isNotBlank((CharSequence)elecTicketNum)) {
            invoiceInfoVO.setInvoiceKind("\u7535\u5b50\u53d1\u7968");
            invoiceInfoVO.setInvoiceNumber(this.getWord(trainTicket.getInvoice_num()));
        } else {
            invoiceInfoVO.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
            invoiceInfoVO.setInvoiceNumber(this.getWord(trainTicket.getTicket_num()));
        }
        invoiceInfoVO.setSpecialMark(this.getWord(trainTicket.getRefund_flag()));
        invoiceInfoVO.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        invoiceInfoVO.setInvoiceOp(op);
        invoiceInfoVO.setInvoiceOpZh(opZh);
        invoiceInfoVO.setInvoiceType("\u706b\u8f66\u7968");
        invoiceInfoVO.setExtendedFields(JsonUtil.getObjectToString((Object)trainTicket));
        return invoiceInfoVO;
    }
}

