/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.strategy.ocr.model.ProductInfo;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_electronic_medical_invoice")
public class ElectronicMedicalInvoice
implements TextInInvoiceResultParse {
    private static final String[] FIRST_CLASS = new String[]{"F", "A"};
    private static final String[] BUSINESS_CLASS = new String[]{"C", "D"};

    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        List<Map<String, String>> productList = this.parseResultToList(result.getProduct_list());
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        invoice.setServiceTypeCode(result.getKind());
        String nameByCode = TextInServiceType.getNameByCode(result.getKind());
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceOpZh("\u7535\u5b50\u533b\u7597\u53d1\u7968");
        invoice.setInvoiceType("\u7535\u5b50\u533b\u7597\u53d1\u7968");
        invoice.setInvoiceTitle(itemMap.get("title"));
        invoice.setInvoiceNumber(itemMap.get("invoice_number"));
        invoice.setInvoiceCode(itemMap.get("invoice_code"));
        String date = itemMap.get("date");
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)date));
        invoice.setInvoiceDate(invoiceDate);
        invoice.setSellerName(itemMap.get("cashier_company"));
        invoice.setSellerTaxCode(null);
        invoice.setPurchaserName(itemMap.get("payer"));
        invoice.setPurchaserTaxCode(itemMap.get("payer_uniform_social_credit_code"));
        invoice.setPurchaserBankAccountInfo(null);
        invoice.setPurchaserContactInfo(null);
        invoice.setInvoiceAmountPreTax(this.replaceAndToBigDecimal(itemMap.get("amount_digital")));
        invoice.setInvoiceTax(BigDecimal.ZERO);
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("amount_digital")));
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        invoice.setDeductibleTax(BigDecimal.ZERO);
        String summary = "";
        ArrayList<ProductInfo> productInfos = new ArrayList<ProductInfo>();
        String productNames = "";
        for (Map<String, String> stringStringMap : productList) {
            ProductInfo productInfo = new ProductInfo();
            productInfo.setProductName(stringStringMap.get("project_name_table"));
            productInfo.setProductType("");
            productInfo.setProductUnit(stringStringMap.get("unit_table"));
            productInfo.setProductNum(stringStringMap.get("number_table"));
            productInfo.setProductPrice("");
            productInfo.setProductAmount(stringStringMap.get("amount_table"));
            productInfo.setProductTaxRate("");
            productInfo.setProductTax("");
            if (!summary.contains(productInfo.getProductName())) {
                summary = summary + productInfo.getProductName() + ";";
            }
            productNames = productNames + productInfo.getProductName();
            productInfos.add(productInfo);
        }
        invoice.setInvoiceTaxRate(null);
        invoice.setCommodityInfo(JsonUtil.getObjectToString(productInfos));
        invoice.setInvoiceSummary(summary);
        invoice.setPayee(itemMap.get("cashier"));
        invoice.setReview(itemMap.get("reviewer"));
        invoice.setDrawer(null);
        invoice.setInvoiceType("\u7535\u5b50\u533b\u7597\u53d1\u7968");
        invoice.setInvoiceKind("\u7535\u5b50\u53d1\u7968");
        invoice.setInvoiceCategory("\u533b\u7597\u7968\u636e");
        invoice.setInvoiceOpZh("\u7535\u5b50\u533b\u7597\u53d1\u7968");
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        invoice.setExistInvoiceSeal(true);
        return invoice;
    }
}

