/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_general_machine_invoice")
public class GeneralMachineInvoice
implements TextInInvoiceResultParse {
    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        invoice.setServiceTypeCode(result.getKind());
        String nameByCode = TextInServiceType.getNameByCode(result.getKind());
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceOpZh("\u901a\u7528\u673a\u6253\u53d1\u7968");
        invoice.setInvoiceType("\u901a\u7528\u673a\u6253\u53d1\u7968");
        invoice.setInvoiceNumber(itemMap.get("invoice_number"));
        invoice.setInvoiceCode(itemMap.get("invoice_code"));
        String date = itemMap.get("date");
        String time = itemMap.get("time");
        String oldDate = date + (StringUtils.isBlank((CharSequence)time) ? " 00:00:00" : " " + time);
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)oldDate));
        invoice.setInvoiceDate(invoiceDate);
        invoice.setSellerName(itemMap.get("seller"));
        invoice.setSellerTaxCode(itemMap.get("seller_tax_id"));
        invoice.setPurchaserName(itemMap.get("buyer"));
        invoice.setPurchaserTaxCode(itemMap.get("buyer_tax_id"));
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("total")));
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        invoice.setInvoiceSummary("");
        invoice.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoice.setInvoiceCategory("\u666e\u901a\u53d1\u7968");
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        invoice.setCheckCode(null);
        invoice.setInvoiceSum(null);
        String existInvoiceSeal = itemMap.get("exist_invoice_seal");
        invoice.setExistInvoiceSeal(false);
        if ("True".equals(existInvoiceSeal)) {
            invoice.setExistInvoiceSeal(true);
        }
        return invoice;
    }
}

