/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.strategy.ocr.model.ProductInfo;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_non_tax_income_unified_bill")
public class NonTaxIncomeUnifiedBill
implements TextInInvoiceResultParse {
    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        List<Map<String, String>> productList = this.parseResultToList(result.getProduct_list());
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        invoice.setServiceTypeCode(result.getKind());
        String nameByCode = TextInServiceType.getNameByCode(result.getKind());
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceOpZh("\u975e\u7a0e\u6536\u5165\u7edf\u4e00\u7968\u636e");
        invoice.setInvoiceType("\u975e\u7a0e\u6536\u5165\u7edf\u4e00\u7968\u636e");
        invoice.setCipher(null);
        invoice.setInvoiceNumber(itemMap.get("invoice_number"));
        invoice.setInvoiceCode(itemMap.get("invoice_code"));
        String date = itemMap.get("issued_date");
        String invoiceDate = DateUtil.formatDate((Date)DateUtil.parse((CharSequence)date));
        invoice.setInvoiceDate(invoiceDate);
        invoice.setSellerName(null);
        invoice.setSellerTaxCode(null);
        invoice.setPurchaserName(itemMap.get("payer"));
        invoice.setPurchaserTaxCode(itemMap.get("payer_tax_id"));
        invoice.setSellerName(itemMap.get("invoicing_party_name"));
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("total_digits")));
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        ArrayList<ProductInfo> productInfos = new ArrayList<ProductInfo>();
        for (Map<String, String> stringStringMap : productList) {
            ProductInfo productInfo = new ProductInfo();
            productInfo.setProductName(stringStringMap.get("item_name"));
            productInfo.setProductUnit(stringStringMap.get("item_unit"));
            productInfo.setProductNum(stringStringMap.get("item_quantity"));
            productInfo.setProductAmount(stringStringMap.get("item_amount"));
            productInfos.add(productInfo);
        }
        invoice.setCommodityInfo(JsonUtil.getObjectToString(productInfos));
        invoice.setInvoiceSummary("");
        invoice.setInvoiceTitle(itemMap.get("title"));
        invoice.setReview(itemMap.get("checker"));
        invoice.setPayee(itemMap.get("payee"));
        invoice.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoice.setInvoiceCategory("\u666e\u901a\u53d1\u7968");
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        invoice.setCheckCode(itemMap.get("check_code"));
        invoice.setInvoiceSum(invoice.getInvoiceAmount());
        invoice.setExistInvoiceSeal(true);
        return invoice;
    }
}

