/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import com.bringspring.ecs.utils.OcrDateUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_taxi_ticket")
public class TaxiTicket
implements TextInInvoiceResultParse {
    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        invoice.setServiceTypeCode(result.getKind());
        String nameByCode = TextInServiceType.getNameByCode(result.getKind());
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceOpZh("\u51fa\u79df\u8f66\u7968");
        invoice.setInvoiceType("\u51fa\u79df\u8f66\u7968");
        invoice.setCipher(null);
        invoice.setInvoiceNumber(itemMap.get("invoice_no"));
        invoice.setInvoiceCode(itemMap.get("invoice_code"));
        String date = itemMap.get("date");
        LocalDate localDate = OcrDateUtil.parseDate(date);
        String invoiceDate = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        invoice.setInvoiceDate(invoiceDate);
        invoice.setPassengerName(itemMap.get("passenger_name"));
        invoice.setPassengerIdNum(itemMap.get("passenger_id"));
        String vatInvoiceTime = itemMap.getOrDefault("boarding_time", "");
        if (!vatInvoiceTime.isEmpty()) {
            invoice.setTravelDate(invoiceDate + " " + vatInvoiceTime + ":00");
        }
        invoice.setDepartureStation(itemMap.get("location"));
        invoice.setArrivalStation(null);
        invoice.setTrainNumber(itemMap.get("taxi_no"));
        invoice.setSeatType(null);
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("sum")));
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        invoice.setInvoiceTaxRate("0%");
        invoice.setInvoiceAmountPreTax(invoice.getInvoiceAmount());
        invoice.setInvoiceTax(BigDecimal.ZERO);
        invoice.setDeductibleTax(BigDecimal.ZERO);
        String summary = invoice.getDepartureStation();
        invoice.setInvoiceSummary(summary);
        invoice.setPayee(null);
        invoice.setReview(null);
        invoice.setDrawer(null);
        invoice.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoice.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        invoice.setCheckCode(null);
        invoice.setInvoiceSum(null);
        String existInvoiceSeal = itemMap.get("exist_invoice_seal");
        invoice.setExistInvoiceSeal(false);
        if ("True".equals(existInvoiceSeal)) {
            invoice.setExistInvoiceSeal(true);
        }
        return invoice;
    }
}

