/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.impl.textin.rules;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInServiceType;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInItem;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.rules.TextInInvoiceResultParse;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import com.bringspring.ecs.utils.OcrDateUtil;
import com.bringspring.ecs.utils.OcrTimeUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="textin_vehicle_toll")
public class VehicleToll
implements TextInInvoiceResultParse {
    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        LocalDate localDate;
        List<TextInItem> itemList = result.getItemList();
        Map<String, String> itemMap = this.parseResultToMap(itemList);
        EcsInvoiceInfoVO invoice = new EcsInvoiceInfoVO();
        String kind = "traffic";
        invoice.setServiceTypeCode(kind);
        String nameByCode = TextInServiceType.getNameByCode(kind);
        invoice.setServiceTypeName(nameByCode);
        invoice.setInvoiceOp(result.getType());
        invoice.setInvoiceOpZh("\u8fc7\u8def\u8fc7\u6865\u8d39\u53d1\u7968");
        invoice.setInvoiceType("\u8fc7\u8def\u8fc7\u6865\u8d39\u53d1\u7968");
        invoice.setCipher(null);
        String title = itemMap.get("title");
        invoice.setInvoiceTitle(title);
        invoice.setInvoiceNumber(itemMap.get("toll_number"));
        invoice.setInvoiceCode(itemMap.get("toll_code"));
        String date = itemMap.get("date");
        String time = itemMap.get("time");
        String invoiceDate = "";
        if (StringUtils.isNotBlank((CharSequence)date) && (localDate = OcrDateUtil.parseDate(date)) != null) {
            invoiceDate = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            invoice.setInvoiceDate(invoiceDate);
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceDate)) {
            invoice.setTravelDate(invoiceDate);
            if (StringUtils.isNotBlank((CharSequence)time)) {
                String times = OcrTimeUtil.convertToStandardTime(time);
                invoiceDate = invoiceDate + " " + times;
                invoice.setTravelDate(invoiceDate);
            }
        }
        invoice.setInvoiceAmount(this.replaceAndToBigDecimal(itemMap.get("money")));
        invoice.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(invoice.getInvoiceAmount().doubleValue()));
        invoice.setInvoiceTaxRate("5%");
        BigDecimal taxRate = new BigDecimal(invoice.getInvoiceTaxRate().replace("%", "")).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
        BigDecimal preTaxAmount = invoice.getInvoiceAmount().divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
        invoice.setInvoiceAmountPreTax(preTaxAmount);
        invoice.setInvoiceTax(invoice.getInvoiceAmount().subtract(preTaxAmount));
        invoice.setDepartureStation(itemMap.get("entrance"));
        invoice.setArrivalStation(itemMap.get("exit"));
        invoice.setInvoiceSummary(title);
        invoice.setPayee(null);
        invoice.setReview(null);
        invoice.setDrawer(null);
        invoice.setInvoiceKind("\u7eb8\u8d28\u53d1\u7968");
        invoice.setInvoiceCategory("\u4e13\u7528\u53d1\u7968");
        invoice.setExtendedFields(JsonUtil.getObjectToString((Object)result));
        String existInvoiceSeal = itemMap.get("exist_invoice_seal");
        invoice.setExistInvoiceSeal(false);
        if ("True".equals(existInvoiceSeal)) {
            invoice.setExistInvoiceSeal(true);
        }
        return invoice;
    }
}

