/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.parse;

import com.bringspring.common.exception.DataException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.impl.aliyun.rules.AliyunInvoiceOcrResultParse;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import com.bringspring.ecs.strategy.ocr.parse.InvoiceOcrResultParseFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AliyunOcrResultParseFactory
implements InvoiceOcrResultParseFactory<AliyunResult> {
    private final ApplicationContext applicationContext;

    public AliyunOcrResultParseFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public EcsInvoiceInfoVO parse(AliyunResult result) throws DataException {
        String type = "aliyun_" + result.getOp();
        AliyunInvoiceOcrResultParse parser = (AliyunInvoiceOcrResultParse)this.applicationContext.getBean(type, AliyunInvoiceOcrResultParse.class);
        EcsInvoiceInfoVO parsed = parser.parse(result);
        if (parsed == null) {
            throw new DataException("\u6682\u4e0d\u652f\u6301\u8be5\u53d1\u7968");
        }
        parsed.setOcrSource("aliyun");
        return parsed;
    }
}

