/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.recognize;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.config.OcrClient;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import com.bringspring.ecs.strategy.ocr.recognize.InvoiceOcrService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class AliyunInvoiceOcrService
implements InvoiceOcrService {
    private static final Logger log = LoggerFactory.getLogger(AliyunInvoiceOcrService.class);
    private final OcrClient<AliyunResult> ocrClient;

    public AliyunInvoiceOcrService(OcrClient<AliyunResult> ocrClient) {
        this.ocrClient = ocrClient;
    }

    @Override
    public EcsInvoiceInfoVO ocr(MultipartFile file, String suffix, Boolean prevHandleImage) throws Exception {
        String data = this.ocrClient.recognize(file, suffix, prevHandleImage);
        AliyunResult aliyunResult = (AliyunResult)JsonUtil.getJsonToBean((String)data, AliyunResult.class);
        return this.ocrClient.parse(aliyunResult);
    }
}

