/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.records.rules;

import cn.hutool.core.collection.CollUtil;
import com.bringspring.ecs.exception.RecordsValidateException;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentInfoVO;
import com.bringspring.ecs.model.records.EcsRecordsInfoVO;
import com.bringspring.ecs.model.subject.EcsRecordsChargesDetailInfoVO;
import com.bringspring.ecs.strategy.records.RecordsValidate;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import com.bringspring.ecs.strategy.validate.enums.ValidateCustomizableType;
import java.util.List;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0)
@Component
@ValidateService(value="\u501f\u6b3e\u79d1\u76ee\u548c\u8fd8\u6b3e\u79d1\u76ee\u4e00\u81f4", ruleType=RuleType.ALWAYS, customizableType=ValidateCustomizableType.NO)
public class AdvanceEqualSubject
implements RecordsValidate {
    @Override
    public void validate(EcsRecordsInfoVO records, AnnotationContext context, boolean throwErr) throws RecordsValidateException {
        List<EcsRecordsChargesDetailInfoVO> subjectList = records.getSubjectList();
        List<EcsAdvancePaymentInfoVO> advanceList = records.getAdvanceList();
        if (CollUtil.isNotEmpty(subjectList) && CollUtil.isNotEmpty(advanceList)) {
            String firstSubjectCode = subjectList.get(0).getSubjectCode();
            boolean allSameSubject = subjectList.stream().allMatch(subject -> firstSubjectCode.equals(subject.getSubjectCode()));
            String firstAdvanceCode = advanceList.get(0).getSubjectCode();
            boolean allAdvanceCode = advanceList.stream().allMatch(advance -> firstAdvanceCode.equals(advance.getSubjectCode()));
            if (!allSameSubject || !allAdvanceCode) {
                String errorMsg = "\u501f\u6b3e\u6838\u9500\u53ea\u80fd\u5355\u7b14\u8d39\u7528\u79d1\u76ee\uff0c\u4e0d\u80fd\u5305\u542b\u591a\u4e2a\u4e0d\u540c\u7684\u79d1\u76ee";
                throw new RecordsValidateException(errorMsg);
            }
            if ("0001".equals(firstAdvanceCode)) {
                return;
            }
            if (!firstAdvanceCode.equals(firstSubjectCode)) {
                String errorMsg = "\u501f\u6b3e\u79d1\u76ee\u548c\u8fd8\u6b3e\u79d1\u76ee\u4e0d\u4e00\u81f4";
                throw new RecordsValidateException(errorMsg);
            }
        }
    }
}

