/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.records.rules;

import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.exception.RecordsValidateException;
import com.bringspring.ecs.model.records.EcsRecordsInfoVO;
import com.bringspring.ecs.service.EcsBankCardService;
import com.bringspring.ecs.strategy.records.RecordsValidate;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import com.bringspring.ecs.strategy.validate.enums.ValidateCustomizableType;
import java.io.Serializable;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0)
@Component
@ValidateService(value="\u94f6\u884c\u5361\u8d26\u6237\u9700\u6709\u8054\u884c\u53f7", ruleType=RuleType.ALWAYS, customizableType=ValidateCustomizableType.NO)
public class BankFirmRequire
implements RecordsValidate {
    @Autowired
    private EcsBankCardService ecsBankCardService;

    @Override
    public void validate(EcsRecordsInfoVO records, AnnotationContext context, boolean throwErr) throws RecordsValidateException {
        String bankCardId = records.getBankCardId();
        if (records.getStatus() == 0) {
            return;
        }
        if (bankCardId == null || bankCardId.isEmpty()) {
            throw new RecordsValidateException("\u8bf7\u9009\u62e9\u94f6\u884c\u5361\u8d26\u6237");
        }
        EcsBankCardEntity bankCard = (EcsBankCardEntity)this.ecsBankCardService.getById((Serializable)((Object)bankCardId));
        if (bankCard == null) {
            throw new RecordsValidateException("\u94f6\u884c\u5361\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)bankCard.getBankFirmCode())) {
            throw new RecordsValidateException("\u94f6\u884c\u5361\u8d26\u6237\u9700\u6709\u8054\u884c\u53f7");
        }
        if ("01".equals(bankCard.getCollectionAccount())) {
            records.setPayableAmount(BigDecimal.ZERO);
        }
    }
}

