/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.handler.after;

import com.bringspring.ecs.enums.InvoiceKindEnum;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateHandler;
import com.bringspring.ecs.strategy.validate.annotation.InvoiceValidateAspect;
import java.math.BigDecimal;
import org.springframework.stereotype.Component;

@Component
@InvoiceValidateAspect(type=InvoiceValidateAspect.AspectType.AFTER, order=3)
public class InvoiceAmountNullAfterHandler
implements InvoiceValidateHandler {
    @Override
    public void handle(EcsInvoiceInfoVO invoice, AnnotationContext context) {
        if (invoice.getInvoiceAmount() == null) {
            invoice.setInvoiceAmount(BigDecimal.ZERO);
        }
        if (BigDecimal.ZERO.compareTo(invoice.getInvoiceAmount()) == 0) {
            context.addAnnotation("OCR\u8bc6\u522b\u53d1\u7968\u91d1\u989d\u4e3a\u7a7a");
            context.addErrorFields("invoiceAmount");
        }
        if (InvoiceKindEnum.PAPER_INVOICE.getName().equals(invoice.getInvoiceKind())) {
            context.addErrorFields("invoiceAmount");
        }
    }
}

