/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import cn.hutool.core.collection.CollUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.enums.ConfigServiceTypeEnum;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.ocr.model.ProductInfo;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=5)
@Component
@ValidateService(value="\u8d39\u7528\u7c7b\u578b\u548c\u4e0a\u4f20\u53d1\u7968\u4e00\u81f4", ruleType=RuleType.ALWAYS)
public class ChargesTypeValidateStrategy
implements InvoiceValidateStrategy {
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        Object reimbType = context.getMetaData("reimbType");
        Object companyId = context.getMetaData("companyId");
        if (Objects.isNull(reimbType)) {
            throw new InvoiceValidateException("\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        EcsConfigEntity config = this.ecsConfigService.getByKeyName(reimbType.toString(), companyId.toString());
        if (Objects.nonNull(config)) {
            String name = config.getName();
            String ruleKey = config.getRuleKey();
            String keyValue = config.getKeyValue();
            if (StringUtils.isBlank((CharSequence)keyValue)) {
                throw new InvoiceValidateException("\u8bf7\u4e0a\u4f20" + name + "\u76f8\u5173\u53d1\u7968");
            }
            if (ConfigServiceTypeEnum.SERVICE_TYPE.getCode().equalsIgnoreCase(ruleKey)) {
                String[] keyValues;
                for (String value : keyValues = keyValue.split(",")) {
                    if (!value.equalsIgnoreCase(invoice.getServiceTypeCode())) continue;
                    return;
                }
                throw new InvoiceValidateException("\u8bf7\u4e0a\u4f20" + name + "\u76f8\u5173\u53d1\u7968");
            }
            if (ConfigServiceTypeEnum.PRODUCT_NAME.getCode().equalsIgnoreCase(ruleKey)) {
                String[] keyValues;
                String commodityInfo = invoice.getCommodityInfo();
                if (StringUtils.isBlank((CharSequence)commodityInfo)) {
                    throw new InvoiceValidateException("\u8bf7\u4e0a\u4f20" + name + "\u76f8\u5173\u53d1\u7968");
                }
                List jsonToList = JsonUtil.getJsonToList((String)commodityInfo, ProductInfo.class);
                for (String value : keyValues = keyValue.split(",")) {
                    for (ProductInfo productInfo : jsonToList) {
                        if (!productInfo.getProductName().contains(value)) continue;
                        return;
                    }
                }
                throw new InvoiceValidateException("\u8bf7\u4e0a\u4f20" + name + "\u76f8\u5173\u53d1\u7968");
            }
            if (ConfigServiceTypeEnum.MIX.getCode().equalsIgnoreCase(ruleKey)) {
                List jsonToList;
                try {
                    jsonToList = JsonUtil.getJsonToListMap((String)keyValue);
                }
                catch (Exception e) {
                    throw new InvoiceValidateException("\u8d39\u7528\u7c7b\u578b\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (CollUtil.isNotEmpty((Collection)jsonToList)) {
                    for (Map stringObjectMap : jsonToList) {
                        String invoiceOp;
                        Object serviceTypeObj = stringObjectMap.get(ConfigServiceTypeEnum.SERVICE_TYPE.getCode());
                        Object productNameObj = stringObjectMap.get(ConfigServiceTypeEnum.PRODUCT_NAME.getCode());
                        Object invoiceOpObj = stringObjectMap.get(ConfigServiceTypeEnum.INVOICE_OP.getCode());
                        String serviceType = serviceTypeObj != null ? serviceTypeObj.toString() : null;
                        String productName = productNameObj != null ? productNameObj.toString() : null;
                        String string = invoiceOp = invoiceOpObj != null ? invoiceOpObj.toString() : null;
                        if (!(serviceType != null && !StringUtils.isBlank((CharSequence)serviceType) && !"*".equalsIgnoreCase(serviceType) || productName != null && !StringUtils.isBlank((CharSequence)productName) || invoiceOp != null && !StringUtils.isBlank((CharSequence)invoiceOp) && !"*".equalsIgnoreCase(invoiceOp))) continue;
                        boolean serviceTypeMatch = true;
                        if (serviceType != null && !StringUtils.isBlank((CharSequence)serviceType) && !"*".equalsIgnoreCase(serviceType)) {
                            serviceTypeMatch = serviceType.equalsIgnoreCase(invoice.getServiceTypeCode());
                        }
                        if (!serviceTypeMatch) continue;
                        boolean invoiceOpMatch = true;
                        if (invoiceOp != null && !StringUtils.isBlank((CharSequence)invoiceOp) && !"*".equalsIgnoreCase(invoiceOp)) {
                            invoiceOpMatch = invoiceOp.equalsIgnoreCase(invoice.getInvoiceOp());
                        }
                        if (!invoiceOpMatch) continue;
                        boolean productNameMatch = true;
                        if (productName != null && !StringUtils.isBlank((CharSequence)productName)) {
                            List productInfoList;
                            productNameMatch = false;
                            String commodityInfo = invoice.getCommodityInfo();
                            if (StringUtils.isNotBlank((CharSequence)commodityInfo) && CollUtil.isNotEmpty((Collection)(productInfoList = JsonUtil.getJsonToList((String)commodityInfo, ProductInfo.class)))) {
                                for (ProductInfo info : productInfoList) {
                                    if (!info.getProductName().contains(productName)) continue;
                                    productNameMatch = true;
                                    break;
                                }
                            }
                        }
                        if (!productNameMatch) continue;
                        return;
                    }
                }
                throw new InvoiceValidateException("\u8bf7\u4e0a\u4f20" + name + "\u76f8\u5173\u53d1\u7968");
            }
        }
    }
}

